/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSuspiciousNameCombinationInspectionBase
extends JSInspection {
    protected final List<String> myNameGroups = new ArrayList<String>();
    private final Map<String, String> myWordToGroupMap = new HashMap();
    private final Set<String> myExcludedClasses = new HashSet();
    protected String myExcludedClassNames = "Math";
    @NonNls
    private static final String ELEMENT_GROUPS = "group";
    @NonNls
    private static final String ATTRIBUTE_NAMES = "names";
    @NonNls
    private static final String ELEMENT_EXCLUDE = "exclude";
    @NonNls
    private static final String ATTRIBUTE_CLASSES = "classes";

    public JSSuspiciousNameCombinationInspectionBase() {
        this.addNameGroup("x,width,left,right");
        this.addNameGroup("y,height,top,bottom");
        this.addExcludedClasses();
    }

    protected void addNameGroup(String nameGroup) {
        this.myNameGroups.add(nameGroup);
        List words = StringUtil.split((String)nameGroup, (String)",");
        for (String word : words) {
            this.myWordToGroupMap.put(word.trim().toLowerCase(), nameGroup);
        }
    }

    private void addExcludedClasses() {
        List classNames = StringUtil.split((String)this.myExcludedClassNames, (String)",");
        for (String className : classNames) {
            this.myExcludedClasses.add(className.trim());
        }
    }

    protected void addExcludedClasses(String classNames) {
        this.myExcludedClassNames = classNames;
        this.addExcludedClasses();
    }

    protected void clearNameGroups() {
        this.myNameGroups.clear();
        this.myWordToGroupMap.clear();
    }

    protected void clearExcludedClasses() {
        this.myExcludedClasses.clear();
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.suspicious.name.combination.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSSuspiciousNameCombinationInspectionBase", "getDisplayName"));
        }
        return string;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSSuspiciousNameCombinationInspectionBase", "readSettings"));
        }
        this.clearNameGroups();
        for (Object o : node.getChildren(ELEMENT_GROUPS)) {
            Element e = (Element)o;
            this.addNameGroup(e.getAttributeValue(ATTRIBUTE_NAMES));
        }
        Element child = node.getChild(ELEMENT_EXCLUDE);
        this.clearExcludedClasses();
        if (child != null) {
            this.addExcludedClasses(child.getAttributeValue(ATTRIBUTE_CLASSES));
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSSuspiciousNameCombinationInspectionBase", "writeSettings"));
        }
        for (String group : this.myNameGroups) {
            Element e = new Element(ELEMENT_GROUPS);
            node.addContent(e);
            e.setAttribute(ATTRIBUTE_NAMES, group);
        }
        Element e = new Element(ELEMENT_EXCLUDE);
        node.addContent(e);
        e.setAttribute(ATTRIBUTE_CLASSES, this.myExcludedClassNames);
    }

    private boolean isExcluded(JSReferenceExpression referenceExpression) {
        JSExpression qualifier = referenceExpression.getQualifier();
        if (qualifier instanceof JSReferenceExpression) {
            PsiElement element = ((JSReferenceExpression)qualifier).resolve();
            String name = null;
            if (element instanceof JSClass) {
                name = ((JSClass)element).getName();
            } else if (element instanceof JSVariable) {
                JSClass jsClass;
                JSType type = ((JSVariable)element).getType();
                JSClass jSClass = jsClass = type != null ? type.resolveClass() : null;
                if (jsClass != null) {
                    name = jsClass.getName();
                }
            }
            return name != null && this.myExcludedClasses.contains(name);
        }
        return false;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSVariable(JSVariable node) {
                JSExpression initializer;
                if (node.hasInitializer() && (initializer = node.getInitializer()) instanceof JSReferenceExpression) {
                    String referencedName = ((JSReferenceExpression)initializer).getReferencedName();
                    String name = node.getName();
                    if (JSSuspiciousNameCombinationInspectionBase.this.isSuspiciousNameCombination(name, referencedName)) {
                        holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.suspicious.name.assignment", (Object[])new Object[]{referencedName, name}), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitJSAssignmentExpression(JSAssignmentExpression node) {
                JSExpression lOperand = node.getLOperand();
                JSExpression rOperand = node.getROperand();
                if (lOperand instanceof JSDefinitionExpression) {
                    lOperand = ((JSDefinitionExpression)lOperand).getExpression();
                }
                if (lOperand instanceof JSReferenceExpression && rOperand instanceof JSReferenceExpression) {
                    String name2;
                    if (JSSuspiciousNameCombinationInspectionBase.this.isExcluded((JSReferenceExpression)lOperand)) {
                        return;
                    }
                    String name1 = ((JSReferenceExpression)lOperand).getReferencedName();
                    if (JSSuspiciousNameCombinationInspectionBase.this.isSuspiciousNameCombination(name1, name2 = ((JSReferenceExpression)rOperand).getReferencedName())) {
                        holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.suspicious.name.assignment", (Object[])new Object[]{name2, name1}), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitJSCallExpression(JSCallExpression node) {
                JSExpression methodExpression = node.getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression) {
                    JSArgumentList argumentList;
                    if (JSSuspiciousNameCombinationInspectionBase.this.isExcluded((JSReferenceExpression)methodExpression)) {
                        return;
                    }
                    PsiElement method = ((JSReferenceExpression)methodExpression).resolve();
                    if (method instanceof JSFunction && (argumentList = node.getArgumentList()) != null) {
                        JSExpression[] arguments = argumentList.getArguments();
                        JSParameter[] parameters = ((JSFunction)method).getParameters();
                        for (int i = 0; i < parameters.length && i < arguments.length; ++i) {
                            String name;
                            String referencedName;
                            JSExpression argument = arguments[i];
                            if (!(argument instanceof JSReferenceExpression) || JSSuspiciousNameCombinationInspectionBase.this.findNameGroup(referencedName = ((JSReferenceExpression)argument).getReferencedName()) == null || !JSSuspiciousNameCombinationInspectionBase.this.isSuspiciousNameCombination(name = parameters[i].getName(), referencedName)) continue;
                            holder.registerProblem((PsiElement)argument, JSBundle.message((String)"js.suspicious.name.parameter", (Object[])new Object[]{referencedName, name}), new LocalQuickFix[0]);
                        }
                    }
                }
            }

            public void visitJSReturnStatement(JSReturnStatement node) {
                String referencedName;
                String functionName;
                JSFunction function;
                JSExpression expression = node.getExpression();
                if (expression instanceof JSReferenceExpression && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class)) != null && JSSuspiciousNameCombinationInspectionBase.this.isSuspiciousNameCombination(functionName = function.getName(), referencedName = ((JSReferenceExpression)expression).getReferencedName())) {
                    holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.suspicious.name.return", (Object[])new Object[]{referencedName, functionName}), new LocalQuickFix[0]);
                }
            }

            public void visitJSProperty(JSProperty node) {
                String referencedName;
                String name;
                JSExpression value = node.getValue();
                if (value instanceof JSReferenceExpression && JSSuspiciousNameCombinationInspectionBase.this.isSuspiciousNameCombination(name = node.getName(), referencedName = ((JSReferenceExpression)value).getReferencedName())) {
                    holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.suspicious.name.assignment", (Object[])new Object[]{referencedName, name}), new LocalQuickFix[0]);
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSSuspiciousNameCombinationInspectionBase", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private boolean isSuspiciousNameCombination(@Nullable String name1, @Nullable String name2) {
        String nameGroup1 = this.findNameGroup(name1);
        String nameGroup2 = this.findNameGroup(name2);
        return nameGroup1 != null && nameGroup2 != null && !nameGroup1.equals(nameGroup2);
    }

    @Nullable
    private String findNameGroup(@Nullable String name) {
        if (name == null) {
            return null;
        }
        String[] words = NameUtil.splitNameIntoWords((String)name);
        String result = null;
        for (String word : words) {
            String group = this.myWordToGroupMap.get(word.toLowerCase());
            if (group == null) continue;
            if (result == null) {
                result = group;
                continue;
            }
            if (result.equals(group)) continue;
            result = null;
            break;
        }
        return result;
    }
}

