/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowProcessor;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnusedAssignmentInspection
extends JSInspection {
    @NonNls
    public static final String SHORT_NAME = "JSUnusedAssignment";

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.unused.assignment.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnusedAssignmentInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnusedAssignmentInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnusedAssignmentInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                this.visitJSFunctionDeclaration((JSFunction)node);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                this.processDataFlow((JSExecutionScope)node);
            }

            public void visitJSEmbeddedContent(JSEmbeddedContent embeddedContent) {
                this.processDataFlow((JSExecutionScope)embeddedContent);
            }

            public void visitJSFile(JSFile file) {
                if (file.getContext() == null) {
                    this.processDataFlow((JSExecutionScope)file);
                }
            }

            private void processDataFlow(JSExecutionScope scope) {
                THashMap variablesReadWithoutInitialization = new THashMap(2);
                THashMap valuesOverwritten = new THashMap();
                THashMap variablesWritten = new THashMap();
                THashSet variablesReferencedInInners = new THashSet(2);
                THashSet readAtLeastOnce = new THashSet();
                JSControlFlowUtils.processControlFlowFor(scope, new SimpleControlFlowProcessor((Map<JSVariable, Map<JSExpression, Boolean>>)variablesWritten, (Map<JSExpression, JSVariable>)variablesReadWithoutInitialization, (Set<JSVariable>)readAtLeastOnce, (Set<String>)variablesReferencedInInners, (Map<JSExpression, JSVariable>)valuesOverwritten));
                for (Map.Entry e : variablesReadWithoutInitialization.entrySet()) {
                    if (!this.isElementFromProperScope((JSVariable)e.getValue(), scope)) continue;
                    JSExpression jSExpression = (JSExpression)e.getKey();
                    holder.registerProblem((PsiElement)jSExpression, JSBundle.message((String)"js.variable.might.not.been.initialized", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                }
                JSUnusedLocalSymbolsInspection.LocalLiteralOccurrenceChecker checker = null;
                for (JSVariable jSVariable : variablesWritten.keySet()) {
                    if (scope instanceof JSFile || scope instanceof JSEmbeddedContent || !this.isElementFromProperScope(jSVariable, scope)) continue;
                    Map values = (Map)variablesWritten.get(jSVariable);
                    for (JSExpression e : values.keySet()) {
                        PsiElement eParent;
                        String name;
                        if (values.get(e) != null || variablesReferencedInInners.contains(name = jSVariable.getName()) || e instanceof JSLiteralExpression && !((JSLiteralExpression)e).isQuotedLiteral() && "null".equals(e.getText())) continue;
                        if (checker == null) {
                            checker = new JSUnusedLocalSymbolsInspection.LocalLiteralOccurrenceChecker((PsiElement)scope);
                        }
                        if (checker.isUsedInLiterals(name) || this.isPlaceWeNotWorkingReliablyIn(e, scope) || ((eParent = e.getParent()) == jSVariable || PsiTreeUtil.findCommonParent((PsiElement)e, (PsiElement)jSVariable) == eParent) && !readAtLeastOnce.contains(jSVariable)) continue;
                        this.reportUnusedValueProblem(e, true);
                    }
                }
                for (Map.Entry entry : valuesOverwritten.entrySet()) {
                    if (JSResolveUtil.findParent((PsiElement)entry.getValue()) instanceof JSClass || variablesReferencedInInners.contains(((JSVariable)entry.getValue()).getName()) || this.isPlaceWeNotWorkingReliablyIn((JSExpression)entry.getKey(), scope)) continue;
                    this.reportUnusedValueProblem((JSExpression)entry.getKey(), false);
                }
            }

            private boolean isPlaceWeNotWorkingReliablyIn(JSExpression key, JSExecutionScope scope) {
                JSElement place = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)key, (Class[])new Class[]{JSLoopStatement.class, JSSwitchStatement.class, scope.getClass()});
                return place != null && place != scope;
            }

            private boolean isElementFromProperScope(JSVariable v, JSExecutionScope scope) {
                if (PsiTreeUtil.getParentOfType((PsiElement)v, JSExecutionScope.class) != scope) {
                    return false;
                }
                return !(JSResolveUtil.findParent((PsiElement)v) instanceof JSClass);
            }

            private void reportUnusedValueProblem(JSExpression e, boolean unused) {
                JSExpression messageTarget = e;
                PsiElement parent = e.getParent();
                String message = JSBundle.message((String)(!unused && parent instanceof JSVariable ? "js.variable.initializer.is.redundant" : "js.value.assigned.is.never.used"), (Object[])new Object[0]);
                if (parent instanceof JSAssignmentExpression) {
                    JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
                    if (lOperand instanceof JSDefinitionExpression) {
                        lOperand = ((JSDefinitionExpression)lOperand).getExpression();
                    }
                    messageTarget = lOperand;
                } else if (parent instanceof JSVariable) {
                    messageTarget = ((JSVariable)parent).getNameIdentifier();
                }
                if (messageTarget == null) {
                    messageTarget = e;
                }
                holder.registerProblem((PsiElement)messageTarget, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnusedAssignmentInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static class SimpleControlFlowProcessor
    extends JSControlFlowProcessor {
        private final Map<JSVariable, Map<JSExpression, Boolean>> myVariablesWritten;
        private final Map<JSExpression, JSVariable> myVariablesReadWithoutInitialization;
        private final Set<JSVariable> myReadAtLeastOnce;
        private final Set<String> myVariablesReferencedInInners;
        private final Map<JSExpression, JSVariable> myValuesOverwritten;
        final List<BasicBlockInfo> basicBlockInfos;
        final List<PsiElement> branches;
        final List<DefinedValuesInfo> livesValues;
        PsiElement currentBranch;
        DefinedValuesInfo liveValuesForBranch;
        Set<JSVariable> conditionalVariablesForCurrentStatement;
        BasicBlockInfo currentBlockInfo;

        SimpleControlFlowProcessor(Map<JSVariable, Map<JSExpression, Boolean>> variablesWritten, Map<JSExpression, JSVariable> variablesReadWithoutInitialization, Set<JSVariable> readAtLeastOnce, Set<String> variablesReferencedInInners, Map<JSExpression, JSVariable> valuesOverwritten) {
            this.myVariablesWritten = variablesWritten;
            this.myVariablesReadWithoutInitialization = variablesReadWithoutInitialization;
            this.myReadAtLeastOnce = readAtLeastOnce;
            this.myVariablesReferencedInInners = variablesReferencedInInners;
            this.myValuesOverwritten = valuesOverwritten;
            this.basicBlockInfos = new ArrayList<BasicBlockInfo>(2);
            this.branches = new ArrayList<PsiElement>(2);
            this.livesValues = new ArrayList<DefinedValuesInfo>(2);
            this.liveValuesForBranch = new DefinedValuesInfo(this.myVariablesWritten);
            this.livesValues.add(this.liveValuesForBranch);
            this.currentBlockInfo = new BasicBlockInfo();
            this.basicBlockInfos.add(this.currentBlockInfo);
        }

        @Override
        public void valueRead(JSExpression expression) {
            PsiElement resolve;
            if (expression instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() == null && (resolve = ((JSReferenceExpression)expression).resolve()) instanceof JSVariable && !(resolve instanceof ImplicitJSVariableImpl)) {
                JSVariable var = (JSVariable)resolve;
                boolean readSomething = resolve instanceof JSParameter;
                for (int i = this.livesValues.size() - 1; i >= 0; --i) {
                    DefinedValuesInfo info = this.livesValues.get(i);
                    Map<JSExpression, Boolean> usedValues = info.variablesWritten.get(var);
                    if (usedValues != null) {
                        for (JSExpression e : usedValues.keySet()) {
                            usedValues.put(e, Boolean.TRUE);
                            readSomething = true;
                        }
                    }
                    if (info.conditionalVariables == null || !info.conditionalVariables.contains(var)) continue;
                    readSomething = true;
                }
                if (!readSomething && SimpleControlFlowProcessor.isReadInConditional(expression)) {
                    if (this.conditionalVariablesForCurrentStatement == null) {
                        this.conditionalVariablesForCurrentStatement = new THashSet(1);
                    }
                    this.conditionalVariablesForCurrentStatement.add(var);
                    readSomething = true;
                }
                if (!readSomething && this.conditionalVariablesForCurrentStatement != null && this.conditionalVariablesForCurrentStatement.contains(var)) {
                    readSomething = true;
                }
                if (!readSomething) {
                    this.myVariablesReadWithoutInitialization.put(expression, var);
                }
                this.myReadAtLeastOnce.add(var);
            }
        }

        @Override
        public void finishStatement(JSElement node) {
            this.conditionalVariablesForCurrentStatement = null;
        }

        @Override
        public void branchStarted(@Nullable JSExpression condition, boolean negatedCondition, JSElement node, JSExpression ... arguments) {
            this.liveValuesForBranch = new DefinedValuesInfo();
            if (this.conditionalVariablesForCurrentStatement != null) {
                this.liveValuesForBranch.conditionalVariables = this.conditionalVariablesForCurrentStatement;
                this.conditionalVariablesForCurrentStatement = null;
            }
            this.livesValues.add(this.liveValuesForBranch);
            if (this.currentBranch != null) {
                this.branches.add(this.currentBranch);
            }
            this.currentBranch = node;
        }

        @Override
        public void branchFinished(JSElement branchId) {
            this.currentBranch = this.branches.size() > 0 ? this.branches.remove(this.branches.size() - 1) : null;
            this.currentBlockInfo.branchesToMerge.add(this.liveValuesForBranch);
            this.livesValues.remove(this.livesValues.size() - 1);
            this.liveValuesForBranch = this.livesValues.get(this.livesValues.size() - 1);
            this.conditionalVariablesForCurrentStatement = null;
        }

        @Override
        public void branchingStarted(@Nullable JSElement node) {
            this.basicBlockInfos.add(this.currentBlockInfo);
            this.currentBlockInfo = new BasicBlockInfo();
        }

        @Override
        public void functionEncountered(JSFunction function) {
            ((JSFunctionBaseImpl)function).addReferencedExternalNames(this.myVariablesReferencedInInners);
        }

        @Override
        public void branchingFinished(@Nullable JSElement condition) {
            for (DefinedValuesInfo m : this.currentBlockInfo.branchesToMerge) {
                for (Map.Entry<JSVariable, Map<JSExpression, Boolean>> e : m.variablesWritten.entrySet()) {
                    Map<JSExpression, Boolean> map = this.liveValuesForBranch.variablesWritten.get(e.getKey());
                    if (map == null) {
                        map = e.getValue();
                        this.liveValuesForBranch.variablesWritten.put(e.getKey(), map);
                        continue;
                    }
                    map.putAll(e.getValue());
                }
            }
            this.currentBlockInfo = this.basicBlockInfos.remove(this.basicBlockInfos.size() - 1);
        }

        @Override
        public void valueWritten(JSElement element, JSExpression rOperand) {
            JSVariable var = null;
            if (element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() == null) {
                PsiElement resolve = ((JSReferenceExpression)element).resolve();
                if (resolve instanceof JSVariable) {
                    var = (JSVariable)resolve;
                }
            } else if (element instanceof JSVariable) {
                var = (JSVariable)element;
            }
            if (var != null && rOperand != null) {
                THashMap valuesMap = this.liveValuesForBranch.variablesWritten.get(var);
                if (valuesMap == null) {
                    valuesMap = new THashMap(1);
                    this.liveValuesForBranch.variablesWritten.put(var, (Map<JSExpression, Boolean>)valuesMap);
                }
                Iterator<JSExpression> iterator = valuesMap.keySet().iterator();
                while (iterator.hasNext()) {
                    JSExpression e = iterator.next();
                    if (valuesMap.get(e) != null) continue;
                    this.myValuesOverwritten.put(e, var);
                    iterator.remove();
                }
                valuesMap.put(rOperand, null);
            }
        }

        private static boolean isStrictlyReadInConditional(JSExpression key) {
            PsiElement parent;
            if (!SimpleControlFlowProcessor.isReadInConditional(key)) {
                return false;
            }
            JSExpression child = key;
            for (parent = child.getParent(); parent != null && !(parent instanceof JSStatement); parent = parent.getParent()) {
                child = parent;
            }
            return parent != null && child instanceof JSExpression && SimpleControlFlowProcessor.isConditionOfBlock(child, parent);
        }

        private static boolean isReadInConditional(JSExpression key) {
            IElementType sign;
            PsiElement parent = key.getParent();
            if (parent instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)parent).getOperationSign()) == JSTokenTypes.EXCL || sign == JSTokenTypes.TYPEOF_KEYWORD)) {
                return true;
            }
            if (SimpleControlFlowProcessor.isConditionOfBlock(key, parent)) {
                return true;
            }
            if (parent instanceof JSBinaryExpression) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)parent;
                IElementType sign2 = binaryExpression.getOperationSign();
                if (sign2 == JSTokenTypes.ANDAND) {
                    return true;
                }
                if (JSTokenTypes.EQUALITY_OPERATIONS.contains(sign2) && (key == binaryExpression.getROperand() && SimpleControlFlowProcessor.isUndefinedOperand(binaryExpression.getLOperand()) || key == binaryExpression.getLOperand() && SimpleControlFlowProcessor.isUndefinedOperand(binaryExpression.getROperand()))) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isConditionOfBlock(JSExpression key, PsiElement parent) {
            return parent instanceof JSIfStatement && key == ((JSIfStatement)parent).getCondition() || parent instanceof JSLoopStatement && key == ((JSLoopStatement)parent).getCondition();
        }

        private static boolean isUndefinedOperand(JSExpression operand) {
            if (!(operand instanceof JSReferenceExpression)) {
                return false;
            }
            JSReferenceExpression referenceExpression = (JSReferenceExpression)operand;
            if (referenceExpression.getQualifier() != null) {
                return false;
            }
            return "undefined".equals(referenceExpression.getText());
        }

        private static class BasicBlockInfo {
            final List<DefinedValuesInfo> branchesToMerge = new ArrayList<DefinedValuesInfo>(2);

            private BasicBlockInfo() {
            }
        }

        private static class DefinedValuesInfo {
            final Map<JSVariable, Map<JSExpression, Boolean>> variablesWritten;
            Set<JSVariable> conditionalVariables;

            DefinedValuesInfo(Map<JSVariable, Map<JSExpression, Boolean>> written) {
                this.variablesWritten = written;
            }

            DefinedValuesInfo() {
                this((Map<JSVariable, Map<JSExpression, Boolean>>)new THashMap(2));
            }
        }
    }
}

