/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSSwapMethodCallArgumentsIntention
extends JavaScriptIntention {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSSwapMethodCallArgumentsIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSSwapMethodCallArgumentsIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        if (!(element instanceof JSArgumentList)) {
            element = element.getParent();
        }
        if (!(element instanceof JSArgumentList)) {
            return false;
        }
        JSExpression[] arguments = ((JSArgumentList)element).getArguments();
        if (arguments.length != 2) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof JSCallExpression)) {
            return false;
        }
        JSExpression methodExpression = ((JSCallExpression)parent).getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement psiElement = ((JSReferenceExpression)methodExpression).resolve();
        if (!(psiElement instanceof JSFunction)) {
            return false;
        }
        JSParameterList parameterList = ((JSFunction)psiElement).getParameterList();
        if (parameterList == null) {
            return false;
        }
        JSParameter[] parameters = parameterList.getParameters();
        if (parameters.length != 2) {
            return false;
        }
        JSType type1 = parameters[0].getType();
        JSType type2 = parameters[1].getType();
        if (type1 == null ? type2 != null : !type1.isEquivalentTo(type2, null)) {
            return false;
        }
        this.setText(JSBundle.message((String)"js.swap.$0.and.$1", (Object[])new Object[]{StringUtil.first((String)arguments[0].getText(), (int)20, (boolean)true), StringUtil.first((String)arguments[1].getText(), (int)20, (boolean)true)}));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSSwapMethodCallArgumentsIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSSwapMethodCallArgumentsIntention", "invoke"));
        }
        if (!(element instanceof JSArgumentList)) {
            element = element.getParent();
        }
        JSArgumentList argumentList = (JSArgumentList)element;
        JSExpression[] arguments = argumentList.getArguments();
        JSCallExpression expression = (JSCallExpression)JSChangeUtil.createExpressionFromText(project, "f(" + arguments[1].getText() + ", " + arguments[0].getText() + ");").getPsi(JSCallExpression.class);
        JSArgumentList newArgumentList = expression.getArgumentList();
        argumentList.replace((PsiElement)newArgumentList);
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.swap.arguments", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSSwapMethodCallArgumentsIntention", "getFamilyName"));
        }
        return string;
    }
}

