/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryKind;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSPredefinedLibrariesData;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryManager
extends ScriptingLibraryManager {
    private volatile JSPredefinedLibrariesData myPredefinedLibrariesDataCache;
    private final Object myPredefinedLibrariesDataCacheUpdateLock = new Object();

    public JSLibraryManager(Project project) {
        super(project, JSLibraryKind.INSTANCE);
    }

    public boolean isPredefinedLibrary(String libraryName) {
        JSPredefinedLibrariesData data = this.getPredefinedLibrariesData();
        return data.isPredefinedLibrary(libraryName);
    }

    protected void initPredefinedLibraries(@NotNull ScriptingLibraryTable libraryTable) {
        if (libraryTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryTable", "com/intellij/lang/javascript/library/JSLibraryManager", "initPredefinedLibraries"));
        }
        for (ScriptingLibraryModel library : JSPredefinedLibraryProvider.getAllPredefinedLibraries(this.getProject())) {
            libraryTable.createPredefinedLibrary(library.getName(), VfsUtilCore.toVirtualFileArray((Collection)library.getSourceFiles()), VfsUtilCore.toVirtualFileArray((Collection)library.getCompactFiles()), ArrayUtil.toStringArray((Collection)library.getDocUrls()), library.isOnByDefault());
        }
        this.invalidatePredefinedLibrariesCache();
    }

    public void commitChanges() {
        this.invalidatePredefinedLibrariesCache();
        super.commitChanges();
    }

    private void invalidatePredefinedLibrariesCache() {
        this.myPredefinedLibrariesDataCache = null;
    }

    @NotNull
    public Set<VirtualFile> getPredefinedLibraryFiles() {
        JSPredefinedLibrariesData data = this.getPredefinedLibrariesData();
        Set<VirtualFile> set = data.getLibraryFiles();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryManager", "getPredefinedLibraryFiles"));
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> rebuildPredefinedLibraryFilesAndGet() {
        this.invalidatePredefinedLibrariesCache();
        Set<VirtualFile> set = this.getPredefinedLibraryFiles();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryManager", "rebuildPredefinedLibraryFilesAndGet"));
        }
        return set;
    }

    @Nullable
    public VirtualFile findPredefinedLibraryFileByName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/library/JSLibraryManager", "findPredefinedLibraryFileByName"));
        }
        JSPredefinedLibrariesData data = this.getPredefinedLibrariesData();
        return data.findPredefinedFileByName(fileName);
    }

    public boolean isPredefinedLibraryFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        JSPredefinedLibrariesData data = this.getPredefinedLibrariesData();
        return data.isPredefinedFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private JSPredefinedLibrariesData getPredefinedLibrariesData() {
        JSPredefinedLibrariesData data = this.myPredefinedLibrariesDataCache;
        if (data == null) {
            Object object = this.myPredefinedLibrariesDataCacheUpdateLock;
            synchronized (object) {
                data = this.myPredefinedLibrariesDataCache;
                if (data == null) {
                    this.myPredefinedLibrariesDataCache = data = JSPredefinedLibrariesData.create(this.getProject());
                }
            }
        }
        JSPredefinedLibrariesData jSPredefinedLibrariesData = data;
        if (jSPredefinedLibrariesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryManager", "getPredefinedLibrariesData"));
        }
        return jSPredefinedLibrariesData;
    }

    @NotNull
    public ScriptingLibraryMappings getLibraryMappings() {
        JSLibraryMappings jSLibraryMappings = JSLibraryMappings.getInstance(this.getProject());
        if (jSLibraryMappings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryManager", "getLibraryMappings"));
        }
        return jSLibraryMappings;
    }

    @NotNull
    public static JSLibraryManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/JSLibraryManager", "getInstance"));
        }
        JSLibraryManager jSLibraryManager = (JSLibraryManager)((Object)ServiceManager.getService((Project)project, JSLibraryManager.class));
        if (jSLibraryManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryManager", "getInstance"));
        }
        return jSLibraryManager;
    }

    @NotNull
    public Set<String> getDocUrlsFor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryManager", "getDocUrlsFor"));
        }
        String fileName = file.getName();
        if (("EcmaScript.js".equals(fileName) || "EcmaScript5.js".equals(fileName)) && JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles().contains(file)) {
            Set<String> set = Collections.singleton(JSExternalLibraryDocBundle.getBaseUrl("mdn_global_objects"));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryManager", "getDocUrlsFor"));
            }
            return set;
        }
        Set set = super.getDocUrlsFor(file);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryManager", "getDocUrlsFor"));
        }
        return set;
    }
}

