/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.download;

import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDownloadManager {
    private ProgressIndicator myProgress;
    private final String myTestRoot;
    private final String myTargetDirPath;
    private String myLastError;
    private String myActualSource;
    private String myTargetFilePath;

    public JSDownloadManager(@Nullable String testRoot) {
        this.myTestRoot = testRoot;
        this.myTargetDirPath = JSDownloadManager.getTargetDirPath();
        this.myLastError = null;
    }

    public static String getTargetDirPath() {
        return JSUtils.getConfigJavaScriptDirPath() + File.separatorChar + "extLibs";
    }

    public void setProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
        this.myProgress = progressIndicator;
    }

    @Nullable
    public String download(@NotNull String location, @NotNull String extension) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/library/download/JSDownloadManager", "download"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/lang/javascript/library/download/JSDownloadManager", "download"));
        }
        this.myActualSource = JSLibraryUtil.getDevVersionLocation(location);
        String targetFileName = JSLibraryUtil.makeUniqueFileName(this.myActualSource, true) + extension;
        this.myLastError = null;
        try {
            return this.fetch(this.myActualSource, targetFileName);
        }
        catch (JSDownloadException e) {
            if (e.getCause() instanceof IOException) {
                try {
                    this.myActualSource = location;
                    targetFileName = JSLibraryUtil.makeUniqueFileName(this.myActualSource, false) + extension;
                    return this.fetch(this.myActualSource, targetFileName);
                }
                catch (JSDownloadException e1) {
                    this.myLastError = e1.toString();
                }
            } else {
                this.myLastError = e.toString();
            }
            return null;
        }
    }

    public String getActualSource() {
        return this.myActualSource;
    }

    public String getLastError() {
        return this.myLastError;
    }

    private String fetch(String location, String targetFileName) throws JSDownloadException {
        File targetDir = new File(this.myTargetDirPath);
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new JSDownloadException("Can not create " + this.myTargetDirPath + " directory.");
        }
        if (location.startsWith("//")) {
            location = "http:" + location;
        }
        String targetPath = this.myTargetDirPath + File.separatorChar + targetFileName;
        File targetFile = new File(targetPath);
        try {
            if (this.myTestRoot == null) {
                DownloadUtil.downloadAtomically((ProgressIndicator)this.myProgress, (String)location, (File)targetFile);
            } else {
                File f = new File(location.replace("http://", this.myTestRoot + "/"));
                FileUtil.copy((File)f, (File)targetFile);
            }
            this.myTargetFilePath = targetPath;
            return targetPath;
        }
        catch (IOException e) {
            if (targetFile.exists()) {
                FileUtil.delete((File)targetFile);
            }
            throw new JSDownloadException(e);
        }
    }

    public String getTargetFilePath() {
        return this.myTargetFilePath;
    }

    public static class JSDownloadException
    extends Exception {
        public JSDownloadException(String message) {
            super(message);
        }

        public JSDownloadException(Throwable e) {
            super(e);
        }

        public String getReason() {
            Throwable t = this.getCause();
            if (t == null) {
                return this.getMessage();
            }
            if (t instanceof FileNotFoundException) {
                return "File not found";
            }
            if (t instanceof UnknownHostException) {
                return "Unknown host";
            }
            return t.getMessage();
        }

        @Override
        public String toString() {
            return this.getReason();
        }
    }
}

