/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilesMirror {
    private static final Logger LOG = Logger.getInstance(FilesMirror.class);
    private final Key<ThreadLocalFile> myKey;
    private final String myTempDirName;

    public FilesMirror(@NotNull String tempDirName) {
        if (tempDirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempDirName", "com/intellij/lang/javascript/linter/FilesMirror", "<init>"));
        }
        this(tempDirName, tempDirName);
    }

    public FilesMirror(@NotNull String name, @NotNull String tempDirName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/FilesMirror", "<init>"));
        }
        if (tempDirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempDirName", "com/intellij/lang/javascript/linter/FilesMirror", "<init>"));
        }
        this.myTempDirName = tempDirName;
        this.myKey = Key.create((String)name);
    }

    @Nullable
    public File getOrCreateExactlyNamed(@NotNull VirtualFile virtualFile, @Nullable String content) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/linter/FilesMirror", "getOrCreateExactlyNamed"));
        }
        return this.getOrCreate(virtualFile, content, new Convertor<VirtualFile, ThreadLocalFile>(){

            public ThreadLocalFile convert(VirtualFile o) {
                return new ThreadLocalCertainFileInTmpDir(o.getName(), o.getNameWithoutExtension(), FilesMirror.this.myTempDirName);
            }
        });
    }

    @Nullable
    public File getOrCreateFileWithActualContent(@NotNull VirtualFile virtualFile, @Nullable String content) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/linter/FilesMirror", "getOrCreateFileWithActualContent"));
        }
        return this.getOrCreate(virtualFile, content, new Convertor<VirtualFile, ThreadLocalFile>(){

            public ThreadLocalFile convert(VirtualFile o) {
                return new ThreadLocalTempFilePath(o, FilesMirror.this.myTempDirName);
            }
        });
    }

    @Nullable
    private File getOrCreate(@NotNull VirtualFile virtualFile, @Nullable String content, @NotNull Convertor<VirtualFile, ThreadLocalFile> convertor) {
        File file;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/linter/FilesMirror", "getOrCreate"));
        }
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/lang/javascript/linter/FilesMirror", "getOrCreate"));
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        if (!fileDocumentManager.isFileModified(virtualFile) && (file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile)).isFile()) {
            return file;
        }
        file = this.getMirrorFile(virtualFile, convertor);
        if (file == null) {
            return null;
        }
        try {
            return FilesMirror.copyUnsavedFileText(virtualFile, content, file);
        }
        catch (IOException e) {
            LOG.warn("Can not write to " + file.getAbsolutePath(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static File copyUnsavedFileText(VirtualFile virtualFile, @Nullable String content, File file) throws IOException {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Document document = fileDocumentManager.getCachedDocument(virtualFile);
        if (document == null) {
            return null;
        }
        if (content == null) {
            content = document.getText();
        }
        content = FilesMirror.convertLineSeparatorsToFileOriginal(content, virtualFile, document);
        byte[] bom = virtualFile.getBOM();
        Charset charset = virtualFile.getCharset();
        if (bom != null) {
            byte[] withBom = FilesMirror.getBytesWithBom(content, bom, charset);
            FileUtil.writeToFile((File)file, (byte[])withBom);
        } else {
            FileUtil.writeToFile((File)file, (byte[])content.getBytes(charset));
        }
        return file;
    }

    @NotNull
    public static String convertLineSeparatorsToFileOriginal(@NotNull String fileContent, @NotNull VirtualFile file, @NotNull Document document) {
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/lang/javascript/linter/FilesMirror", "convertLineSeparatorsToFileOriginal"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/FilesMirror", "convertLineSeparatorsToFileOriginal"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/FilesMirror", "convertLineSeparatorsToFileOriginal"));
        }
        String lineSeparator = FileDocumentManagerImpl.getLineSeparator((Document)document, (VirtualFile)file);
        if (lineSeparator.equals("\n")) {
            String string = fileContent;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/FilesMirror", "convertLineSeparatorsToFileOriginal"));
            }
            return string;
        }
        String string = StringUtil.convertLineSeparators((String)fileContent, (String)lineSeparator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/FilesMirror", "convertLineSeparatorsToFileOriginal"));
        }
        return string;
    }

    private static byte[] getBytesWithBom(@NotNull String content, byte[] bom, Charset charset) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/lang/javascript/linter/FilesMirror", "getBytesWithBom"));
        }
        byte[] contentBytes = content.getBytes(charset);
        byte[] withBom = new byte[contentBytes.length + bom.length];
        System.arraycopy(bom, 0, withBom, 0, bom.length);
        System.arraycopy(contentBytes, 0, withBom, bom.length, contentBytes.length);
        return withBom;
    }

    @Nullable
    private File getMirrorFile(@NotNull VirtualFile virtualFile, @NotNull Convertor<VirtualFile, ThreadLocalFile> convertor) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/linter/FilesMirror", "getMirrorFile"));
        }
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/lang/javascript/linter/FilesMirror", "getMirrorFile"));
        }
        ThreadLocalFile threadLocal = (ThreadLocalFile)this.myKey.get((UserDataHolder)virtualFile);
        if (threadLocal == null) {
            threadLocal = (ThreadLocalFile)virtualFile.putUserDataIfAbsent(this.myKey, convertor.convert((Object)virtualFile));
        }
        return threadLocal.getFile();
    }

    public static class ThreadLocalTempFilePath
    extends ThreadLocalFile {
        private final String myBaseNameWithoutExtension;
        private final String myTempDirName;
        private final String myDotExtension;

        private ThreadLocalTempFilePath(@NotNull VirtualFile file, @NotNull String tempDirName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/FilesMirror$ThreadLocalTempFilePath", "<init>"));
            }
            if (tempDirName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempDirName", "com/intellij/lang/javascript/linter/FilesMirror$ThreadLocalTempFilePath", "<init>"));
            }
            this.myTempDirName = tempDirName;
            this.myBaseNameWithoutExtension = file.getNameWithoutExtension();
            String ext = file.getExtension();
            this.myDotExtension = ext != null ? "." + ext : null;
        }

        @Nullable
        private File getDir() {
            File tmpDir = new File(FileUtil.getTempDirectory());
            File dir = new File(tmpDir, this.myTempDirName);
            if (dir.isDirectory() || dir.mkdirs()) {
                return dir;
            }
            try {
                return FileUtil.createTempDirectory((File)tmpDir, (String)this.myTempDirName, null, (boolean)true);
            }
            catch (IOException e) {
                LOG.warn("Can't create '" + this.myTempDirName + "' temporary directory.", (Throwable)e);
                return null;
            }
        }

        @Override
        @Nullable
        protected File createFile() {
            File dir = this.getDir();
            if (dir == null) {
                return null;
            }
            try {
                return FileUtil.createTempFile((File)dir, (String)this.myBaseNameWithoutExtension, (String)this.myDotExtension, (boolean)true, (boolean)true);
            }
            catch (IOException e) {
                LOG.warn("Can not create temp file", (Throwable)e);
                return null;
            }
        }
    }

    public static class ThreadLocalCertainFileInTmpDir
    extends ThreadLocalFile {
        private final String myExactFileName;
        @NotNull
        private final String myPrefix;
        @NotNull
        private final String myTempDirName;

        public ThreadLocalCertainFileInTmpDir(@NotNull String name, @NotNull String prefix, @NotNull String tempDirName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/FilesMirror$ThreadLocalCertainFileInTmpDir", "<init>"));
            }
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/javascript/linter/FilesMirror$ThreadLocalCertainFileInTmpDir", "<init>"));
            }
            if (tempDirName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempDirName", "com/intellij/lang/javascript/linter/FilesMirror$ThreadLocalCertainFileInTmpDir", "<init>"));
            }
            this.myTempDirName = tempDirName;
            assert (!StringUtil.isEmptyOrSpaces((String)name));
            assert (!StringUtil.isEmptyOrSpaces((String)prefix));
            this.myExactFileName = name;
            this.myPrefix = prefix;
        }

        @Nullable
        private File getDir() {
            File tmpDir = new File(FileUtil.getTempDirectory());
            File dir = new File(tmpDir, this.myTempDirName);
            try {
                if (!dir.isDirectory() && !dir.mkdirs()) {
                    dir = FileUtil.createTempDirectory((File)tmpDir, (String)this.myTempDirName, null);
                }
                dir = FileUtil.createTempDirectory((File)dir, (String)this.myPrefix, null);
                return dir;
            }
            catch (IOException ignored) {
                LOG.warn("Can't create '" + this.myTempDirName + "' temporary directory.");
                return null;
            }
        }

        @Override
        @Nullable
        protected File createFile() {
            File dir = this.getDir();
            if (dir == null) {
                return null;
            }
            File file = new File(dir, this.myExactFileName);
            if (!file.exists()) {
                try {
                    if (!file.createNewFile()) {
                        LOG.warn("Can not create " + file.getAbsolutePath());
                    }
                }
                catch (IOException ignored) {
                    LOG.warn("Can not create " + file.getAbsolutePath());
                }
            }
            file.deleteOnExit();
            return file;
        }
    }

    public static abstract class ThreadLocalFile
    extends ThreadLocal<String> {
        @Nullable
        public File getFile() {
            File file;
            String path = (String)super.get();
            if (path != null && (file = new File(path)).isFile()) {
                return file;
            }
            file = this.createFile();
            if (file != null) {
                this.set(file.getAbsolutePath());
                return file;
            }
            return null;
        }

        protected abstract File createFile();
    }
}

