/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeBlinker
implements Disposable {
    private final Editor myEditor;
    private final Alarm myUpdateAlarm;
    private Runnable myRunAfterBlinking;

    public RangeBlinker(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/linter/RangeBlinker", "<init>"));
        }
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myEditor = editor;
        this.myUpdateAlarm.setActivationComponent(this.myEditor.getComponent());
    }

    /*
     * WARNING - void declaration
     */
    public void blink(final @NotNull List<TextRange> highlightRanges, final long highlightDurationMillis, final long nonHighlightDurationMillis, final int blinkCount, @Nullable TextAttributes textAttributes, @Nullable Runnable runnable) {
        void runAfterBlinking;
        void additionalTextAttributes;
        if (highlightRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightRanges", "com/intellij/lang/javascript/linter/RangeBlinker", "blink"));
        }
        UiNotifyConnector.doWhenFirstShown((JComponent)this.myEditor.getComponent(), (Runnable)new Runnable((TextAttributes)additionalTextAttributes, (Runnable)runAfterBlinking){
            final /* synthetic */ TextAttributes val$additionalTextAttributes;
            final /* synthetic */ Runnable val$runAfterBlinking;
            {
                this.val$additionalTextAttributes = textAttributes;
                this.val$runAfterBlinking = runnable;
            }

            @Override
            public void run() {
                RangeBlinker.this.scheduleBlinks(highlightRanges, highlightDurationMillis, nonHighlightDurationMillis, blinkCount, this.val$additionalTextAttributes, this.val$runAfterBlinking);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void scheduleBlinks(final @NotNull List<TextRange> highlightRanges, long highlightDurationMillis, long nonHighlightDurationMillis, int blinkCount, @Nullable TextAttributes textAttributes, @Nullable Runnable runnable) {
        void runAfterBlinking;
        if (highlightRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightRanges", "com/intellij/lang/javascript/linter/RangeBlinker", "scheduleBlinks"));
        }
        this.stopBlinking();
        this.myRunAfterBlinking = runAfterBlinking;
        for (int i = 0; i < blinkCount; ++i) {
            void additionalTextAttributes;
            long showHighlightRangesStartTime = (long)i * (highlightDurationMillis + nonHighlightDurationMillis);
            this.myUpdateAlarm.addComponentRequest(new Runnable((TextAttributes)additionalTextAttributes){
                final /* synthetic */ TextAttributes val$additionalTextAttributes;
                {
                    this.val$additionalTextAttributes = textAttributes;
                }

                @Override
                public void run() {
                    RangeBlinker.this.showHighlightRanges(highlightRanges, this.val$additionalTextAttributes);
                }
            }, showHighlightRangesStartTime);
            final boolean lastHiding = i == blinkCount - 1;
            this.myUpdateAlarm.addComponentRequest(new Runnable(){

                @Override
                public void run() {
                    RangeBlinker.this.hideHighlightRanges();
                    if (lastHiding && RangeBlinker.this.myRunAfterBlinking != null) {
                        RangeBlinker.this.myRunAfterBlinking.run();
                        RangeBlinker.this.myRunAfterBlinking = null;
                    }
                }
            }, showHighlightRangesStartTime + highlightDurationMillis);
        }
    }

    private void showHighlightRanges(@NotNull List<TextRange> highlightRanges, @Nullable TextAttributes additionalTextAttributes) {
        if (highlightRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightRanges", "com/intellij/lang/javascript/linter/RangeBlinker", "showHighlightRanges"));
        }
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
        VisualPosition visualStart = this.myEditor.xyToVisualPosition(visibleArea.getLocation());
        VisualPosition visualEnd = this.myEditor.xyToVisualPosition(new Point(visibleArea.x + visibleArea.width, visibleArea.y + visibleArea.height));
        int endColumnCandidate = visibleArea.width / EditorUtil.getSpaceWidth((int)0, (Editor)this.myEditor) + visualStart.column;
        if (endColumnCandidate > visualEnd.column) {
            visualEnd = new VisualPosition(visualEnd.line, endColumnCandidate);
        }
        int offsetToScroll = -1;
        CharSequence text = this.myEditor.getDocument().getCharsSequence();
        TextAttributes backgroundAttributes = this.myEditor.getColorsScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        TextAttributes borderAttributes = new TextAttributes(null, null, backgroundAttributes.getBackgroundColor(), EffectType.BOXED, 0);
        boolean scrollToChange = true;
        for (TextRange range : highlightRanges) {
            TextAttributes attributesToUse;
            if (scrollToChange) {
                boolean rangeVisible = RangeBlinker.isWithinBounds(this.myEditor.offsetToVisualPosition(range.getStartOffset()), visualStart, visualEnd) || RangeBlinker.isWithinBounds(this.myEditor.offsetToVisualPosition(range.getEndOffset()), visualStart, visualEnd);
                boolean bl = scrollToChange = !rangeVisible;
                if (offsetToScroll < 0 && offsetToScroll < 0) {
                    if (text.charAt(range.getStartOffset()) != '\n') {
                        offsetToScroll = range.getStartOffset();
                    } else if (range.getEndOffset() > 0 && text.charAt(range.getEndOffset() - 1) != '\n') {
                        offsetToScroll = range.getEndOffset() - 1;
                    }
                }
            }
            TextAttributes textAttributes = attributesToUse = range.getLength() > 0 ? backgroundAttributes : borderAttributes;
            if (additionalTextAttributes != null) {
                attributesToUse = TextAttributes.merge((TextAttributes)attributesToUse, (TextAttributes)additionalTextAttributes);
            }
            markupModel.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 6000, attributesToUse, HighlighterTargetArea.EXACT_RANGE);
        }
        if (scrollToChange) {
            if (offsetToScroll < 0 && !highlightRanges.isEmpty()) {
                offsetToScroll = highlightRanges.get(0).getStartOffset();
            }
            if (offsetToScroll >= 0 && offsetToScroll < text.length() - 1 && text.charAt(offsetToScroll) != '\n') {
                ++offsetToScroll;
            }
            if (offsetToScroll >= 0 && offsetToScroll < this.myEditor.getDocument().getTextLength()) {
                this.myEditor.getScrollingModel().scrollTo(this.myEditor.offsetToLogicalPosition(offsetToScroll), ScrollType.RELATIVE);
            }
        }
    }

    private void hideHighlightRanges() {
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        markupModel.removeAllHighlighters();
    }

    private static boolean isWithinBounds(VisualPosition targetPosition, VisualPosition startPosition, VisualPosition endPosition) {
        return targetPosition.line >= startPosition.line && targetPosition.line <= endPosition.line && targetPosition.column >= startPosition.column && targetPosition.column <= endPosition.column;
    }

    public void dispose() {
        this.myUpdateAlarm.cancelAllRequests();
    }

    public void stopBlinking() {
        this.myUpdateAlarm.cancelAllRequests();
        this.hideHighlightRanges();
        if (this.myRunAfterBlinking != null) {
            this.myRunAfterBlinking.run();
            this.myRunAfterBlinking = null;
        }
    }
}

