/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.lang.javascript.linter.eslint.EslintPackage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintSessionData {
    private static final Logger LOG = Logger.getInstance(EslintSessionData.class);
    private final File myNodeInterpreterFile;
    private final EslintPackage myEslintPackage;
    private final VirtualFile myWorkingDir;
    private final VirtualFile myFileToLint;
    private final String myFileToLintContent;
    private final VirtualFile mySpecifiedConfigFile;
    private final File myAdditionalRulesDir;
    private final String myExtraOptions;

    public EslintSessionData(@NotNull File nodeInterpreterFile, @NotNull EslintPackage eslintPackage, @NotNull VirtualFile workingDir, @NotNull VirtualFile fileToLint, @NotNull String fileToLintContent, @Nullable VirtualFile specifiedConfigurationFile, @Nullable File additionalRulesDir, @NotNull String extraOptions) {
        if (nodeInterpreterFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreterFile", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "<init>"));
        }
        if (eslintPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eslintPackage", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "<init>"));
        }
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "<init>"));
        }
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "<init>"));
        }
        if (fileToLintContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLintContent", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "<init>"));
        }
        if (extraOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraOptions", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "<init>"));
        }
        this.myNodeInterpreterFile = nodeInterpreterFile;
        this.myEslintPackage = eslintPackage;
        this.myWorkingDir = workingDir;
        this.myFileToLint = fileToLint;
        this.myFileToLintContent = fileToLintContent;
        this.mySpecifiedConfigFile = specifiedConfigurationFile;
        this.myAdditionalRulesDir = additionalRulesDir;
        this.myExtraOptions = extraOptions;
    }

    @NotNull
    public File getNodeInterpreterFile() {
        File file = this.myNodeInterpreterFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "getNodeInterpreterFile"));
        }
        return file;
    }

    @NotNull
    public EslintPackage getEslintPackage() {
        EslintPackage eslintPackage = this.myEslintPackage;
        if (eslintPackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "getEslintPackage"));
        }
        return eslintPackage;
    }

    @NotNull
    public VirtualFile getWorkingDirectory() {
        VirtualFile virtualFile = this.myWorkingDir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "getWorkingDirectory"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getFileToLint() {
        VirtualFile virtualFile = this.myFileToLint;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "getFileToLint"));
        }
        return virtualFile;
    }

    @NotNull
    public String getFileToLintContent() {
        String string = this.myFileToLintContent;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "getFileToLintContent"));
        }
        return string;
    }

    @Nullable
    public VirtualFile getSpecifiedConfigFile() {
        return this.mySpecifiedConfigFile;
    }

    @Nullable
    public File getAdditionalRulesDir() {
        return this.myAdditionalRulesDir;
    }

    @NotNull
    public String getExtraOptions() {
        String string = this.myExtraOptions;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "getExtraOptions"));
        }
        return string;
    }

    @NotNull
    public String getFileToLintRelativePath() {
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)this.myFileToLint, (VirtualFile)this.myWorkingDir, (char)File.separatorChar);
        if (relativePath != null) {
            String string = relativePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "getFileToLintRelativePath"));
            }
            return string;
        }
        LOG.warn("Cannot find relative path for " + this.myFileToLint.getPath() + " to " + this.myWorkingDir.getPath());
        String string = FileUtil.toSystemDependentName((String)this.myFileToLint.getPath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "getFileToLintRelativePath"));
        }
        return string;
    }

    @NotNull
    public List<VirtualFile> findConfigs() {
        ArrayList configs = ContainerUtil.newArrayList();
        VirtualFile ignoreFile = this.myWorkingDir.findChild(".eslintignore");
        if (ignoreFile != null && ignoreFile.isValid() && !ignoreFile.isDirectory()) {
            configs.add(ignoreFile);
        }
        if (this.mySpecifiedConfigFile != null) {
            configs.add(this.mySpecifiedConfigFile);
        } else {
            for (VirtualFile dir = this.myFileToLint.getParent(); dir != null; dir = dir.getParent()) {
                VirtualFile f = dir.findChild(".eslintrc");
                if (f == null || !f.isValid() || f.isDirectory()) continue;
                configs.add(f);
            }
        }
        ArrayList arrayList = configs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSessionData", "findConfigs"));
        }
        return arrayList;
    }
}

