/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.gjslint;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.gjslint.GjsLintInspection;
import com.intellij.lang.javascript.linter.gjslint.GjsLintState;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;

@State(name="JSClosureLinterConfiguration", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/jsLinters/gjslint.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class GjsLintConfiguration
extends JSLinterConfiguration<GjsLintState> {
    public static final String DEFAULT_EXE_FILE_BASE_NAME = SystemInfo.isWindows ? "gjslint.exe" : "gjslint";
    private static final String LINTER_EXE_FILE_PATH = "linter-exe-file-path";
    private static final String ROOT_ELEMENT_NAME = "gjslint";
    private static final String CONFIG_FILE_PATH = "config-file";
    private volatile GjsLintState DEFAULT_STATE;

    public GjsLintConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "<init>"));
        }
        super(project);
    }

    @Override
    protected void savePrivateSettings(@NotNull GjsLintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "savePrivateSettings"));
        }
    }

    @Override
    @NotNull
    protected GjsLintState loadPrivateSettings(@NotNull GjsLintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "loadPrivateSettings"));
        }
        GjsLintState gjsLintState = state;
        if (gjsLintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "loadPrivateSettings"));
        }
        return gjsLintState;
    }

    @Override
    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        if (GjsLintInspection.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "getInspectionClass"));
        }
        return GjsLintInspection.class;
    }

    @NotNull
    public static GjsLintConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "getInstance"));
        }
        GjsLintConfiguration gjsLintConfiguration = JSLinterConfiguration.getInstance(project, GjsLintConfiguration.class);
        if (gjsLintConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "getInstance"));
        }
        return gjsLintConfiguration;
    }

    @Override
    @NotNull
    protected Element toXml(@NotNull GjsLintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "toXml"));
        }
        Element root = new Element(ROOT_ELEMENT_NAME);
        String configFilePath = state.getConfigFilePath();
        Element child = new Element(CONFIG_FILE_PATH);
        child.setContent((Content)new Text(FileUtil.toSystemIndependentName((String)configFilePath)));
        root.addContent(child);
        GjsLintConfiguration.storeLinterExeFilePath(state.getLinterExePath());
        Element element = root;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "toXml"));
        }
        return element;
    }

    private static void storeLinterExeFilePath(@NotNull String linterExeFilePath) {
        if (linterExeFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linterExeFilePath", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "storeLinterExeFilePath"));
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        propertiesComponent.setValue(LINTER_EXE_FILE_PATH, linterExeFilePath);
    }

    @NotNull
    private static String restoreLinterExeFilePath() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String string = StringUtil.notNullize((String)propertiesComponent.getValue(LINTER_EXE_FILE_PATH));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "restoreLinterExeFilePath"));
        }
        return string;
    }

    @Override
    @NotNull
    protected GjsLintState fromXml(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "fromXml"));
        }
        GjsLintState.Builder builder = new GjsLintState.Builder();
        Element configFileElement = element.getChild(CONFIG_FILE_PATH);
        String configFilePath = "";
        if (configFileElement != null) {
            configFilePath = FileUtil.toSystemDependentName((String)configFileElement.getText());
        }
        builder.setConfigFilePath(configFilePath);
        String linterExeFilePath = GjsLintConfiguration.restoreLinterExeFilePath();
        if (linterExeFilePath.isEmpty()) {
            linterExeFilePath = this.getDefaultState().getLinterExePath();
        }
        builder.setLinterExePath(linterExeFilePath);
        GjsLintState gjsLintState = builder.build();
        if (gjsLintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "fromXml"));
        }
        return gjsLintState;
    }

    @Override
    @NotNull
    protected GjsLintState getDefaultState() {
        GjsLintState state = this.DEFAULT_STATE;
        if (state == null) {
            GjsLintState.Builder builder = new GjsLintState.Builder();
            File exeFile = PathEnvironmentVariableUtil.findInPath((String)DEFAULT_EXE_FILE_BASE_NAME, (boolean)true);
            if (exeFile != null) {
                builder.setLinterExePath(exeFile.getAbsolutePath());
            }
            this.DEFAULT_STATE = state = builder.build();
        }
        GjsLintState gjsLintState = state;
        if (gjsLintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintConfiguration", "getDefaultState"));
        }
        return gjsLintState;
    }
}

