/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.gjslint;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.gjslint.GjsLintConfigurable;
import com.intellij.lang.javascript.linter.gjslint.GjsLintConfiguration;
import com.intellij.lang.javascript.linter.gjslint.GjsLintExternalAnnotator;
import com.intellij.lang.javascript.linter.gjslint.GjsLintInspection;
import com.intellij.lang.javascript.linter.gjslint.GjsLintState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GjsLintHtmlExternalAnnotator
extends JSLinterExternalAnnotator<GjsLintState> {
    public GjsLintHtmlExternalAnnotator() {
        super(true);
    }

    @Override
    @NotNull
    protected JSLinterConfigurable<GjsLintState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/gjslint/GjsLintHtmlExternalAnnotator", "createSettingsConfigurable"));
        }
        GjsLintConfigurable gjsLintConfigurable = new GjsLintConfigurable(project, true);
        if (gjsLintConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/gjslint/GjsLintHtmlExternalAnnotator", "createSettingsConfigurable"));
        }
        return gjsLintConfigurable;
    }

    @Override
    protected Class<? extends JSLinterConfiguration<GjsLintState>> getConfigurationClass() {
        return GjsLintConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return GjsLintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/gjslint/GjsLintHtmlExternalAnnotator", "acceptPsiFile"));
        }
        return GjsLintHtmlExternalAnnotator.isPureHtmlFile(file);
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult<GjsLintState> doAnnotate(@Nullable JSLinterInput<GjsLintState> collectedInfo) {
        return GjsLintExternalAnnotator.getInstanceForBatchInspection().doAnnotate(collectedInfo);
    }

    @Override
    public void apply(@NotNull PsiFile file, @Nullable JSLinterAnnotationResult<GjsLintState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/gjslint/GjsLintHtmlExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/gjslint/GjsLintHtmlExternalAnnotator", "apply"));
        }
        GjsLintExternalAnnotator.getInstanceForBatchInspection().apply(file, annotationResult, holder);
    }

    public static boolean isPureHtmlFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/gjslint/GjsLintHtmlExternalAnnotator", "isPureHtmlFile"));
        }
        if (file.getLanguage() == HTMLLanguage.INSTANCE) {
            FileType fileTypeByName = FileTypeRegistry.getInstance().getFileTypeByFileName(file.getName());
            return fileTypeByName == HtmlFileType.INSTANCE;
        }
        return false;
    }
}

