/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.FilesMirror;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterEditConfigFileAction;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.jscs.EditFirstTypeErrorInConfig;
import com.intellij.lang.javascript.linter.jscs.JscsConfigurable;
import com.intellij.lang.javascript.linter.jscs.JscsConfiguration;
import com.intellij.lang.javascript.linter.jscs.JscsExternalRunner;
import com.intellij.lang.javascript.linter.jscs.JscsInspection;
import com.intellij.lang.javascript.linter.jscs.JscsReformatterTask;
import com.intellij.lang.javascript.linter.jscs.JscsState;
import com.intellij.lang.javascript.linter.jscs.config.JscsCreateConfigAndExcludeFix;
import com.intellij.lang.javascript.linter.jscs.config.JscsCreateConfigFromPresetFix;
import com.intellij.lang.javascript.linter.jscs.config.JscsExcludeFileInConfigFix;
import com.intellij.lang.javascript.linter.jscs.config.JscsTypeError;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsExternalAnnotator
extends JSLinterExternalAnnotator<JscsState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.jscs.Jscs");
    private static final JscsExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new JscsExternalAnnotator(false);
    private static final String JSCS_CODE_TEMP_FILE_MAP_KEY_NAME = "JSCS_CODE_TEMP_FILE_MAP_KEY";
    private static final String JSCS_CONFIG_TEMP_FILE_MAP_KEY_NAME = "JSCS_CONFIG_TEMP_FILE_MAP_KEY";
    private final FilesMirror myCodeFilesMirror = new FilesMirror("JSCS_CODE_TEMP_FILE_MAP_KEY", "jscs");
    private final FilesMirror myConfigFilesMirror = new FilesMirror("JSCS_CONFIG_TEMP_FILE_MAP_KEY", "jscs");
    private final AtomicReference<File> myEmptyConfig = new AtomicReference();

    public static JscsExternalAnnotator getInstanceForBatchInspection() {
        return INSTANCE_FOR_BATCH_INSPECTION;
    }

    public JscsExternalAnnotator() {
        this(true);
    }

    public JscsExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    private void tryCreateEmptyConfig() {
        if (this.myEmptyConfig.get() != null) {
            return;
        }
        try {
            File empty = FileUtil.createTempFile((String)"jscs_empty", (String)".jscsrc");
            FileUtil.writeToFile((File)empty, (String)"{}");
            this.myEmptyConfig.set(empty);
            empty.deleteOnExit();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @Override
    @NotNull
    protected JSLinterConfigurable<JscsState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator", "createSettingsConfigurable"));
        }
        JscsConfigurable jscsConfigurable = new JscsConfigurable(project, true);
        if (jscsConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator", "createSettingsConfigurable"));
        }
        return jscsConfigurable;
    }

    @Override
    protected Class<? extends JSLinterConfiguration<JscsState>> getConfigurationClass() {
        return JscsConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return JscsInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator", "acceptPsiFile"));
        }
        return file instanceof JSFile && JSUtils.isJavaScriptFile(file);
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult<JscsState> doAnnotate(@Nullable JSLinterInput<JscsState> collectedInfo) {
        if (collectedInfo == null) {
            return null;
        }
        return this.createJscsRunner(collectedInfo).execute();
    }

    @NotNull
    public JscsExternalRunner createJscsRunner(@NotNull JSLinterInput<JscsState> collectedInfo) {
        if (collectedInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectedInfo", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator", "createJscsRunner"));
        }
        JscsExternalRunner jscsExternalRunner = new JscsExternalRunner(collectedInfo, this.myCodeFilesMirror, this.myConfigFilesMirror, collectedInfo.getProject(), new Getter<File>(){

            public File get() {
                JscsExternalAnnotator.this.tryCreateEmptyConfig();
                return (File)JscsExternalAnnotator.this.myEmptyConfig.get();
            }
        });
        if (jscsExternalRunner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator", "createJscsRunner"));
        }
        return jscsExternalRunner;
    }

    @Override
    public void apply(final @NotNull PsiFile file, final @Nullable JSLinterAnnotationResult<JscsState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator", "apply"));
        }
        final boolean useDefault = annotationResult == null || annotationResult.getConfigFile() == null;
        final boolean noConfig = annotationResult != null && annotationResult.getConfigFile() != null && FileUtil.filesEqual((File)this.myEmptyConfig.get(), (File)new File(annotationResult.getConfigFile().getPath()));
        new JSLinterAnnotationsBuilder<JscsState>(file, annotationResult, holder, JscsInspection.getHighlightDisplayKey(), new JscsConfigurable(file.getProject(), true), "JSCS: ").setHighlightingGranularity(JSLinterExternalAnnotator.HighlightingGranularity.element).setFixCreator(new JSLinterAnnotationsBuilder.JSLinterFixCreator(){

            @Override
            public boolean useDefaultNavigateToConfigOrShowSettings(JSLinterErrorBase errorBase) {
                return !noConfig && (useDefault || StringUtil.isEmptyOrSpaces((String)errorBase.getCode()) && !(errorBase instanceof JscsTypeError));
            }

            @Override
            public List<IntentionAction> createFixes(JSLinterErrorBase errorBase) {
                if (!useDefault) {
                    if (!StringUtil.isEmptyOrSpaces((String)errorBase.getCode())) {
                        ArrayList<IntentionAction> list = new ArrayList<IntentionAction>(3);
                        VirtualFile configFile = annotationResult.getConfigFile();
                        if (!noConfig) {
                            JSLinterEditConfigFileAction action = new JSLinterEditConfigFileAction(configFile, null);
                            action.setProperty(errorBase.getCode());
                            list.add(action);
                        } else {
                            list.add(new JscsCreateConfigFromPresetFix());
                        }
                        if (errorBase instanceof JSLinterError) {
                            list.add((IntentionAction)new JscsSuppressRuleFix(((JSLinterError)errorBase).getLine(), errorBase.getCode()));
                            list.add((IntentionAction)new JscsSuppressRuleForFileFix(errorBase.getCode()));
                            JscsExternalAnnotator.addExcludeFileInConfigFix(list, noConfig ? null : configFile, file);
                        }
                        list.add((IntentionAction)new JscsFixFix());
                        return list;
                    }
                    if (errorBase instanceof JscsTypeError) {
                        VirtualFile configFile = annotationResult.getConfigFile();
                        return Collections.singletonList(new EditFirstTypeErrorInConfig(configFile));
                    }
                }
                return null;
            }
        }).apply();
    }

    private static void addExcludeFileInConfigFix(List<IntentionAction> list, VirtualFile configFile, PsiFile file) {
        String configPath = configFile == null ? file.getProject().getBasePath() : configFile.getParent().getPath();
        String relativePath = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)configPath), (String)FileUtil.toSystemIndependentName((String)file.getVirtualFile().getPath()), (char)'/');
        if (relativePath != null) {
            relativePath = JscsExternalAnnotator.correctRelativePathForJscs(relativePath);
            if (configFile == null) {
                list.add(new JscsCreateConfigAndExcludeFix(file.getName(), relativePath));
            } else {
                list.add(new JscsExcludeFileInConfigFix(configFile, file.getName(), relativePath));
            }
        }
    }

    private static String correctRelativePathForJscs(String relativePath) {
        if (relativePath == null) {
            return null;
        }
        if (!relativePath.startsWith(".")) {
            if (!relativePath.startsWith("/")) {
                relativePath = "/" + relativePath;
            }
            relativePath = "." + relativePath;
        }
        return relativePath;
    }

    public static class JscsFixFix
    extends BaseIntentionAction {
        @NotNull
        public String getText() {
            if ("Fix current file with JSCS" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsFixFix", "getText"));
            }
            return "Fix current file with JSCS";
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"settings.javascript.linters.configurable.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsFixFix", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsFixFix", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsFixFix", "invoke"));
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            ProgressManager.getInstance().run((Task)new JscsReformatterTask(project, Collections.singletonList(file.getVirtualFile())));
        }
    }

    public static class JscsSuppressRuleForFileFix
    extends BaseIntentionAction {
        @NotNull
        private final String myCode;

        public JscsSuppressRuleForFileFix(@NotNull String code) {
            if (code == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleForFileFix", "<init>"));
            }
            this.myCode = code;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"settings.javascript.linters.configurable.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleForFileFix", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleForFileFix", "isAvailable"));
            }
            return true;
        }

        @NotNull
        public String getText() {
            String string = "Suppress " + this.myCode + " for file";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleForFileFix", "getText"));
            }
            return string;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleForFileFix", "invoke"));
            }
            Document document = JscsInspection.getDocumentForElement((PsiElement)file);
            if (document == null) {
                return;
            }
            document.insertString(0, (CharSequence)("// jscs:disable " + this.myCode + "\n"));
        }
    }

    public static class JscsSuppressRuleFix
    extends BaseIntentionAction {
        private final int myLine;
        @NotNull
        private final String myCode;

        public JscsSuppressRuleFix(int line, @NotNull String code) {
            if (code == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleFix", "<init>"));
            }
            this.myLine = line;
            this.myCode = code;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"settings.javascript.linters.configurable.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleFix", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleFix", "isAvailable"));
            }
            return true;
        }

        @NotNull
        public String getText() {
            String string = "Suppress " + this.myCode + " for current line";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleFix", "getText"));
            }
            return string;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleFix", "invoke"));
            }
            Document document = JscsInspection.getDocumentForElement((PsiElement)file);
            if (document == null) {
                return;
            }
            int offset = editor.getCaretModel().getOffset();
            JscsInspection.JscsSuppressForLineByCommentFix.suppressRuleForLine(project, document, file, this.myLine - 1, offset, this.myCode);
        }
    }
}

