/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.google.common.base.Charsets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.linter.FilesMirror;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.jscs.JscsCheckStyleOutputFormatParser;
import com.intellij.lang.javascript.linter.jscs.JscsConfigCopier;
import com.intellij.lang.javascript.linter.jscs.JscsObsoleteRulesWarning;
import com.intellij.lang.javascript.linter.jscs.JscsPreset;
import com.intellij.lang.javascript.linter.jscs.JscsState;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigFileChangeTracker;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigFileSearcher;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigHelper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Producer;
import com.intellij.webcore.util.CommandLineUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsExternalRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.jscs.Jscs");
    @NonNls
    private static final String CONFIGURATION_FILE_FOR_JSCS_IS_NOT_FOUND = "Configuration file for JSCS is not found";
    private final JSLinterInput<JscsState> myInputInfo;
    private final FilesMirror myCodeFilesMirror;
    private final FilesMirror myConfigFilesMirror;
    private final Project myProject;
    private final Getter<File> myEmptyConfig;
    private boolean mySkip;
    private String mySkipReason;
    private final List<Producer<JSLinterAnnotationResult<JscsState>>> mySteps;
    private File myActualConfigFile;
    private File myActualCodeFile;
    private File myNodeFile;
    private File myPackageDir;
    private VirtualFile myConfigVirtualFile;
    private VirtualFile myCodeVirtualFile;
    private File myJscsFile;
    private boolean myFix;
    private File myFoundConfigFile;
    private JscsConfigCopier myCopier;

    public JscsExternalRunner(@NotNull JSLinterInput<JscsState> info, @NotNull FilesMirror filesMirror, @NotNull FilesMirror configMirror, Project project, Getter<File> emptyConfigGetter) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/linter/jscs/JscsExternalRunner", "<init>"));
        }
        if (filesMirror == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesMirror", "com/intellij/lang/javascript/linter/jscs/JscsExternalRunner", "<init>"));
        }
        if (configMirror == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configMirror", "com/intellij/lang/javascript/linter/jscs/JscsExternalRunner", "<init>"));
        }
        this.myInputInfo = info;
        this.myCodeFilesMirror = filesMirror;
        this.myConfigFilesMirror = configMirror;
        this.myProject = project;
        this.myEmptyConfig = emptyConfigGetter;
        this.mySteps = new ArrayList<Producer<JSLinterAnnotationResult<JscsState>>>();
        this.mySteps.add(this.checkExePath());
        this.mySteps.add(this.checkTargetVirtualFile());
        this.mySteps.add(this.checkConfigPath());
        this.mySteps.add(this.checkIfTargetFileChanged());
        this.mySteps.add(this.runExternalProcess());
    }

    public JSLinterAnnotationResult<JscsState> execute() {
        for (Producer<JSLinterAnnotationResult<JscsState>> step : this.mySteps) {
            JSLinterAnnotationResult result = (JSLinterAnnotationResult)step.produce();
            if (result != null) {
                return result;
            }
            if (!this.mySkip) continue;
            return null;
        }
        return null;
    }

    public String getSkipReason() {
        return this.mySkipReason;
    }

    private void skip(String reason) {
        this.mySkip = true;
        this.mySkipReason = reason;
    }

    private Producer<JSLinterAnnotationResult<JscsState>> runExternalProcess() {
        return new Producer<JSLinterAnnotationResult<JscsState>>(){

            @Nullable
            public JSLinterAnnotationResult<JscsState> produce() {
                Process process;
                File workingDirectory = JscsExternalRunner.this.myActualCodeFile.getParentFile();
                if (workingDirectory == null) {
                    LOG.debug("Skipped JSCS file analysis: can not find working directory for file: " + JscsExternalRunner.this.myActualCodeFile.getPath());
                    JscsExternalRunner.this.skip("Can not find working directory for file: " + JscsExternalRunner.this.myActualCodeFile.getPath());
                    return null;
                }
                JscsConfigFileChangeTracker.getInstance(JscsExternalRunner.this.myProject).startIfNeeded();
                GeneralCommandLine commandLine = JscsExternalRunner.this.createCommandLine(workingDirectory);
                try {
                    process = commandLine.createProcess();
                }
                catch (ExecutionException e) {
                    return JscsExternalRunner.this.createError("Can not start JSCS process: " + e.getMessage());
                }
                OSProcessHandler processHandler = new OSProcessHandler(process, null, Charsets.UTF_8);
                JscsCheckStyleOutputFormatParser parser = new JscsCheckStyleOutputFormatParser(JscsExternalRunner.this.myActualCodeFile.getPath());
                processHandler.addProcessListener((ProcessListener)parser);
                processHandler.startNotify();
                String timeoutError = JSLinterUtil.waitForProcessUnderProgress(processHandler, ProgressManager.getInstance().getProgressIndicator(), TimeUnit.SECONDS.toMillis(10L), "JSCS");
                if (timeoutError != null) {
                    return JSLinterAnnotationResult.createLinterFailResult(JscsExternalRunner.this.myInputInfo, timeoutError, JscsExternalRunner.this.myConfigVirtualFile);
                }
                parser.process();
                JSLinterErrorBase error = parser.getGlobalError();
                if (error != null) {
                    return JSLinterAnnotationResult.createLinterFailResult(JscsExternalRunner.this.myInputInfo, error, JscsExternalRunner.this.myConfigVirtualFile);
                }
                JSLinterAnnotationResult<JscsState> result = JSLinterAnnotationResult.createLinterResult(JscsExternalRunner.this.myInputInfo, parser.getErrors(), JscsExternalRunner.this.myConfigVirtualFile);
                List<JscsObsoleteRulesWarning> warnings = parser.getWarnings();
                if (warnings != null) {
                    for (JscsObsoleteRulesWarning warning : warnings) {
                        result.addWarning(warning);
                    }
                }
                return result;
            }
        };
    }

    private JSLinterAnnotationResult<JscsState> createError(String error) {
        return JSLinterAnnotationResult.createLinterFailResult(this.myInputInfo, error, this.myConfigVirtualFile);
    }

    @NotNull
    public GeneralCommandLine createCommandLine(@NotNull File workingDir) {
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/lang/javascript/linter/jscs/JscsExternalRunner", "createCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(Charsets.UTF_8);
        CommandLineUtil.configureShellEnvironment((GeneralCommandLine)commandLine, (boolean)true, Collections.emptyMap());
        commandLine.withWorkDirectory(workingDir);
        commandLine.setExePath(this.myNodeFile.getAbsolutePath());
        commandLine.addParameter(this.myJscsFile.getAbsolutePath());
        this.esNextParameters(commandLine);
        if (this.myFix) {
            commandLine.addParameter("-x");
        } else {
            commandLine.addParameters(new String[]{"-v", "-r", "checkstyle"});
        }
        JscsPreset preset = this.myInputInfo.getState().getPreset();
        if (preset != null) {
            commandLine.addParameters(new String[]{"--preset", preset.getCode()});
        }
        if (this.myActualConfigFile != null) {
            commandLine.addParameters(new String[]{"-c", this.myActualConfigFile.getAbsolutePath()});
        }
        commandLine.addParameters(new String[]{this.myActualCodeFile.getAbsolutePath()});
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsExternalRunner", "createCommandLine"));
        }
        return generalCommandLine;
    }

    private void esNextParameters(GeneralCommandLine commandLine) {
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(this.myInputInfo.getPsiFile());
        if (!this.myCopier.isUseEsNext() && !this.myCopier.isUseEs3() && (DialectOptionHolder.JSX.equals((Object)dialect) || dialect != null && dialect.isECMA6)) {
            commandLine.addParameters(new String[]{"--esnext"});
        }
    }

    public void setFix(boolean fix) {
        this.myFix = fix;
    }

    public Producer<JSLinterAnnotationResult<JscsState>> checkExePath() {
        return new Producer<JSLinterAnnotationResult<JscsState>>(){

            @Nullable
            public JSLinterAnnotationResult<JscsState> produce() {
                JscsState state = (JscsState)JscsExternalRunner.this.myInputInfo.getState();
                String nodePath = state.getNodePath();
                if (StringUtil.isEmptyOrSpaces((String)nodePath)) {
                    return JscsExternalRunner.this.createError("Node interpreter file is not specified");
                }
                JscsExternalRunner.this.myNodeFile = new File(nodePath);
                if (!(JscsExternalRunner.this.myNodeFile.isFile() && JscsExternalRunner.this.myNodeFile.isAbsolute() && JscsExternalRunner.this.myNodeFile.canExecute())) {
                    return JscsExternalRunner.this.createError("Node interpreter file is not found");
                }
                String packagePath = state.getPackagePath();
                if (StringUtil.isEmptyOrSpaces((String)packagePath)) {
                    return JscsExternalRunner.this.createError("JSCS package directory is not specified");
                }
                JscsExternalRunner.this.myPackageDir = new File(packagePath);
                if (JscsExternalRunner.this.myPackageDir.isDirectory()) {
                    if (!JscsExternalRunner.this.myPackageDir.isAbsolute()) {
                        return JscsExternalRunner.this.createError("JSCS package directory is not found");
                    }
                    JscsExternalRunner.this.myJscsFile = new File(JscsExternalRunner.this.myPackageDir, "bin" + File.separator + "jscs");
                } else {
                    JscsExternalRunner.this.myJscsFile = JscsExternalRunner.this.myPackageDir;
                }
                if (!JscsExternalRunner.this.myJscsFile.exists()) {
                    if (JscsExternalRunner.this.myJscsFile == JscsExternalRunner.this.myPackageDir) {
                        return JscsExternalRunner.this.createError("Provided JSCS path does not exist");
                    }
                    return JscsExternalRunner.this.createError("Can not find 'jscs' script file under JSCS package directory");
                }
                return null;
            }
        };
    }

    private Producer<JSLinterAnnotationResult<JscsState>> checkConfigPath() {
        return new Producer<JSLinterAnnotationResult<JscsState>>(){

            @Nullable
            public JSLinterAnnotationResult<JscsState> produce() {
                JscsState state = (JscsState)JscsExternalRunner.this.myInputInfo.getState();
                boolean configExactlyNamed = false;
                if (state.isCustomConfigFileUsed()) {
                    String configFilePath = state.getCustomConfigFilePath();
                    if (StringUtil.isEmptyOrSpaces((String)configFilePath)) {
                        return JscsExternalRunner.this.createError("Configuration file for JSCS is not specified");
                    }
                    JscsExternalRunner.this.myFoundConfigFile = new File(configFilePath);
                } else {
                    JscsConfigFileSearcher searcher = new JscsConfigFileSearcher(JscsExternalRunner.this.myProject, JscsExternalRunner.this.myCodeVirtualFile);
                    searcher.lookup();
                    if (searcher.getError() != null) {
                        return JscsExternalRunner.this.createError(searcher.getError());
                    }
                    if (searcher.getPackage() != null) {
                        JscsExternalRunner.this.myFoundConfigFile = searcher.getPackage();
                        configExactlyNamed = true;
                    } else if (searcher.getConfig() != null) {
                        JscsExternalRunner.this.myFoundConfigFile = searcher.getConfig();
                    } else if (state.getPreset() != null) {
                        JscsExternalRunner.this.myFoundConfigFile = (File)JscsExternalRunner.this.myEmptyConfig.get();
                        if (JscsExternalRunner.this.myFoundConfigFile == null || !JscsExternalRunner.this.myFoundConfigFile.isFile() || !JscsExternalRunner.this.myFoundConfigFile.isAbsolute()) {
                            return JscsExternalRunner.this.createError("Can not create fictive empty config to run JSCS on (to ignore configs above project and use only preset) for file: " + JscsExternalRunner.this.myInputInfo.getPsiFile().getName());
                        }
                    } else {
                        return JscsExternalRunner.this.createError(JscsExternalRunner.CONFIGURATION_FILE_FOR_JSCS_IS_NOT_FOUND);
                    }
                }
                if (!JscsExternalRunner.this.myFoundConfigFile.isFile() || !JscsExternalRunner.this.myFoundConfigFile.isAbsolute()) {
                    return JscsExternalRunner.this.createError(JscsExternalRunner.CONFIGURATION_FILE_FOR_JSCS_IS_NOT_FOUND);
                }
                JscsExternalRunner.this.myConfigVirtualFile = VfsUtil.findFileByIoFile((File)JscsExternalRunner.this.myFoundConfigFile, (boolean)false);
                if (JscsExternalRunner.this.myConfigVirtualFile == null || !JscsExternalRunner.this.myConfigVirtualFile.isValid()) {
                    LOG.debug("Skipped JSCS file analysis: can not load config file as virtual file: " + JscsExternalRunner.this.myFoundConfigFile.getPath());
                    JscsExternalRunner.this.skip("Can not load config file as virtual file: " + JscsExternalRunner.this.myFoundConfigFile.getPath());
                    return null;
                }
                if (JscsExternalRunner.this.configIgnoresFile()) {
                    LOG.debug("Skipped JSCS file analysis: ignored in config: " + JscsExternalRunner.this.myFoundConfigFile.getPath());
                    JscsExternalRunner.this.skip("Ignored in config: " + JscsExternalRunner.this.myFoundConfigFile.getPath());
                    return null;
                }
                JscsExternalRunner.this.myCopier = new JscsConfigCopier(JscsExternalRunner.this.myProject, JscsExternalRunner.this.myConfigVirtualFile, FileDocumentManager.getInstance().isFileModified(JscsExternalRunner.this.myConfigVirtualFile));
                String newContent = JscsExternalRunner.this.myCopier.process();
                if (JscsExternalRunner.this.myCopier.getError() != null) {
                    return JscsExternalRunner.this.createError(JscsExternalRunner.this.myCopier.getError());
                }
                JscsExternalRunner.this.myActualConfigFile = configExactlyNamed ? JscsExternalRunner.this.myConfigFilesMirror.getOrCreateExactlyNamed(JscsExternalRunner.this.myConfigVirtualFile, newContent) : JscsExternalRunner.this.myConfigFilesMirror.getOrCreateFileWithActualContent(JscsExternalRunner.this.myConfigVirtualFile, newContent);
                if (JscsExternalRunner.this.myActualConfigFile == null) {
                    LOG.debug("Skipped JSCS file analysis: can not mirror config file in temp directory: " + JscsExternalRunner.this.myFoundConfigFile.getPath());
                    JscsExternalRunner.this.skip("Can not mirror config file in temp directory: " + JscsExternalRunner.this.myFoundConfigFile.getPath());
                }
                return null;
            }
        };
    }

    private boolean configIgnoresFile() {
        Application application = ApplicationManager.getApplication();
        List excludedPaths = (List)application.runReadAction((Computable)new Computable<List<String>>(){

            public List<String> compute() {
                Document document = FileDocumentManager.getInstance().getDocument(JscsExternalRunner.this.myConfigVirtualFile);
                if (document == null) {
                    return Collections.emptyList();
                }
                return JscsConfigHelper.getExcludedPaths(JscsExternalRunner.this.myProject, document);
            }
        });
        if (excludedPaths == null || excludedPaths.isEmpty()) {
            return false;
        }
        File codeFile = new File(FileUtil.toSystemDependentName((String)this.myCodeVirtualFile.getPath()));
        String relativeCodeFile = FileUtil.getRelativePath((File)new File(this.myConfigVirtualFile.getParent().getPath()), (File)codeFile);
        if (relativeCodeFile == null) {
            return false;
        }
        relativeCodeFile = JscsExternalRunner.ensureStartWithDot(FileUtil.toSystemIndependentName((String)relativeCodeFile));
        for (String path : excludedPaths) {
            if (!FilenameUtils.wildcardMatch((String)relativeCodeFile, (String)(path = JscsExternalRunner.ensureStartWithDot(path)))) continue;
            return true;
        }
        return false;
    }

    private static String ensureStartWithDot(String path) {
        if (FileUtil.isAbsolute((String)path)) {
            return path;
        }
        if (path.startsWith(".")) {
            return path;
        }
        if (path.startsWith("/")) {
            return "." + path;
        }
        return "./" + path;
    }

    private Producer<JSLinterAnnotationResult<JscsState>> checkTargetVirtualFile() {
        return new Producer<JSLinterAnnotationResult<JscsState>>(){

            @Nullable
            public JSLinterAnnotationResult<JscsState> produce() {
                PsiFile psiFile = JscsExternalRunner.this.myInputInfo.getPsiFile();
                JscsExternalRunner.this.myCodeVirtualFile = psiFile.getVirtualFile();
                if (JscsExternalRunner.this.myCodeVirtualFile == null || !JscsExternalRunner.this.myCodeVirtualFile.isValid()) {
                    LOG.debug("Skipped JSCS file analysis: can not load target file as virtual file: " + psiFile.getName());
                    JscsExternalRunner.this.skip("Can not load target file as virtual file: " + psiFile.getName());
                    return null;
                }
                return null;
            }
        };
    }

    private Producer<JSLinterAnnotationResult<JscsState>> checkIfTargetFileChanged() {
        return new Producer<JSLinterAnnotationResult<JscsState>>(){

            @Nullable
            public JSLinterAnnotationResult<JscsState> produce() {
                PsiFile psiFile = JscsExternalRunner.this.myInputInfo.getPsiFile();
                JscsExternalRunner.this.myActualCodeFile = JscsExternalRunner.this.myCodeFilesMirror.getOrCreateFileWithActualContent(JscsExternalRunner.this.myCodeVirtualFile, JscsExternalRunner.this.myInputInfo.getFileContent());
                if (JscsExternalRunner.this.myActualCodeFile == null) {
                    LOG.debug("Skipped JSCS file analysis: can not mirror target file in temp directory: " + psiFile.getName());
                    JscsExternalRunner.this.skip("Can not mirror target file in temp directory: " + psiFile.getName());
                }
                return null;
            }
        };
    }
}

