/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.linter.RangeBlinker;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionsState;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.processing.TextCompareProcessor;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintOptionsAsCommentView
implements Disposable {
    private final JComponent myComponent;
    private final EditorEx myEditor = JSHintOptionsAsCommentView.createEditor();
    private final RangeBlinker myRangeBlinker = new RangeBlinker((Editor)this.myEditor);
    private CommentText myPrevText = null;

    public JSHintOptionsAsCommentView() {
        Disposer.register((Disposable)this, (Disposable)this.myRangeBlinker);
        this.myComponent = new JPanel(new BorderLayout(0, 0));
        this.myComponent.add((Component)this.myEditor.getComponent(), "Center");
        Insets insets = new Insets(7, 0, 0, 0);
        this.myComponent.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"JavaScript comment directive", (boolean)false, (Insets)insets));
    }

    @NotNull
    private static EditorEx createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)"");
        editorDocument.setReadOnly(true);
        EditorEx editor = (EditorEx)editorFactory.createEditor(editorDocument);
        editor.setHorizontalScrollbarVisible(false);
        editor.setCaretEnabled(false);
        JSHintOptionsAsCommentView.fillEditorSettings(editor.getSettings());
        EditorColorsScheme scheme = editor.getColorsScheme();
        editor.getSettings().setCaretRowShown(false);
        editor.setHighlighter(JSHintOptionsAsCommentView.createHighlighter(scheme));
        EditorEx editorEx = editor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView", "createEditor"));
        }
        return editorEx;
    }

    private static EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        EditorHighlighterFactory factory = EditorHighlighterFactory.getInstance();
        return factory.createEditorHighlighter((FileType)JavaScriptFileType.INSTANCE, scheme, null);
    }

    private static void fillEditorSettings(@NotNull EditorSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView", "fillEditorSettings"));
        }
        settings.setWhitespacesShown(true);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setLineNumbersShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setUseSoftWraps(true);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView", "getComponent"));
        }
        return jComponent;
    }

    public void onOptionsChanged(@NotNull JSHintOptionsState optionsState) {
        if (optionsState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsState", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView", "onOptionsChanged"));
        }
        final CommentText commentText = new CommentText(optionsState);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                JSHintOptionsAsCommentView.this.setText(commentText);
            }
        });
    }

    private void setText(final @NotNull CommentText text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView", "setText"));
        }
        Diff diff = Diff.createDiff(this.myPrevText, text);
        this.myPrevText = text;
        if (!diff.getDeleteRanges().isEmpty()) {
            TextAttributes strikeAttr = new TextAttributes();
            strikeAttr.setEffectType(EffectType.STRIKEOUT);
            strikeAttr.setEffectColor((Color)JBColor.GRAY);
            this.myRangeBlinker.blink(diff.getDeleteRanges(), 1000L, 500L, 1, strikeAttr, new Runnable(){

                @Override
                public void run() {
                    JSHintOptionsAsCommentView.this.replaceText(text);
                }
            });
        } else {
            this.replaceText(text);
            if (diff.getInsertRanges().size() > 0) {
                this.myRangeBlinker.blink(diff.getInsertRanges(), 1000L, 500L, 1, null, null);
            } else {
                this.myRangeBlinker.stopBlinking();
            }
        }
    }

    private void replaceText(final @NotNull CommentText text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView", "replaceText"));
        }
        UiNotifyConnector.doWhenFirstShown((JComponent)this.myEditor.getComponent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        DocumentEx document = JSHintOptionsAsCommentView.this.myEditor.getDocument();
                        document.setReadOnly(false);
                        WriteCommandAction.runWriteCommandAction((Project)JSHintOptionsAsCommentView.this.myEditor.getProject(), (Runnable)new Runnable((Document)document){
                            final /* synthetic */ Document val$document;
                            {
                                this.val$document = document;
                            }

                            @Override
                            public void run() {
                                String newText = text.myWholeText + "\n";
                                this.val$document.replaceString(0, this.val$document.getTextLength(), (CharSequence)newText);
                            }
                        });
                        document.setReadOnly(true);
                    }
                });
            }
        });
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    private static class CommentText {
        private final String myJSHintComment;
        private final String myGlobalComment;
        private final String myWholeText;

        private CommentText(@NotNull JSHintOptionsState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView$CommentText", "<init>"));
            }
            this.myJSHintComment = CommentText.createJSHintComment(state);
            this.myGlobalComment = CommentText.createGlobalComment(state);
            this.myWholeText = this.myGlobalComment != null ? this.myJSHintComment + "\n\n" + this.myGlobalComment : this.myJSHintComment;
        }

        private static String createJSHintComment(@NotNull JSHintOptionsState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView$CommentText", "createJSHintComment"));
            }
            StringBuilder text = new StringBuilder("/*jshint");
            boolean firstOption = true;
            for (String optionKey : state.getOptionKeys()) {
                String valueStr;
                Object value;
                JSHintOption option = JSHintOption.findByName(optionKey);
                if (option == null || option == JSHintOption.PREDEF || (value = state.getValue(option)) == null || ComparatorUtil.equalsNullable((Object)value, (Object)option.getDefaultValue())) continue;
                if (OptionTypes.isEnumOption(option)) {
                    OptionEnumVariant enumVariant = state.getEnumVariant(option);
                    valueStr = enumVariant.getValue().toString();
                } else {
                    valueStr = value.toString();
                }
                if (!firstOption) {
                    text.append(",");
                }
                firstOption = false;
                text.append(" ").append(option.getKey()).append(":").append(valueStr);
            }
            text.append(" */");
            return text.toString();
        }

        private static String createGlobalComment(@NotNull JSHintOptionsState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView$CommentText", "createGlobalComment"));
            }
            Object predefObj = state.getValue(JSHintOption.PREDEF);
            if (predefObj == null) {
                return null;
            }
            return "/*global " + predefObj.toString().trim() + " */";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommentText that = (CommentText)o;
            return this.myWholeText.equals(that.myWholeText);
        }

        public int hashCode() {
            return this.myWholeText.hashCode();
        }
    }

    private static class Diff {
        private static final TextCompareProcessor COMPARE_PROCESSOR = new TextCompareProcessor(ComparisonPolicy.DEFAULT);
        private final List<TextRange> myDeleteRanges;
        private final List<TextRange> myInsertRanges;

        private Diff(@NotNull List<TextRange> deleteRanges, @NotNull List<TextRange> insertRanges) {
            if (deleteRanges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleteRanges", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView$Diff", "<init>"));
            }
            if (insertRanges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertRanges", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView$Diff", "<init>"));
            }
            this.myDeleteRanges = deleteRanges;
            this.myInsertRanges = insertRanges;
        }

        @NotNull
        public List<TextRange> getDeleteRanges() {
            List<TextRange> list = this.myDeleteRanges;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView$Diff", "getDeleteRanges"));
            }
            return list;
        }

        @NotNull
        public List<TextRange> getInsertRanges() {
            List<TextRange> list = this.myInsertRanges;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView$Diff", "getInsertRanges"));
            }
            return list;
        }

        @NotNull
        private static Diff createDiff(@Nullable CommentText beforeText, @NotNull CommentText afterText) {
            if (afterText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterText", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView$Diff", "createDiff"));
            }
            if (beforeText == null || beforeText.myJSHintComment.equals(afterText.myJSHintComment)) {
                Diff diff = new Diff(Collections.<TextRange>emptyList(), Collections.<TextRange>emptyList());
                if (diff == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView$Diff", "createDiff"));
                }
                return diff;
            }
            List fragments = Collections.emptyList();
            try {
                fragments = COMPARE_PROCESSOR.process(beforeText.myJSHintComment, afterText.myJSHintComment);
            }
            catch (FilesTooBigForDiffException filesTooBigForDiffException) {
                // empty catch block
            }
            ArrayList insertRanges = ContainerUtil.newArrayList();
            ArrayList deleteRanges = ContainerUtil.newArrayList();
            for (LineFragment lineFragment : fragments) {
                Iterator fragmentIterator;
                if (!Diff.isFirstLineFragment(lineFragment) || (fragmentIterator = lineFragment.getChildrenIterator()) == null) continue;
                while (fragmentIterator.hasNext()) {
                    Fragment fragment = (Fragment)fragmentIterator.next();
                    if (fragment.getType() == TextDiffTypeEnum.INSERT) {
                        insertRanges.add(fragment.getRange(FragmentSide.SIDE2));
                        continue;
                    }
                    if (fragment.getType() != TextDiffTypeEnum.DELETED) continue;
                    deleteRanges.add(fragment.getRange(FragmentSide.SIDE1));
                }
            }
            Diff diff = new Diff(deleteRanges, insertRanges);
            if (diff == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView$Diff", "createDiff"));
            }
            return diff;
        }

        private static boolean isFirstLineFragment(@NotNull LineFragment lineFragment) {
            if (lineFragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineFragment", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsAsCommentView$Diff", "isFirstLineFragment"));
            }
            return lineFragment.getStartingLine1() == 0 && lineFragment.getEndLine1() == 1 && lineFragment.getStartingLine2() == 0 && lineFragment.getEndLine2() == 1;
        }
    }
}

