/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jslint;

import com.google.common.base.Supplier;
import com.google.common.io.CharStreams;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.jslint.JSLintConfigurable;
import com.intellij.lang.javascript.linter.jslint.JSLintConfiguration;
import com.intellij.lang.javascript.linter.jslint.JSLintInspection;
import com.intellij.lang.javascript.linter.jslint.JSLintOption;
import com.intellij.lang.javascript.linter.jslint.JSLintOptionsState;
import com.intellij.lang.javascript.linter.jslint.JSLintState;
import com.intellij.lang.javascript.linter.rhino.FunctionWithScope;
import com.intellij.lang.javascript.linter.rhino.RhinoFunctionManager;
import com.intellij.lang.javascript.linter.rhino.RhinoUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

public class JSLintExternalAnnotator
extends JSLinterExternalAnnotator<JSLintState> {
    private static final JSLintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new JSLintExternalAnnotator(false);
    public static final RhinoFunctionManager JSLINT_FUNCTION_MANAGER = new RhinoFunctionManager(new Supplier<String>(){

        public String get() {
            String fileName = "jslint.js";
            InputStream inputStream = this.getClass().getResourceAsStream(fileName);
            if (inputStream == null) {
                throw new RuntimeException("Resource " + fileName + " is not found!");
            }
            InputStreamReader reader = new InputStreamReader(inputStream);
            try {
                String string = CharStreams.toString((Readable)reader);
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("Can't read " + fileName + "!", e);
            }
            finally {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
    }, "JSLINT", null);

    @NotNull
    public static JSLintExternalAnnotator getInstanceForBatchInspection() {
        JSLintExternalAnnotator jSLintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (jSLintExternalAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintExternalAnnotator", "getInstanceForBatchInspection"));
        }
        return jSLintExternalAnnotator;
    }

    public JSLintExternalAnnotator() {
        this(true);
    }

    public JSLintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected JSLinterConfigurable<JSLintState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jslint/JSLintExternalAnnotator", "createSettingsConfigurable"));
        }
        JSLintConfigurable jSLintConfigurable = new JSLintConfigurable(project);
        if (jSLintConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintExternalAnnotator", "createSettingsConfigurable"));
        }
        return jSLintConfigurable;
    }

    @Override
    protected Class<? extends JSLinterConfiguration<JSLintState>> getConfigurationClass() {
        return JSLintConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return JSLintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jslint/JSLintExternalAnnotator", "acceptPsiFile"));
        }
        return file instanceof JSFile && JSUtils.isJavaScriptFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSLinterAnnotationResult<JSLintState> doAnnotate(JSLinterInput<JSLintState> collectedInfo) {
        if (collectedInfo == null) {
            return null;
        }
        Context cx = Context.enter();
        try {
            JSLintState state = collectedInfo.getState();
            JSLintOptionsState optionsState = state.getOptionsState();
            NativeObject optionsNativeObject = JSLintExternalAnnotator.convertOptionsToNativeObject(optionsState);
            Object[] args = new Object[]{collectedInfo.getFileContent(), optionsNativeObject};
            FunctionWithScope functionWithScope = JSLINT_FUNCTION_MANAGER.getFunctionWithScope();
            Function function = functionWithScope.getFunction();
            Scriptable scope = functionWithScope.getScope();
            Object status = function.call(cx, scope, scope, args);
            Boolean noErrors = (Boolean)Context.jsToJava((Object)status, Boolean.class);
            if (!noErrors.booleanValue()) {
                Object errorsObj = function.get("errors", scope);
                if (errorsObj == null || errorsObj == Scriptable.NOT_FOUND) {
                    throw new RuntimeException(JSLINT_FUNCTION_MANAGER.getFunctionName() + ".errors is " + errorsObj);
                }
                List<JSLinterError> errors = JSLintExternalAnnotator.convertErrors((NativeArray)errorsObj);
                JSLinterAnnotationResult<JSLintState> jSLinterAnnotationResult = JSLinterAnnotationResult.createLinterResult(collectedInfo, errors, null);
                return jSLinterAnnotationResult;
            }
            JSLinterAnnotationResult<JSLintState> jSLinterAnnotationResult = null;
            return jSLinterAnnotationResult;
        }
        finally {
            Context.exit();
        }
    }

    @NotNull
    private static List<JSLinterError> convertErrors(@NotNull NativeArray errorsNativeArray) {
        if (errorsNativeArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorsNativeArray", "com/intellij/lang/javascript/linter/jslint/JSLintExternalAnnotator", "convertErrors"));
        }
        ArrayList errors = ContainerUtil.newArrayListWithCapacity((int)errorsNativeArray.size());
        for (Object errorObj : errorsNativeArray) {
            JSLinterError error;
            if (!(errorObj instanceof NativeObject) || (error = JSLintExternalAnnotator.toLinterError((NativeObject)errorObj)) == null) continue;
            errors.add(error);
        }
        ArrayList arrayList = errors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintExternalAnnotator", "convertErrors"));
        }
        return arrayList;
    }

    @Nullable
    private static JSLinterError toLinterError(@NotNull NativeObject nativeError) {
        if (nativeError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeError", "com/intellij/lang/javascript/linter/jslint/JSLintExternalAnnotator", "toLinterError"));
        }
        int line = JSLintExternalAnnotator.toInt(nativeError.get((Object)"line"));
        int character = JSLintExternalAnnotator.toInt(nativeError.get((Object)"character"));
        if (line < 0 || character < 0) {
            return null;
        }
        String reason = RhinoUtil.getStringKey(nativeError, "reason");
        if (reason != null) {
            return new JSLinterError(line, character, reason, null);
        }
        return null;
    }

    private static int toInt(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return -1;
    }

    @NotNull
    private static NativeObject convertOptionsToNativeObject(@NotNull JSLintOptionsState optionsState) {
        if (optionsState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsState", "com/intellij/lang/javascript/linter/jslint/JSLintExternalAnnotator", "convertOptionsToNativeObject"));
        }
        NativeObject object = new NativeObject();
        for (JSLintOption option : optionsState.getOptions()) {
            Object nativeObj;
            Object value = optionsState.getValue(option);
            if (value == null) continue;
            if (value instanceof Boolean) {
                nativeObj = value;
            } else if (value instanceof String) {
                nativeObj = option == JSLintOption.PREDEF ? JSLinterUtil.convertPredefStrToNativeObj((String)value) : value;
            } else if (value instanceof Number) {
                nativeObj = value;
            } else {
                throw new RuntimeException();
            }
            object.defineProperty(option.getOptionName(), nativeObj, 1);
        }
        NativeObject nativeObject = object;
        if (nativeObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintExternalAnnotator", "convertOptionsToNativeObject"));
        }
        return nativeObject;
    }

    @Override
    public void apply(@NotNull PsiFile file, JSLinterAnnotationResult<JSLintState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jslint/JSLintExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/jslint/JSLintExternalAnnotator", "apply"));
        }
        if (annotationResult == null) {
            return;
        }
        InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance((Project)file.getProject());
        SeverityRegistrar severityRegistrar = inspectionProjectProfileManager.getSeverityRegistrar();
        HighlightDisplayKey inspectionKey = JSLintInspection.getHighlightDisplayKey();
        HighlightSeverity severity = JSLinterUtil.getSeverity(inspectionProjectProfileManager, inspectionKey, file);
        EditorColorsScheme colorsScheme = annotationResult.getInput().getColorsScheme();
        TextAttributes forcedTextAttributes = JSLinterUtil.getTextAttributes(colorsScheme, severityRegistrar, severity);
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        JSLintConfigurable configurable = new JSLintConfigurable(file.getProject());
        JSLinterEditSettingsAction editSettingsAction = new JSLinterEditSettingsAction(configurable);
        List<JSLinterError> limitedErrors = JSLinterUtil.limitErrorsAtTheSamePosition(annotationResult.getErrors(), 10);
        for (JSLinterError linterError : limitedErrors) {
            Annotation annotation = JSLintExternalAnnotator.createAnnotation(holder, file, document, linterError, "JSLint: ", 1, severity, forcedTextAttributes, inspectionKey, JSLinterExternalAnnotator.HighlightingGranularity.none);
            if (annotation == null) continue;
            annotation.registerFix((IntentionAction)editSettingsAction, null, inspectionKey);
        }
    }
}

