/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jslint;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JSLintOption {
    ASS(Type.BOOLEAN, "Tolerate assignment expressions", "check if assignment should be allowed outside of statement position"),
    BITWISE(Type.BOOLEAN, "Tolerate bitwise operators", "check if bitwise operators should be allowed"),
    BROWSER(Type.BOOLEAN, "Assume a browser", "check if the standard browser globals should be predefined"),
    CLOSURE(Type.BOOLEAN, "Tolerate Google Closure idioms", "check if Google Closure annotations should be allowed"),
    CONTINUE(Type.BOOLEAN, "Tolerate continue", "check if the continue statement should be allowed"),
    COUCH(Type.BOOLEAN, "Assume CouchDB", "check if Couch DB globals should be predefined"),
    DEBUG(Type.BOOLEAN, "Tolerate debugger statements", "Check if debugger statements should be allowed. Set this option to false before going into production."),
    DEVEL(Type.BOOLEAN, "Assume console, alert, ...", "check if browser globals that are useful in development should be predefined"),
    EQEQ(Type.BOOLEAN, "Tolerate == and !=", "check if the == and != operators should be tolerated"),
    EVIL(Type.BOOLEAN, "Tolerate eval", "check if eval should be allowed"),
    FORIN(Type.BOOLEAN, "Tolerate unfiltered for in", "check if unfiltered for in statements should be allowed"),
    INDENT(Type.INTEGER, "Indentation", "Number of spaces used for indentation"),
    MAXERR(Type.INTEGER, "Maximum number of errors", "Maximum number of warnings reported"),
    MAXLEN(Type.INTEGER, "Maximum line length", "Maximum number of characters in a line"),
    NEWCAP(Type.BOOLEAN, "Tolerate uncapitalized constructors", "check if Initial Caps with constructor functions is optional"),
    NODE(Type.BOOLEAN, "Assume Node.js", "check if Node.js globals should be predefined"),
    NOMEN(Type.BOOLEAN, "Tolerate dangling _ in identifiers", "check if names should not be checked for initial or trailing underbars"),
    PASSFAIL(Type.BOOLEAN, "Stop on first error", "check if the scan should stop on first error"),
    PLUSPLUS(Type.BOOLEAN, "Tolerate ++ and --", "check if ++ and -- should be allowed"),
    PREDEF(Type.STRING, "Predefined ( , separated)", "An array of strings, the names of predefined global variables, or an object whose keys are global variable names, and whose values are booleans that determine if each variable is assignable. predef is used with the option object, but not with the /*jslint */ directive. You can also use the var statement to declare global variables in a script file."),
    REGEXP(Type.BOOLEAN, "Tolerate . and [^...]. in /RegExp/", "Check if . and [^...] should be allowed in RegExp literals. They match more material than might be expected, allowing attackers to confuse applications. These forms should not be used when validating in secure applications."),
    RHINO(Type.BOOLEAN, "Assume Rhino", "check if the Rhino environment globals should be predefined"),
    SLOPPY(Type.BOOLEAN, "Tolerate missing 'use strict' pragma", "check if the 'use strict'; pragma is not required"),
    STUPID(Type.BOOLEAN, "Tolerate stupidity", "check if blocking (-Sync) methods can be used"),
    SUB(Type.BOOLEAN, "Tolerate inefficient subscripting", "check if subscript notation may be used for expressions better expressed in dot notation"),
    TODO(Type.BOOLEAN, "Tolerate TODO comments", "check if comments starting with TODO should be allowed"),
    UNPARAM(Type.BOOLEAN, "Tolerate unused parameters", "check if warnings should not be given for unused parameters"),
    VARS(Type.BOOLEAN, "Tolerate many var statements", "check if multiple var statement per function should be allowed"),
    WHITE(Type.BOOLEAN, "Tolerate messy white space", "check if strict whitespace rules should be ignored");

    private final String myOptionName;
    private final Type myType;
    private final String myDescription;
    private final String myMeaning;
    private static final ImmutableMap<String, JSLintOption> OPTION_BY_NAME_MAP;

    private JSLintOption(@NotNull Type type, String description, String meaning) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "<init>"));
        }
        if (meaning == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meaning", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "<init>"));
        }
        this.myOptionName = this.name().toLowerCase(Locale.US);
        this.myType = type;
        this.myDescription = description;
        this.myMeaning = meaning;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "getType"));
        }
        return type;
    }

    @NotNull
    public String getOptionName() {
        String string = this.myOptionName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "getOptionName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getMeaning() {
        String string = this.myMeaning;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "getMeaning"));
        }
        return string;
    }

    @Nullable
    public static JSLintOption findByName(@NotNull String optionName) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/lang/javascript/linter/jslint/JSLintOption", "findByName"));
        }
        return (JSLintOption)((Object)OPTION_BY_NAME_MAP.get((Object)optionName));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (JSLintOption option : JSLintOption.values()) {
            builder.put((Object)option.getOptionName(), (Object)option);
        }
        OPTION_BY_NAME_MAP = builder.build();
    }

    public static enum Type {
        BOOLEAN((Class)Boolean.class){

            @Override
            public Boolean createObject(@NotNull String valueStr) {
                if (valueStr == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueStr", "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$1", "createObject"));
                }
                return Boolean.parseBoolean(valueStr);
            }

            @Override
            public boolean isDefault(@NotNull Object value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$1", "isDefault"));
                }
                return value == Boolean.FALSE;
            }
        }
        ,
        STRING((Class)String.class){

            @Override
            public String createObject(@NotNull String valueStr) {
                if (valueStr == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueStr", "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$2", "createObject"));
                }
                return valueStr;
            }

            @Override
            public boolean isDefault(@NotNull Object value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$2", "isDefault"));
                }
                return "".equals(value);
            }
        }
        ,
        INTEGER((Class)Integer.class){

            @Override
            public Integer createObject(@NotNull String valueStr) {
                if (valueStr == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueStr", "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$3", "createObject"));
                }
                try {
                    return Integer.parseInt(valueStr);
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public boolean isDefault(@NotNull Object value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$3", "isDefault"));
                }
                return false;
            }

            @Override
            public boolean isProperValue(@Nullable Object obj) {
                if (obj == null) {
                    return true;
                }
                if (obj instanceof Integer || obj instanceof Long) {
                    Number n = (Number)obj;
                    return n.intValue() >= 0;
                }
                return false;
            }
        };

        private final Class<?> myClass;

        private Type(Class<?> clazz) {
            this.myClass = clazz;
        }

        @Nullable
        public abstract Object createObject(@NotNull String var1);

        public abstract boolean isDefault(@NotNull Object var1);

        public boolean isProperValue(@Nullable Object obj) {
            return obj == null || this.myClass.isInstance(obj);
        }
    }
}

