/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint;

import com.google.common.base.Charsets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.idea.RareLogger;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.lang.javascript.linter.FilesMirror;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.tslint.TsLintBinFileVersionManager;
import com.intellij.lang.javascript.linter.tslint.TsLintConfigFileChangeTracker;
import com.intellij.lang.javascript.linter.tslint.TsLintConfigFileSearcher;
import com.intellij.lang.javascript.linter.tslint.TsLintOutputParser;
import com.intellij.lang.javascript.linter.tslint.TsLintState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Producer;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.CommandLineUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TsLintExternalRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.tslint.TsLint");
    private static final String INTERNAL_ERROR = "Internal TSLint problem. Please report the problem and attach the log using \"Help | Show Log in " + ShowFilePathAction.getFileManagerName() + "\"";
    private static final Logger RARE_LOGGER = RareLogger.wrap((Logger)LOG, (boolean)false);
    private static final SemVer VERSION_2_4_0 = new SemVer("2.4.0", 2, 4, 0);
    private final JSLinterInput<TsLintState> myInputInfo;
    private final FilesMirror myCodeFilesMirror;
    private final FilesMirror myConfigFilesMirror;
    private final TsLintBinFileVersionManager myBinFileVersionManager;
    private final Project myProject;
    private final List<Producer<JSLinterAnnotationResult<TsLintState>>> mySteps;
    private File myActualConfigFile;
    private File myActualCodeFile;
    private VirtualFile myConfigVirtualFile;
    private VirtualFile myCodeVirtualFile;
    private File myNodeFile;
    private File myPackageDir;
    private File myTsLintFile;
    private SemVer myTsLintVersion;
    private boolean myFix;
    private boolean mySkip;

    public TsLintExternalRunner(@NotNull JSLinterInput<TsLintState> inputInfo, @NotNull FilesMirror codeFilesMirror, @NotNull FilesMirror configFilesMirror, @NotNull TsLintBinFileVersionManager binFileVersionManager, @NotNull Project project) {
        if (inputInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputInfo", "com/intellij/lang/javascript/linter/tslint/TsLintExternalRunner", "<init>"));
        }
        if (codeFilesMirror == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFilesMirror", "com/intellij/lang/javascript/linter/tslint/TsLintExternalRunner", "<init>"));
        }
        if (configFilesMirror == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFilesMirror", "com/intellij/lang/javascript/linter/tslint/TsLintExternalRunner", "<init>"));
        }
        if (binFileVersionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binFileVersionManager", "com/intellij/lang/javascript/linter/tslint/TsLintExternalRunner", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/TsLintExternalRunner", "<init>"));
        }
        this.myInputInfo = inputInfo;
        this.myCodeFilesMirror = codeFilesMirror;
        this.myConfigFilesMirror = configFilesMirror;
        this.myBinFileVersionManager = binFileVersionManager;
        this.myProject = project;
        this.mySteps = new ArrayList<Producer<JSLinterAnnotationResult<TsLintState>>>();
        this.mySteps.add(this.checkExePath());
        this.mySteps.add(this.checkTargetVirtualFile());
        this.mySteps.add(this.checkConfigPath());
        this.mySteps.add(this.checkIfTargetFileChanged());
        this.mySteps.add(this.runExternalProcess());
    }

    public JSLinterAnnotationResult<TsLintState> execute() {
        for (Producer<JSLinterAnnotationResult<TsLintState>> step : this.mySteps) {
            JSLinterAnnotationResult result = (JSLinterAnnotationResult)step.produce();
            if (result != null) {
                return result;
            }
            if (!this.mySkip) continue;
            return null;
        }
        return null;
    }

    private Producer<JSLinterAnnotationResult<TsLintState>> runExternalProcess() {
        return new Producer<JSLinterAnnotationResult<TsLintState>>(){

            @Nullable
            public JSLinterAnnotationResult<TsLintState> produce() {
                Process process;
                File workingDirectory = TsLintExternalRunner.this.myActualCodeFile.getParentFile();
                if (workingDirectory == null) {
                    LOG.debug("Skipped TSLint file analysis: can not find working directory for file: " + TsLintExternalRunner.this.myActualCodeFile.getPath());
                    TsLintExternalRunner.this.mySkip = true;
                    return null;
                }
                TsLintConfigFileChangeTracker.getInstance(TsLintExternalRunner.this.myProject).startIfNeeded();
                GeneralCommandLine commandLine = TsLintExternalRunner.this.createCommandLine(workingDirectory);
                try {
                    process = commandLine.createProcess();
                }
                catch (ExecutionException e) {
                    return TsLintExternalRunner.this.createError("Can not start TSLint process: " + e.getMessage());
                }
                OSProcessHandler processHandler = new OSProcessHandler(process, null, Charsets.UTF_8);
                boolean zeroBasedRowCol = TsLintExternalRunner.this.myTsLintVersion != null && (TsLintExternalRunner.this.myTsLintVersion.getMajor() < 2 || TsLintExternalRunner.this.myTsLintVersion.getMajor() == 2 && TsLintExternalRunner.this.myTsLintVersion.getMinor() <= 1);
                TsLintOutputParser parser = new TsLintOutputParser(TsLintExternalRunner.this.myActualCodeFile.getPath(), zeroBasedRowCol);
                processHandler.addProcessListener((ProcessListener)parser);
                processHandler.startNotify();
                String timeoutError = JSLinterUtil.waitForProcessUnderProgress(processHandler, ProgressManager.getInstance().getProgressIndicator(), TimeUnit.SECONDS.toMillis(10L), "TSLint");
                if (timeoutError != null) {
                    return JSLinterAnnotationResult.createLinterFailResult(TsLintExternalRunner.this.myInputInfo, timeoutError, TsLintExternalRunner.this.myConfigVirtualFile);
                }
                parser.process();
                JSLinterErrorBase error = parser.getGlobalError();
                if (error != null) {
                    if (TsLintExternalRunner.this.isInnerProblem(error)) {
                        if (PsiErrorElementUtil.hasErrors((Project)TsLintExternalRunner.this.myProject, (VirtualFile)TsLintExternalRunner.this.myCodeVirtualFile)) {
                            return JSLinterAnnotationResult.createLinterResult(TsLintExternalRunner.this.myInputInfo, Collections.<JSLinterError>emptyList(), TsLintExternalRunner.this.myConfigVirtualFile);
                        }
                        return JSLinterAnnotationResult.createLinterFailResult(TsLintExternalRunner.this.myInputInfo, INTERNAL_ERROR, null);
                    }
                    return JSLinterAnnotationResult.createLinterFailResult(TsLintExternalRunner.this.myInputInfo, error, TsLintExternalRunner.this.myConfigVirtualFile);
                }
                return JSLinterAnnotationResult.createLinterResult(TsLintExternalRunner.this.myInputInfo, parser.getErrors(), TsLintExternalRunner.this.myConfigVirtualFile);
            }
        };
    }

    private boolean isInnerProblem(JSLinterErrorBase error) {
        String description = error.getDescription();
        if (this.isStackTrace(description)) {
            String version = this.myTsLintVersion == null ? "unknown" : this.myTsLintVersion.getRawVersion();
            RARE_LOGGER.info("TsLint inner error. TsLint version: " + version + "\n\n" + description);
            return true;
        }
        return false;
    }

    private boolean isStackTrace(String description) {
        String[] lines = StringUtil.splitByLines((String)description);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!line.contains("Error") || i >= lines.length - 1 || !lines[i + 1].trim().startsWith("at ")) continue;
            return true;
        }
        return false;
    }

    private GeneralCommandLine createCommandLine(File workingDir) {
        boolean passOldFileFlag;
        String rulesDirectory;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(Charsets.UTF_8);
        CommandLineUtil.configureShellEnvironment((GeneralCommandLine)commandLine, (boolean)true, Collections.emptyMap());
        commandLine.withWorkDirectory(workingDir);
        commandLine.setExePath(this.myNodeFile.getAbsolutePath());
        commandLine.addParameter(this.myTsLintFile.getAbsolutePath());
        commandLine.addParameters(new String[]{"-t json"});
        if (this.myActualConfigFile != null) {
            commandLine.addParameters(new String[]{"-c", this.myActualConfigFile.getAbsolutePath()});
        }
        if (!StringUtil.isEmptyOrSpaces((String)(rulesDirectory = this.myInputInfo.getState().getRulesDirectory()))) {
            commandLine.addParameters(new String[]{"-r", rulesDirectory});
        }
        boolean bl = passOldFileFlag = this.myTsLintVersion != null && this.myTsLintVersion.compareTo(VERSION_2_4_0) < 0;
        if (passOldFileFlag) {
            commandLine.addParameter("-f");
        }
        commandLine.addParameters(new String[]{this.myActualCodeFile.getAbsolutePath()});
        return commandLine;
    }

    private Producer<JSLinterAnnotationResult<TsLintState>> checkIfTargetFileChanged() {
        return new Producer<JSLinterAnnotationResult<TsLintState>>(){

            @Nullable
            public JSLinterAnnotationResult<TsLintState> produce() {
                PsiFile psiFile = TsLintExternalRunner.this.myInputInfo.getPsiFile();
                TsLintExternalRunner.this.myActualCodeFile = TsLintExternalRunner.this.myCodeFilesMirror.getOrCreateFileWithActualContent(TsLintExternalRunner.this.myCodeVirtualFile, TsLintExternalRunner.this.myInputInfo.getFileContent());
                if (TsLintExternalRunner.this.myActualCodeFile == null) {
                    LOG.debug("Skipped TSLint file analysis: can not mirror target file in temp directory: " + psiFile.getName());
                    TsLintExternalRunner.this.mySkip = true;
                }
                return null;
            }
        };
    }

    private Producer<JSLinterAnnotationResult<TsLintState>> checkConfigPath() {
        return new Producer<JSLinterAnnotationResult<TsLintState>>(){

            @Nullable
            public JSLinterAnnotationResult<TsLintState> produce() {
                TsLintState state = (TsLintState)TsLintExternalRunner.this.myInputInfo.getState();
                if (state.isCustomConfigFileUsed()) {
                    String configFilePath = state.getCustomConfigFilePath();
                    if (StringUtil.isEmptyOrSpaces((String)configFilePath)) {
                        return TsLintExternalRunner.this.createError("Configuration file for TSLint is not specified");
                    }
                    File configFile = new File(configFilePath);
                    TsLintExternalRunner.this.myConfigVirtualFile = VfsUtil.findFileByIoFile((File)configFile, (boolean)false);
                    if (TsLintExternalRunner.this.myConfigVirtualFile == null) {
                        return TsLintExternalRunner.this.createError("Can not find configuration file for TSLint by path: " + configFilePath);
                    }
                } else {
                    TsLintConfigFileSearcher searcher = new TsLintConfigFileSearcher();
                    TsLintExternalRunner.this.myConfigVirtualFile = searcher.lookup(TsLintExternalRunner.this.myInputInfo.getPsiFile().getVirtualFile());
                    if (TsLintExternalRunner.this.myConfigVirtualFile == null) {
                        return TsLintExternalRunner.this.createError("Configuration file for TSLint is not found");
                    }
                }
                TsLintExternalRunner.this.myActualConfigFile = TsLintExternalRunner.this.myConfigFilesMirror.getOrCreateFileWithActualContent(TsLintExternalRunner.this.myConfigVirtualFile, null);
                if (TsLintExternalRunner.this.myActualConfigFile == null) {
                    LOG.debug("Skipped TSLint file analysis: can not mirror config file in temp directory: " + TsLintExternalRunner.this.myConfigVirtualFile.getPath());
                    TsLintExternalRunner.this.mySkip = true;
                }
                return null;
            }
        };
    }

    private Producer<JSLinterAnnotationResult<TsLintState>> checkTargetVirtualFile() {
        return new Producer<JSLinterAnnotationResult<TsLintState>>(){

            @Nullable
            public JSLinterAnnotationResult<TsLintState> produce() {
                PsiFile psiFile = TsLintExternalRunner.this.myInputInfo.getPsiFile();
                TsLintExternalRunner.this.myCodeVirtualFile = psiFile.getVirtualFile();
                if (TsLintExternalRunner.this.myCodeVirtualFile == null || !TsLintExternalRunner.this.myCodeVirtualFile.isValid()) {
                    LOG.debug("Skipped TSLint file analysis: can not load target file as virtual file: " + psiFile.getName());
                    TsLintExternalRunner.this.mySkip = true;
                    return null;
                }
                return null;
            }
        };
    }

    private Producer<JSLinterAnnotationResult<TsLintState>> checkExePath() {
        return new Producer<JSLinterAnnotationResult<TsLintState>>(){

            @Nullable
            public JSLinterAnnotationResult<TsLintState> produce() {
                TsLintState state = (TsLintState)TsLintExternalRunner.this.myInputInfo.getState();
                String nodePath = state.getNodePath();
                if (StringUtil.isEmptyOrSpaces((String)nodePath)) {
                    return TsLintExternalRunner.this.createError("Node interpreter file is not specified");
                }
                TsLintExternalRunner.this.myNodeFile = new File(nodePath);
                if (!(TsLintExternalRunner.this.myNodeFile.isFile() && TsLintExternalRunner.this.myNodeFile.isAbsolute() && TsLintExternalRunner.this.myNodeFile.canExecute())) {
                    return TsLintExternalRunner.this.createError("Node interpreter file is not found");
                }
                String packagePath = state.getPackagePath();
                if (StringUtil.isEmptyOrSpaces((String)packagePath)) {
                    return TsLintExternalRunner.this.createError("TSLint package directory is not specified");
                }
                TsLintExternalRunner.this.myPackageDir = new File(packagePath);
                if (TsLintExternalRunner.this.myPackageDir.isDirectory()) {
                    if (!TsLintExternalRunner.this.myPackageDir.isAbsolute()) {
                        return TsLintExternalRunner.this.createError("TSLint package directory is not found");
                    }
                    TsLintExternalRunner.this.myTsLintFile = new File(TsLintExternalRunner.this.myPackageDir, "bin" + File.separator + "tslint");
                    TsLintExternalRunner.this.myTsLintVersion = NodePackageVersionUtil.getPackageVersion(TsLintExternalRunner.this.myPackageDir);
                } else {
                    TsLintExternalRunner.this.myTsLintFile = TsLintExternalRunner.this.myPackageDir;
                    try {
                        TsLintExternalRunner.this.myTsLintVersion = TsLintExternalRunner.this.myBinFileVersionManager.getVersion(TsLintExternalRunner.this.myNodeFile.getAbsolutePath(), TsLintExternalRunner.this.myTsLintFile, Collections.singletonList("--version"), 10000L);
                    }
                    catch (ExecutionException e) {
                        LOG.info("Cannot fetch version of " + TsLintExternalRunner.this.myTsLintFile.getAbsolutePath(), (Throwable)e);
                    }
                }
                if (!TsLintExternalRunner.this.myTsLintFile.exists()) {
                    if (TsLintExternalRunner.this.myTsLintFile == TsLintExternalRunner.this.myPackageDir) {
                        return TsLintExternalRunner.this.createError("Provided TSLint path does not exist");
                    }
                    return TsLintExternalRunner.this.createError("Can not find 'tslint' script file under TSLint package directory");
                }
                return null;
            }
        };
    }

    private JSLinterAnnotationResult<TsLintState> createError(String error) {
        return JSLinterAnnotationResult.createLinterFailResult(this.myInputInfo, error, this.myConfigVirtualFile);
    }
}

