/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.javascript.ActionScriptCodeContextType;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptCodeContextType;
import com.intellij.lang.javascript.macro.JSMacroUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSArrayVariableMacro
extends Macro {
    public String getName() {
        return "jsArrayVariable";
    }

    public String getPresentableName() {
        return JSBundle.message((String)"macro.js.array.variable", (Object[])new Object[0]);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/lang/javascript/macro/JSArrayVariableMacro", "calculateLookupItems"));
        }
        PsiNamedElement[] vars = JSArrayVariableMacro.getVariables(params, context);
        if (vars == null || vars.length < 2) {
            return null;
        }
        LinkedHashSet<LookupElementBuilder> set = new LinkedHashSet<LookupElementBuilder>();
        for (PsiNamedElement element : vars) {
            LookupElementBuilder lookupElement = LookupElementBuilder.create((PsiNamedElement)element).withIcon(element.getIcon(1));
            if (element instanceof JSVariable) {
                lookupElement = lookupElement.withTypeText(((JSVariable)element).getTypeString());
            }
            set.add(lookupElement);
        }
        return set.toArray(new LookupElement[set.size()]);
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/lang/javascript/macro/JSArrayVariableMacro", "calculateResult"));
        }
        PsiNamedElement[] vars = JSArrayVariableMacro.getVariables(params, context);
        if (vars == null || vars.length == 0) {
            return null;
        }
        return new PsiElementResult((PsiElement)vars[0]){

            @Nullable
            public String toString() {
                PsiElement element = this.getElement();
                if (element instanceof JSNamedElement) {
                    return ((JSNamedElement)element).getName();
                }
                return super.toString();
            }
        };
    }

    @Nullable
    private static PsiNamedElement[] getVariables(Expression[] params, ExpressionContext context) {
        JSNamedElement[] allVars;
        if (params.length != 0) {
            return null;
        }
        ArrayList<JSNamedElement> vars = new ArrayList<JSNamedElement>();
        for (JSNamedElement var : allVars = JSMacroUtil.getNamedElementsVisibleAt(context)) {
            JSType type;
            if (!(var instanceof JSVariable) && (!(var instanceof JSFunction) || ((JSFunction)var).getKind() != JSFunction.FunctionKind.GETTER)) continue;
            JSType jSType = type = var instanceof JSVariable ? ((JSVariable)var).getType() : ((JSFunction)var).getReturnType();
            if (type instanceof JSNumberType || type instanceof JSIntType || type instanceof JSUintType || type instanceof JSBooleanType) continue;
            vars.add(var);
        }
        return (PsiNamedElement[])vars.toArray(new JSNamedElement[vars.size()]);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaScriptCodeContextType || context instanceof ActionScriptCodeContextType;
    }
}

