/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.RequireFileQuotesCache;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.modules.AddInnerRequireAmdModuleToModulesListFix;
import com.intellij.lang.javascript.modules.AddRequiredAmdModuleToModulesListFix;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmdJsModulesSuggester
implements JsModulesSuggester {
    @NotNull
    private final LocalInspectionToolSession mySession;
    @NotNull
    private final ModuleReferenceInfo myModuleReferenceInfo;
    @NotNull
    private final JSReferenceExpression myNode;
    private final JSAmdUtil.AmdLoaderCall myWrappingAmdLoaderCall;
    @NotNull
    private final List<LocalQuickFix> myFirstWordFixes;
    private Set<VirtualFile> myPredefinedFiles;
    private static final TokenSet CALL_EXPRESSIONS_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.CALL_EXPRESSION});

    public AmdJsModulesSuggester(@NotNull LocalInspectionToolSession session, @NotNull ModuleReferenceInfo info, @NotNull JSReferenceExpression node, JSAmdUtil.AmdLoaderCall amdLoaderCall) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/modules/AmdJsModulesSuggester", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/modules/AmdJsModulesSuggester", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/AmdJsModulesSuggester", "<init>"));
        }
        this.mySession = session;
        this.myModuleReferenceInfo = info;
        this.myNode = node;
        this.myWrappingAmdLoaderCall = amdLoaderCall;
        this.myFirstWordFixes = new ArrayList<LocalQuickFix>();
    }

    @Override
    public boolean isResolvedGlobally(@NotNull ResolveResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/modules/AmdJsModulesSuggester", "isResolvedGlobally"));
        }
        if (result instanceof JSDefinitionExpression && ((JSDefinitionExpression)result).getNamespace() == null) {
            return true;
        }
        return result instanceof JSVariable && ((JSVariable)result).getNamespace() == null;
    }

    @Override
    public void findFixes(ResolveResult[] resolveResults, @NotNull Set<VirtualFile> predefinedFiles) {
        if (predefinedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predefinedFiles", "com/intellij/lang/javascript/modules/AmdJsModulesSuggester", "findFixes"));
        }
        this.myPredefinedFiles = predefinedFiles;
        if (this.myModuleReferenceInfo.getTopLevelInModuleRef() != null) {
            this.findVariantsForMethods();
        } else {
            this.findVariantsByName();
        }
    }

    private void findVariantsByName() {
        PsiFile[] filesByName;
        for (PsiFile file : filesByName = FilenameIndex.getFilesByName((Project)this.myNode.getProject(), (String)(this.myNode.getText() + ".js"), (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myNode.getProject()))) {
            PsiElement[] possible;
            if (!file.isValid() || this.myNode.getContainingFile().equals(file) || !(file instanceof JSFile)) continue;
            for (PsiElement expression : possible = JSStubBasedPsiTreeUtil.getChildrenByType((JSElement)((JSFile)file), CALL_EXPRESSIONS_TOKEN_SET)) {
                if (!(expression instanceof JSCallExpression) || !((JSCallExpression)expression).isDefineCall()) continue;
                this.addFixForElementInFile(expression, JSAmdPsiUtil.getExplicitModuleName((JSCallExpression)expression), file);
            }
        }
    }

    private void findVariantsForMethods() {
        ResolveResult[] results = this.myModuleReferenceInfo.getTopLevelInModuleRef().multiResolve(false);
        if (results.length == 0) {
            return;
        }
        for (ResolveResult resolveResult : results) {
            Pair<Boolean, String> pair;
            PsiFile resolveFile;
            PsiElement resolvedElement = resolveResult.getElement();
            if (!resolveResult.isValidResult() || resolvedElement == null || (resolveFile = resolvedElement.getContainingFile()).equals(this.myNode.getContainingFile()) || !Boolean.TRUE.equals((pair = JSAmdUtil.isFromAmdModuleReturn(resolvedElement)).getFirst())) continue;
            this.addFixForElementInFile(resolvedElement, (String)pair.getSecond(), resolveFile);
        }
    }

    private void addFixForElementInFile(PsiElement resolvedElement, @Nullable String moduleId, PsiFile resolveFile) {
        if (this.myPredefinedFiles.contains(resolvedElement.getContainingFile().getVirtualFile())) {
            return;
        }
        String reference = moduleId != null ? moduleId : this.clarifyModuleReference(resolvedElement, resolveFile, resolveFile.getVirtualFile().getNameWithoutExtension());
        boolean isSingleQuotes = RequireFileQuotesCache.getInstance().isSingleQuotes(this.myNode.getContainingFile());
        if (this.myWrappingAmdLoaderCall.isDefinesModule() && this.myWrappingAmdLoaderCall.getRequireSugaredParameter() != null && this.myWrappingAmdLoaderCall.getModulesArray() == null) {
            this.myFirstWordFixes.add(new AddInnerRequireAmdModuleToModulesListFix(this.myWrappingAmdLoaderCall.getRequireSugaredParameter().getText(), this.myWrappingAmdLoaderCall.wrapInPointers(), reference, this.myNode.getReferenceName(), isSingleQuotes));
            return;
        }
        this.myFirstWordFixes.add(new AddRequiredAmdModuleToModulesListFix(this.myWrappingAmdLoaderCall.wrapInPointers(), reference, this.myNode.getReferenceName(), isSingleQuotes));
    }

    private String clarifyModuleReference(PsiElement resolvedElement, PsiFile resolveFile, String reference) {
        if (Comparing.equal((Object)this.myNode.getContainingFile().getVirtualFile().getParent(), (Object)resolveFile.getVirtualFile().getParent())) {
            reference = "./" + reference;
        } else {
            VirtualFile base = this.findPossibleModuleBase(resolvedElement, this.myNode.getContainingFile().getVirtualFile());
            if (base != null) {
                String variant = null;
                String aliasedVariant = JSAmdUtil.correctPathWithAliases(resolvedElement);
                if (aliasedVariant != null) {
                    variant = aliasedVariant;
                } else {
                    variant = this.betterRelativeFile(resolveFile.getVirtualFile(), base, '/');
                    if (variant != null && (variant.startsWith("../") || variant.startsWith("./") || variant.startsWith("/"))) {
                        variant = base.getName() + "/" + variant;
                    }
                }
                reference = variant != null ? AmdJsModulesSuggester.cutExtension(resolveFile.getName(), variant) : reference;
            }
        }
        return reference;
    }

    private static String cutExtension(String original, String relative) {
        int idx;
        if (original.contains(".") && (idx = relative.lastIndexOf(46)) > 0) {
            return relative.substring(0, idx);
        }
        return relative;
    }

    public VirtualFile findPossibleModuleBase(PsiElement resolved, @NotNull VirtualFile nodeFile) {
        if (nodeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeFile", "com/intellij/lang/javascript/modules/AmdJsModulesSuggester", "findPossibleModuleBase"));
        }
        final VirtualFile file = resolved.getContainingFile().getVirtualFile();
        ArrayList matches = new ArrayList(ContainerUtil.map(JSAmdUtil.getBaseDirectories(resolved), (Function)new Function<PsiDirectory, VirtualFile>(){

            public VirtualFile fun(PsiDirectory directory) {
                return directory.getVirtualFile();
            }
        }));
        if (matches.size() > 1) {
            Collections.sort(matches, new Comparator<VirtualFile>(){

                @Override
                public int compare(VirtualFile o1, VirtualFile o2) {
                    String rel1 = VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)o1);
                    String rel2 = VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)o2);
                    if (rel1 == null) {
                        return -1;
                    }
                    if (rel2 == null) {
                        return 1;
                    }
                    return new Integer(rel1.split("/").length).compareTo(rel2.split("/").length);
                }
            });
            return (VirtualFile)matches.get(0);
        }
        if (matches.size() == 1) {
            return (VirtualFile)matches.get(0);
        }
        VirtualFile nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(file);
        if (nodeModulesDir != null && NodeModuleSearchUtil.findAncestorNodeModulesDir(nodeModulesDir) == null) {
            return nodeModulesDir;
        }
        return nodeFile;
    }

    @Nullable
    private String betterRelativeFile(@NotNull VirtualFile file, @NotNull VirtualFile ancestor, char separator) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/AmdJsModulesSuggester", "betterRelativeFile"));
        }
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/lang/javascript/modules/AmdJsModulesSuggester", "betterRelativeFile"));
        }
        String path = VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)ancestor, (char)separator);
        if (path != null) {
            return path;
        }
        if (ancestor.getParent() != null) {
            String part = this.betterRelativeFile(file, ancestor.getParent(), separator);
            return "../" + part;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.myFirstWordFixes.isEmpty();
    }

    @Override
    public List<LocalQuickFix> getFirstWordFixesList() {
        return this.myFirstWordFixes;
    }

    @Override
    public List<LocalQuickFix> getSecondWordFixesList() {
        return Collections.emptyList();
    }
}

