/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.modules.LastImportInScope;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportCommonJSModuleFix
implements ImportJSModuleBaseFix,
LocalQuickFix,
HintAction,
HighPriorityAction {
    @NotNull
    protected final String myModuleName;
    protected final boolean myIsSystem;
    @Nullable
    protected final String myPath;
    protected final boolean mySingleQuotes;
    protected String myVarName;
    private final SmartPsiElementPointer<JSReferenceExpression> myPointer;
    protected boolean myIsSingleWord;
    protected String[] myWithTail;
    protected PsiElement myLastRequireElement;
    protected PsiElement myLastImportElement;
    protected String myExportsMemberName;

    protected ImportCommonJSModuleFix(@NotNull JSReferenceExpression node, @NotNull String moduleName, boolean isSystem, @Nullable String path, boolean singleQuotes) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "<init>"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "<init>"));
        }
        this.mySingleQuotes = singleQuotes;
        this.myModuleName = moduleName;
        this.myIsSystem = isSystem;
        this.myPath = path;
        this.myVarName = node.getReferenceName();
        this.myPointer = SmartPointerManager.getInstance((Project)node.getProject()).createSmartPsiElementPointer((PsiElement)node);
    }

    public ImportCommonJSModuleFix varIsDefinedInModule(String name) {
        this.myExportsMemberName = name;
        this.myIsSingleWord = true;
        return this;
    }

    public ImportCommonJSModuleFix withTail(@NotNull String[] tail) {
        if (tail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tail", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "withTail"));
        }
        this.myWithTail = tail;
        return this;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "invoke"));
        }
        JSReferenceExpression element = (JSReferenceExpression)this.myPointer.getElement();
        if (element != null) {
            this.invokeAction(file, (PsiElement)element, editor);
        }
    }

    private void invokeAction(PsiFile file, PsiElement element, Editor editor) {
        if (!(element instanceof JSReferenceExpression)) {
            return;
        }
        JSReferenceExpression reference = (JSReferenceExpression)element;
        PsiElement last = new LastImportInScope(this.isPreferImportAnchor()).findAndSelect((PsiElement)file);
        PsiElement created = this.createRequire(file.getProject());
        if (last == null) {
            PsiElement child = file.getFirstChild();
            if (child == null) {
                file.add(created);
            } else {
                file.addBefore(created, child);
            }
        } else {
            file.addAfter(created, last);
        }
        this.doSomethingWithCurrentFile(file, reference, editor);
        DaemonCodeAnalyzer.getInstance((Project)file.getProject()).restart(file);
    }

    protected void doSomethingWithCurrentFile(PsiFile file, JSReferenceExpression element, Editor editor) {
        PsiElement replace;
        if (this.myWithTail == null && this.myVarName.equals(element.getReferenceName())) {
            return;
        }
        if (!this.myVarName.equals(element.getReferenceName())) {
            PsiElement current = element.getParent();
            if (!(current instanceof JSReferenceExpression)) {
                return;
            }
            PsiFile dummy = ImportCommonJSModuleFix.createDummyFile(file.getProject(), this.myVarName);
            replace = current.replace(dummy.getFirstChild());
        } else {
            PsiElement current = this.getWholeReferenceElement((PsiElement)element);
            if (current == null) {
                return;
            }
            PsiFile dummy = ImportCommonJSModuleFix.createDummyFile(file.getProject(), this.myWithTail[this.myWithTail.length - 1]);
            replace = current.replace(dummy.getFirstChild());
        }
        if (editor != null) {
            editor.getCaretModel().moveToOffset(replace.getTextRange().getEndOffset());
        }
    }

    protected abstract boolean isPreferImportAnchor();

    @NotNull
    protected String getWholeReference() {
        String string = this.myModuleName + "." + StringUtil.join((String[])this.myWithTail, (String)".");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "getWholeReference"));
        }
        return string;
    }

    @Nullable
    protected PsiElement getWholeReferenceElement(PsiElement element) {
        PsiElement current;
        String wholeText = this.getWholeReference();
        for (current = element; current != null; current = current.getParent()) {
            String text = current.getText().replace(" ", "");
            if (text.length() > wholeText.length()) {
                return null;
            }
            if (wholeText.equals(text) && current instanceof JSReferenceExpression) break;
        }
        if (current == null) {
            return null;
        }
        return current;
    }

    protected abstract PsiElement createRequire(Project var1);

    protected static PsiFile createDummyFile(Project project, String text) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        return psiFileFactory.createFileFromText("dummy." + JavaScriptFileType.INSTANCE.getDefaultExtension(), (FileType)JavaScriptFileType.INSTANCE, (CharSequence)text);
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "showHint"));
        }
        return false;
    }

    public String getPath() {
        return this.myPath;
    }

    @Override
    public String getVarName() {
        return this.myVarName;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = ImportCommonJSModuleFix.class.getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Node.js" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "getFamilyName"));
        }
        return "Node.js";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof JSReferenceExpression) {
            this.invokeAction(element.getContainingFile(), element, null);
        }
    }

    public void setVarName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "setVarName"));
        }
        this.myVarName = name;
    }
}

