/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.JsDefinedInObject;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;

public class ModuleReferenceInfo {
    private String myModuleName;
    private String myTopLevelMember;
    private JSReferenceExpression myTopLevelInModuleRef;
    private String[] myChain;
    private boolean myUsesPredefined;
    private List<JSReferenceExpression> myTailRef;

    public ModuleReferenceInfo(JSReferenceExpression node) {
        JSReferenceExpression current = node;
        this.myTailRef = new ArrayList<JSReferenceExpression>();
        ArrayList<String> parts = new ArrayList<String>();
        while (current instanceof JSReferenceExpression) {
            String referenceName;
            if (current != node) {
                this.myTailRef.add(current);
            }
            if (parts.size() == 1) {
                this.myTopLevelInModuleRef = current;
            }
            if ((referenceName = current.getReferenceName()) != null) {
                parts.add(referenceName);
            }
            current = current.getParent();
        }
        if (parts.isEmpty()) {
            return;
        }
        this.myModuleName = (String)parts.get(0);
        if (parts.size() > 1) {
            this.myTopLevelMember = (String)parts.get(1);
            this.myUsesPredefined = JsDefinedInObject.isPredefined(this.myTopLevelMember, DialectDetector.dialectOfFile(node.getContainingFile()));
            List subList = parts.subList(1, parts.size());
            this.myChain = ArrayUtil.toStringArray(subList);
        } else {
            this.resetTail();
        }
        if (this.myUsesPredefined) {
            this.resetTail();
        }
    }

    private void resetTail() {
        this.myTopLevelMember = null;
        this.myTopLevelInModuleRef = null;
        this.myChain = new String[0];
    }

    public List<JSReferenceExpression> getTailRef() {
        return this.myTailRef;
    }

    public JSReferenceExpression getTopLevelInModuleRef() {
        return this.myTopLevelInModuleRef;
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    public String getTopLevelMember() {
        return this.myTopLevelMember;
    }

    public String[] getChain() {
        return this.myChain;
    }

    public boolean haveTail() {
        return this.myChain != null && this.myChain.length > 0;
    }

    public boolean isUsesPredefined() {
        return this.myUsesPredefined;
    }
}

