/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.nashorn.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.nashorn.NashornJSElementTypes;
import com.intellij.lang.javascript.nashorn.parsing.NashornJSParser;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.psi.tree.IElementType;

public class NashornJSExpressionParser
extends ExpressionParser<NashornJSParser> {
    protected NashornJSExpressionParser(NashornJSParser parser) {
        super(parser);
    }

    @Override
    public void parseArgumentList() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LPAR);
        PsiBuilder.Marker arglist = this.builder.mark();
        this.parseArgumentListNoMarker();
        if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            this.parseObjectLiteralExpression(false);
        }
        arglist.done(NashornJSElementTypes.ARGUMENT_LIST);
    }

    @Override
    protected boolean parseDialectSpecificMemberExpressionPart() {
        if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            PsiBuilder.Marker arglist = this.builder.mark();
            this.parseObjectLiteralExpression(false);
            arglist.done(NashornJSElementTypes.ARGUMENT_LIST);
        }
        return false;
    }

    @Override
    public boolean parsePrimaryExpression() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.HEREDOC_BOUND) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.HEREDOC_BODY) {
                this.builder.advanceLexer();
            }
            NashornJSExpressionParser.checkMatches(this.builder, JSTokenTypes.HEREDOC_BOUND, "javascript.parser.message.expected.heredoc.closing.identifier");
            marker.done(NashornJSElementTypes.HEREDOC);
            return true;
        }
        if (this.builder.getTokenType() == JSTokenTypes.EXEC_STRING_BOUND) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.EXEC_BODY) {
                this.builder.advanceLexer();
            }
            NashornJSExpressionParser.checkMatches(this.builder, JSTokenTypes.EXEC_STRING_BOUND, "javascript.parser.message.missing.backquote");
            marker.done(NashornJSElementTypes.EXEC_STRING);
            return true;
        }
        return super.parsePrimaryExpression();
    }
}

