/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JSParsingResult;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeNameValuePairImpl;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.NotNull;

public class FunctionParser<T extends JavaScriptParser>
extends JavaScriptParserBase<T> {
    public static final Key<Boolean> ASYNC_METHOD_KEY = Key.create((String)"js.asyncMethod");
    public static final Key<String> methodsEmptinessKey = Key.create((String)"methodsEmptinessKey");
    public static final String METHODS_EMPTINESS_ALWAYS = "a";
    public static final String METHODS_EMPTINESS_POSSIBLY = "p";
    public static final Key<Deque<Boolean>> HAD_GENERATOR_DEF_KEY = Key.create((String)"js.generator.Function");

    protected FunctionParser(T parser) {
        super(parser);
    }

    public boolean parseFunctionExpression() {
        PsiBuilder.Marker mark = this.builder.mark();
        this.parseFunctionExpressionAttributeList();
        return this.parseFunctionNoMarker(Context.EXPRESSION, mark);
    }

    public boolean isFunctionDeclarationStart() {
        return this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD;
    }

    public void parseFunctionDeclaration() {
        String prevMethodEmptiness = (String)this.builder.getUserData(methodsEmptinessKey);
        try {
            PsiBuilder.Marker mark = this.builder.mark();
            this.parseAttributesList();
            this.parseFunctionNoMarker(Context.SOURCE_ELEMENT, mark);
        }
        finally {
            this.builder.putUserData(methodsEmptinessKey, (Object)prevMethodEmptiness);
        }
    }

    public void parseFunctionExpressionAttributeList() {
    }

    public boolean parseFunctionNoMarker(Context context, @NotNull PsiBuilder.Marker functionMarker) {
        if (functionMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionMarker", "com/intellij/lang/javascript/parsing/FunctionParser", "parseFunctionNoMarker"));
        }
        boolean functionKeywordWasOmitted = true;
        boolean parsedWithoutErrors = true;
        boolean isGeneratorContext = false;
        if (this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD && context != Context.PROPERTY) {
            this.builder.advanceLexer();
            functionKeywordWasOmitted = false;
            if (this.builder.getTokenType() == JSTokenTypes.MULT && this.isJSorTS()) {
                this.builder.advanceLexer();
                isGeneratorContext = true;
            }
        }
        this.putIsGenerator(isGeneratorContext);
        if (!this.parseFunctionName(functionKeywordWasOmitted, context)) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.function.name", (Object[])new Object[0]));
            parsedWithoutErrors = false;
        }
        JSParsingResult parameterListResult = this.parseParameterList(context == Context.EXPRESSION || context == Context.PROPERTY);
        parsedWithoutErrors &= !parameterListResult.hasErrors();
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
        String methodEmptiness = (String)this.builder.getUserData(methodsEmptinessKey);
        if (methodEmptiness == null) {
            if (JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
            }
            parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
        } else if (METHODS_EMPTINESS_ALWAYS.equals(methodEmptiness)) {
            if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            }
            if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                String key = this.builder.getUserData(StatementParser.withinInterfaceKey) == null ? "javascript.ambient.declaration.should.have.no.body" : "interface.function.declaration.should.have.no.body";
                parsedWithoutErrors = false;
                this.builder.error(JSBundle.message((String)key, (Object[])new Object[0]));
            }
        } else if (METHODS_EMPTINESS_POSSIBLY.equals(methodEmptiness)) {
            if (JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
                parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
            } else if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
            }
        }
        functionMarker.done(context == Context.SOURCE_ELEMENT ? this.getFunctionDeclarationElementType() : this.getFunctionExpressionElementType());
        functionMarker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        this.popIsGenerator();
        return parsedWithoutErrors;
    }

    public boolean parseFunctionName(boolean functionKeywordWasOmitted, Context context) {
        IElementType tokenType;
        IElementType firstToken = this.builder.getTokenType();
        if ((firstToken == JSTokenTypes.GET_KEYWORD || firstToken == JSTokenTypes.SET_KEYWORD) && context != Context.EXPRESSION) {
            IElementType lookAhead = this.builder.lookAhead(1);
            if (JSKeywordSets.PROPERTY_NAMES.contains(lookAhead)) {
                this.builder.advanceLexer();
            } else if (context == Context.PROPERTY && ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).isPropertyNameStart(lookAhead)) {
                this.builder.advanceLexer();
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parsePropertyName();
                return true;
            }
        }
        if (this.isIdentifierToken(tokenType = this.builder.getTokenType())) {
            this.parseFunctionIdentifier();
        } else if (functionKeywordWasOmitted && JSKeywordSets.PROPERTY_NAMES.contains(tokenType)) {
            this.myJavaScriptParser.buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
        } else {
            return context == Context.EXPRESSION;
        }
        return true;
    }

    public void parseFunctionIdentifier() {
        this.myJavaScriptParser.buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
    }

    public IElementType getFunctionDeclarationElementType() {
        return JSStubElementTypes.FUNCTION_DECLARATION;
    }

    public boolean parseAttributesList() {
        if (this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD) {
            PsiBuilder.Marker mark = this.builder.mark();
            this.builder.advanceLexer();
            mark.done((IElementType)JSElementTypes.ATTRIBUTE_LIST);
            return true;
        }
        return false;
    }

    public void parseES7Decorators() {
        if (this.hasSupportDecorators()) {
            PsiBuilder.Marker attribute = this.builder.mark();
            PsiBuilder.Marker call = this.builder.mark();
            boolean hasCall = false;
            if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseQualifiedTypeName()) {
                call.drop();
                attribute.drop();
                return;
            }
            if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseArgumentList();
                hasCall = true;
            }
            if (hasCall) {
                call.done(JSStubElementTypes.CALL_EXPRESSION);
            } else {
                call.drop();
            }
            attribute.done(JSStubElementTypes.ES7_DECORATOR);
        }
    }

    public boolean tryParseES7Decorators() {
        boolean hadAnnotation = false;
        if (this.hasSupportDecorators()) {
            while (this.builder.getTokenType() == JSTokenTypes.AT) {
                this.builder.advanceLexer();
                this.parseES7Decorators();
                hadAnnotation = true;
            }
        }
        return hadAnnotation;
    }

    public boolean hasSupportDecorators() {
        return false;
    }

    public void parseAttributeBody() {
        boolean haveLParen = FunctionParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        while (haveLParen) {
            boolean hasName = JSAttributeNameValuePairImpl.IDENTIFIER_TOKENS_SET.contains(this.builder.getTokenType());
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifer.or.value", (Object[])new Object[0]));
                break;
            }
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType == JSTokenTypes.RBRACKET || tokenType == JSTokenTypes.RPAR) break;
            PsiBuilder.Marker attributeNameValuePair = this.builder.mark();
            this.builder.advanceLexer();
            if (hasName && this.builder.getTokenType() != JSTokenTypes.COMMA && this.builder.getTokenType() != JSTokenTypes.RPAR) {
                FunctionParser.checkMatches(this.builder, JSTokenTypes.EQ, "javascript.parser.message.expected.equal");
                IElementType type = this.builder.getTokenType();
                if (type != JSTokenTypes.COMMA && type != JSTokenTypes.RBRACKET && type != JSTokenTypes.RPAR) {
                    if (type == JSTokenTypes.IDENTIFIER) {
                        PsiBuilder.Marker ident = this.builder.mark();
                        this.builder.advanceLexer();
                        IElementType nextTokenType = this.builder.getTokenType();
                        ident.rollbackTo();
                        if (!JSTokenTypes.STRING_LITERALS.contains(nextTokenType)) {
                            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseSimpleExpression();
                        } else {
                            this.builder.advanceLexer();
                        }
                    } else {
                        this.builder.advanceLexer();
                    }
                } else {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.value", (Object[])new Object[0]));
                }
            }
            if (attributeNameValuePair != null) {
                attributeNameValuePair.done(JSStubElementTypes.ATTRIBUTE_NAME_VALUE_PAIR);
            }
            if (this.builder.getTokenType() != JSTokenTypes.COMMA) break;
            this.builder.advanceLexer();
            if (!this.builder.eof()) continue;
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]));
            return;
        }
        if (haveLParen) {
            FunctionParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        } else {
            this.builder.advanceLexer();
        }
    }

    @NotNull
    public JSParsingResult parseParameterList(boolean funExpr) {
        if (!((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseTypeParameterList()) {
            JSParsingResult jSParsingResult = JSParsingResult.HAS_ERRORS_NO_IMPRINT;
            if (jSParsingResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/parsing/FunctionParser", "parseParameterList"));
            }
            return jSParsingResult;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LPAR) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lparen", (Object[])new Object[0]));
            if (!funExpr) {
                PsiBuilder.Marker parameterList = this.builder.mark();
                parameterList.done(JSStubElementTypes.PARAMETER_LIST);
            }
            JSParsingResult jSParsingResult = JSParsingResult.HAS_ERRORS_NO_IMPRINT;
            if (jSParsingResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/parsing/FunctionParser", "parseParameterList"));
            }
            return jSParsingResult;
        }
        PsiBuilder.Marker parameterList = this.builder.mark();
        this.builder.advanceLexer();
        boolean hasErrors = false;
        boolean looksLikeParameterList = false;
        boolean first = true;
        while (this.builder.getTokenType() != JSTokenTypes.RPAR) {
            if (first) {
                first = false;
            } else if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR && this.allowLastCommaInParameterList()) {
                    break;
                }
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.comma.or.rparen", (Object[])new Object[0]));
                hasErrors = true;
                break;
            }
            PsiBuilder.Marker parameter = this.builder.mark();
            if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
                looksLikeParameterList = true;
            }
            boolean allowPropertyNameAsIdentifier = this.parseParameterAttributeList();
            IElementType tokenType = this.builder.getTokenType();
            if (this.isIdentifierToken(tokenType) || allowPropertyNameAsIdentifier && JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType)) {
                this.builder.advanceLexer();
                this.parseParameterOptionalMark();
                looksLikeParameterList |= this.tryParseArrowFunctionParameterType();
                if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                    PsiBuilder.Marker m = null;
                    if (!this.hasParameterInitializers()) {
                        m = this.builder.mark();
                    }
                    this.builder.advanceLexer();
                    ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true, false);
                    if (m != null) {
                        m.error(JSBundle.message((String)"javascript.parser.message.expected.comma.or.rparen", (Object[])new Object[0]));
                        hasErrors = true;
                    }
                }
                parameter.done(this.getParameterType());
                continue;
            }
            if (this.willParseDestructuringAssignment(true)) {
                this.parseDestructuringParameter(parameter);
                continue;
            }
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.formal.parameter.name", (Object[])new Object[0]));
            hasErrors = true;
            ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
            parameter.drop();
        }
        if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
            this.builder.advanceLexer();
        }
        parameterList.done(JSStubElementTypes.PARAMETER_LIST);
        JSParsingResult jSParsingResult = JSParsingResult.of(hasErrors, looksLikeParameterList);
        if (jSParsingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/parsing/FunctionParser", "parseParameterList"));
        }
        return jSParsingResult;
    }

    protected boolean allowLastCommaInParameterList() {
        return false;
    }

    protected boolean tryParseArrowFunctionParameterType() {
        boolean looksLikeParameterList = this.builder.getTokenType() == JSTokenTypes.COLON;
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
        return looksLikeParameterList;
    }

    protected void parseDestructuringParameter(PsiBuilder.Marker parameter) {
        parameter.drop();
        PsiBuilder.Marker parameterMarker = this.builder.mark();
        ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseDestructuringElement((IElementType)this.getParameterType(), false, false);
        this.parseParameterOptionalMark();
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true, false);
        }
        parameterMarker.done(JSStubElementTypes.DESTRUCTURING_PARAMETER);
    }

    protected JSStubElementType<JSParameterStub, JSParameter> getParameterType() {
        return JSStubElementTypes.FORMAL_PARAMETER;
    }

    protected void parseParameterOptionalMark() {
    }

    protected boolean willParseDestructuringAssignment(boolean isParameter) {
        return (this.builder.getTokenType() == JSTokenTypes.LBRACKET || this.builder.getTokenType() == JSTokenTypes.LBRACE) && !this.isECMAL4();
    }

    protected boolean hasParameterInitializers() {
        return false;
    }

    protected boolean parseParameterAttributeList() {
        if (this.hasSupportDecorators() && this.builder.getTokenType() == JSTokenTypes.AT) {
            PsiBuilder.Marker mark = this.builder.mark();
            this.tryParseES7Decorators();
            mark.done(JSStubElementTypes.ATTRIBUTE_LIST);
        }
        return false;
    }

    public boolean parseArrowFunction() {
        return this.parseArrowFunctionNoMarker(this.builder.mark());
    }

    protected boolean parseArrowFunctionNoMarker(PsiBuilder.Marker arrowFunction) {
        IElementType firstToken = this.builder.getTokenType();
        boolean isDefinitelyArrowFunction = false;
        if (this.isIdentifierToken(firstToken)) {
            PsiBuilder.Marker parameterList = this.builder.mark();
            PsiBuilder.Marker parameter = this.builder.mark();
            this.builder.advanceLexer();
            parameter.done(JSStubElementTypes.FORMAL_PARAMETER);
            parameterList.done(JSStubElementTypes.PARAMETER_LIST);
        } else {
            JSParsingResult result = this.parseParameterList(true);
            if (result.hasImprint()) {
                isDefinitelyArrowFunction = true;
            } else if (result.hasErrors()) {
                arrowFunction.rollbackTo();
                return false;
            }
            ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
        }
        IElementType arrow = this.builder.getTokenType();
        if (JSTokenTypes.ARROWS.contains(arrow)) {
            this.builder.advanceLexer();
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseBlockOrFunctionBody(StatementParser.BlockType.ARROW_FUNCTION_BODY);
            isDefinitelyArrowFunction = true;
        } else if (isDefinitelyArrowFunction) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.eqgt", (Object[])new Object[0]));
        }
        if (isDefinitelyArrowFunction) {
            arrowFunction.done(this.getFunctionExpressionElementType());
        } else {
            arrowFunction.rollbackTo();
        }
        return isDefinitelyArrowFunction;
    }

    protected IElementType getFunctionExpressionElementType() {
        return JSStubElementTypes.FUNCTION_EXPRESSION;
    }

    public boolean isAsyncContext() {
        return Boolean.TRUE.equals(this.builder.getUserData(ASYNC_METHOD_KEY));
    }

    public void putIsGenerator(boolean isGenerator) {
        if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).hasGeneratorsSupport()) {
            return;
        }
        ArrayDeque<Boolean> data = (ArrayDeque<Boolean>)this.builder.getUserData(HAD_GENERATOR_DEF_KEY);
        if (data == null) {
            if (!isGenerator) {
                return;
            }
            data = new ArrayDeque<Boolean>();
            this.builder.putUserData(HAD_GENERATOR_DEF_KEY, data);
        }
        data.addFirst(isGenerator);
    }

    public boolean isGeneratorContext() {
        if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).hasGeneratorsSupport()) {
            return false;
        }
        Deque data = (Deque)this.builder.getUserData(HAD_GENERATOR_DEF_KEY);
        if (data != null && !data.isEmpty()) {
            return (Boolean)data.getFirst();
        }
        return false;
    }

    public void popIsGenerator() {
        if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).hasGeneratorsSupport()) {
            return;
        }
        Deque data = (Deque)this.builder.getUserData(HAD_GENERATOR_DEF_KEY);
        if (data != null && !data.isEmpty()) {
            data.removeFirst();
        }
    }

    protected boolean parseParameterListAndBody(PsiBuilder.Marker marker, IElementType elementType) {
        JSParsingResult parameterListResult = ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseParameterList(false);
        boolean lexerAdvanced = !parameterListResult.hasErrors();
        lexerAdvanced |= ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return lexerAdvanced |= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
    }

    public static enum Context {
        EXPRESSION,
        SOURCE_ELEMENT,
        PROPERTY;

    }
}

