/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.JSXmlParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.Stack;

public class JSXmlTokensParser<P extends JavaScriptParser>
extends JavaScriptParserBase<P>
implements JSXmlParser {
    protected JSXmlTokensParser(P parser) {
        super(parser);
    }

    @Override
    public boolean isXmlTagStart(IElementType currentToken) {
        return currentToken == JSTokenTypes.XML_START_TAG_START || currentToken == JSTokenTypes.XML_START_TAG_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseTag(Stack<String> tagNames) {
        IElementType tokenType = this.builder.getTokenType();
        assert (JSTokenTypes.XML_START_TAG_START == tokenType || JSTokenTypes.XML_START_TAG_LIST == tokenType);
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        String name = this.builder.getTokenText();
        boolean seenEnd = JSTokenTypes.XML_START_TAG_LIST == tokenType;
        tagNames.push((Object)name);
        try {
            IElementType currentTokenType = this.builder.getTokenType();
            while (currentTokenType != null) {
                if (!JSTokenTypes.XML_TOKENS.contains(currentTokenType)) {
                    if (!seenEnd) {
                        this.builder.error(XmlErrorMessages.message((String)"tag.start.is.not.closed", (Object[])new Object[0]));
                        return;
                    }
                    PsiBuilder.Marker errorMarker = this.builder.mark();
                    this.builder.advanceLexer();
                    errorMarker.error(JSBundle.message((String)"javascript.parser.message.expected.xml.element", (Object[])new Object[0]));
                } else if (currentTokenType == JSTokenTypes.XML_START_TAG_START) {
                    this.parseTag(tagNames);
                } else {
                    if (currentTokenType == JSTokenTypes.XML_EMPTY_TAG_END || currentTokenType == JSTokenTypes.XML_END_TAG_LIST) {
                        this.builder.advanceLexer();
                        return;
                    }
                    if (currentTokenType == JSTokenTypes.XML_END_TAG_START) {
                        if (!seenEnd) {
                            this.builder.error(XmlErrorMessages.message((String)"tag.start.is.not.closed", (Object[])new Object[0]));
                            return;
                        }
                        PsiBuilder.Marker endTagStart = this.builder.mark();
                        this.builder.advanceLexer();
                        IElementType type = this.builder.getTokenType();
                        if (type == XmlTokenType.XML_TAG_NAME || type == JSTokenTypes.XML_JS_SCRIPT) {
                            String endName = this.builder.getTokenText();
                            if (!(StringUtil.equals((CharSequence)name, (CharSequence)endName) || endName != null && endName.endsWith("IntellijIdeaRulezzz"))) {
                                if (tagNames.contains((Object)endName)) {
                                    endTagStart.rollbackTo();
                                    this.builder.error(XmlErrorMessages.message((String)"named.element.is.not.closed", (Object[])new Object[]{name}));
                                    return;
                                }
                                this.builder.error(XmlErrorMessages.message((String)"xml.parsing.closing.tag.matches.nothing", (Object[])new Object[0]));
                            }
                            this.builder.advanceLexer();
                        } else if (JSTokenTypes.XML_START_TAG_LIST != tokenType) {
                            this.builder.error(XmlErrorMessages.message((String)"xml.parsing.closing.tag.name.missing", (Object[])new Object[0]));
                        }
                        if (this.builder.getTokenType() != XmlTokenType.XML_TAG_END) {
                            this.builder.error(XmlErrorMessages.message((String)"xml.parsing.closing.tag.is.not.done", (Object[])new Object[0]));
                        } else {
                            this.builder.advanceLexer();
                        }
                        endTagStart.drop();
                        return;
                    }
                    if (currentTokenType == JSTokenTypes.XML_NAME) {
                        this.parseAttribute();
                    } else if (currentTokenType == JSTokenTypes.XML_TAG_CONTENT) {
                        this.myJavaScriptParser.buildTokenElement(JSElementTypes.XML_TEXT);
                    } else {
                        if (currentTokenType == JSTokenTypes.XML_TAG_END) {
                            seenEnd = true;
                        }
                        this.builder.advanceLexer();
                        if (currentTokenType != JSTokenTypes.XML_NAME && currentTokenType != JSTokenTypes.XML_JS_SCRIPT && this.builder.getTokenType() == JSTokenTypes.XML_ATTR_EQUAL) {
                            this.builder.error(JSBundle.message((String)"javascript.parser.message.missing.attribute.name", (Object[])new Object[0]));
                        }
                    }
                }
                currentTokenType = this.builder.getTokenType();
            }
        }
        finally {
            tagNames.pop();
            marker.done(JSElementTypes.XML_LITERAL_EXPRESSION);
        }
    }

    private void parseAttribute() {
        assert (this.builder.getTokenType() == XmlTokenType.XML_NAME);
        PsiBuilder.Marker att = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == XmlTokenType.XML_EQ) {
            this.builder.advanceLexer();
            this.parseAttributeValue();
            att.done(XmlElementType.XML_ATTRIBUTE);
        } else {
            att.done(XmlElementType.XML_ATTRIBUTE);
        }
    }

    private void parseAttributeValue() {
        PsiBuilder.Marker attValue = this.builder.mark();
        if (this.builder.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            IElementType tt;
            while ((tt = this.builder.getTokenType()) != null && tt != XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && tt != XmlTokenType.XML_END_TAG_START && tt != XmlTokenType.XML_EMPTY_ELEMENT_END && tt != XmlTokenType.XML_START_TAG_START) {
                this.builder.advanceLexer();
            }
            if (this.builder.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(XmlErrorMessages.message((String)"xml.parsing.unclosed.attribute.value", (Object[])new Object[0]));
            }
        } else if (this.builder.getTokenType() != XmlTokenType.XML_TAG_END && this.builder.getTokenType() != XmlTokenType.XML_EMPTY_ELEMENT_END) {
            this.builder.advanceLexer();
        }
        attValue.done(XmlElementType.XML_ATTRIBUTE_VALUE);
    }
}

