/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSQualifiedNameImpl
implements JSQualifiedName {
    private static final ConcurrentMap<String, JSQualifiedNameImpl> NAMESPACES = ContainerUtil.createConcurrentWeakValueMap();
    public static final JSQualifiedNameImpl EMPTY = JSQualifiedNameImpl.create("", null);
    @NotNull
    private final String myName;
    @Nullable
    private final JSQualifiedNameImpl myParent;

    private JSQualifiedNameImpl(@NotNull String name, @Nullable JSQualifiedName parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "<init>"));
        }
        this.myName = name;
        this.myParent = (JSQualifiedNameImpl)parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static JSQualifiedNameImpl create(@NotNull String name, @Nullable JSQualifiedName parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "create"));
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        if (parent != null) {
            ((JSQualifiedNameImpl)parent).getQualifiedName(builder);
            builder.append(".");
        }
        builder.append(name);
        String fqn = builder.toString();
        JSQualifiedNameImpl oldValue = (JSQualifiedNameImpl)NAMESPACES.get(fqn);
        if (oldValue != null) {
            JSQualifiedNameImpl jSQualifiedNameImpl = oldValue;
            JSQualifiedNameImpl jSQualifiedNameImpl2 = jSQualifiedNameImpl;
            if (jSQualifiedNameImpl2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "create"));
            }
            return jSQualifiedNameImpl2;
        }
        JSQualifiedNameImpl newName = new JSQualifiedNameImpl(name, parent);
        oldValue = NAMESPACES.putIfAbsent(fqn, newName);
        JSQualifiedNameImpl jSQualifiedNameImpl = newName = oldValue != null ? oldValue : newName;
        JSQualifiedNameImpl jSQualifiedNameImpl3 = jSQualifiedNameImpl;
        if (jSQualifiedNameImpl3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "create"));
        }
        return jSQualifiedNameImpl3;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Nullable
    public static JSQualifiedNameImpl fromComponents(@NotNull List<String> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "fromComponents"));
        }
        JSQualifiedNameImpl result = null;
        for (String component : components) {
            result = JSQualifiedNameImpl.create(component, result);
        }
        return result;
    }

    @NotNull
    public static JSQualifiedNameImpl fromQualifiedName(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "fromQualifiedName"));
        }
        JSQualifiedNameImpl cached = (JSQualifiedNameImpl)NAMESPACES.get(qualifiedName);
        if (cached != null) {
            JSQualifiedNameImpl jSQualifiedNameImpl = cached;
            if (jSQualifiedNameImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "fromQualifiedName"));
            }
            return jSQualifiedNameImpl;
        }
        List split = StringUtil.split((String)qualifiedName, (String)".");
        JSQualifiedNameImpl jSQualifiedNameImpl = split.isEmpty() ? EMPTY : JSQualifiedNameImpl.fromComponents(split);
        if (jSQualifiedNameImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "fromQualifiedName"));
        }
        return jSQualifiedNameImpl;
    }

    @Contract(value="null, null -> null; !null, _ -> !null; _, !null -> !null")
    @Nullable
    public static JSQualifiedName fromQualifiedNames(@Nullable JSQualifiedName parent, @Nullable JSQualifiedName child) {
        return child == null ? parent : ((JSQualifiedNameImpl)child).withQualifier(parent);
    }

    @NotNull
    public static JSQualifiedNameImpl fromNamepath(@NotNull String namepath) {
        JSQualifiedNameImpl cached;
        if (namepath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namepath", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "fromNamepath"));
        }
        if (StringUtil.indexOfAny((String)namepath, (String)"#~") == -1 && (cached = (JSQualifiedNameImpl)NAMESPACES.get(namepath)) != null) {
            JSQualifiedNameImpl jSQualifiedNameImpl = cached;
            if (jSQualifiedNameImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "fromNamepath"));
            }
            return jSQualifiedNameImpl;
        }
        int pos = 0;
        JSQualifiedNameImpl result = null;
        while (pos < namepath.length()) {
            int separatorPos = StringUtil.indexOfAny((String)namepath, (String)".#~", (int)pos, (int)namepath.length());
            if (separatorPos == -1) {
                separatorPos = namepath.length();
            }
            if (separatorPos > pos) {
                result = JSQualifiedNameImpl.create(namepath.substring(pos, separatorPos), result);
            }
            pos = separatorPos + 1;
        }
        JSQualifiedNameImpl jSQualifiedNameImpl = result != null ? result : EMPTY;
        if (jSQualifiedNameImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "fromNamepath"));
        }
        return jSQualifiedNameImpl;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        StringBuilder name = StringBuilderSpinAllocator.alloc();
        this.getQualifiedName(name);
        String string = name.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "getQualifiedName"));
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)name);
        }
    }

    private void getQualifiedName(StringBuilder name) {
        if (this.myParent != null) {
            this.myParent.getQualifiedName(name);
            name.append(".");
        }
        name.append(this.myName);
    }

    @Nullable
    public JSQualifiedName getParent() {
        return this.myParent;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JSQualifiedNameImpl)) {
            return false;
        }
        if (this.myParent == null != (((JSQualifiedNameImpl)obj).myParent == null)) {
            return false;
        }
        return this.myName.equals(((JSQualifiedNameImpl)obj).myName) && (this.myParent == null ? ((JSQualifiedNameImpl)obj).myParent == null : this.myParent.equals(((JSQualifiedNameImpl)obj).myParent));
    }

    public int hashCode() {
        int result = this.myParent == null ? 0 : this.myParent.hashCode();
        result = result * 31 + this.myName.hashCode();
        return result;
    }

    @Nullable
    public static JSQualifiedNameImpl fromQualifiedNamedElement(@NotNull JSElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "fromQualifiedNamedElement"));
        }
        String name = element.getName();
        if (name == null) {
            return null;
        }
        return JSQualifiedNameImpl.create(name, element.getNamespace());
    }

    @Nullable
    public static JSQualifiedName buildProvidedNamespace(@NotNull JSElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "buildProvidedNamespace"));
        }
        String name = element.getName();
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        return "prototype".equals(name) ? element.getNamespace() : JSQualifiedNameImpl.create(name, element.getNamespace());
    }

    public static void serialize(JSQualifiedName qualifiedName, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(qualifiedName != null ? qualifiedName.getQualifiedName() : null);
    }

    @Nullable
    public static JSQualifiedNameImpl deserialize(StubInputStream dataStream) throws IOException {
        StringRef ref = dataStream.readName();
        return ref != null ? JSQualifiedNameImpl.fromQualifiedName(ref.getString()) : null;
    }

    @NotNull
    public JSQualifiedName withQualifier(@Nullable JSQualifiedName qualifier) {
        SmartList components = new SmartList();
        for (JSQualifiedNameImpl parent = this; parent != null; parent = parent.getParent()) {
            components.add(parent.getName());
        }
        JSQualifiedName result = qualifier;
        for (int i = components.size() - 1; i >= 0; --i) {
            result = JSQualifiedNameImpl.create((String)components.get(i), result);
        }
        JSQualifiedName jSQualifiedName = result;
        if (jSQualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "withQualifier"));
        }
        return jSQualifiedName;
    }

    @Nullable
    public JSQualifiedName withoutInnermostComponent(@Nullable String innermostNameToRemove) {
        SmartList components = new SmartList();
        JSQualifiedNameImpl element = this;
        for (JSQualifiedName parent = element.getParent(); parent != null; parent = parent.getParent()) {
            components.add(element.getName());
            element = parent;
        }
        if (innermostNameToRemove != null && !innermostNameToRemove.equals(element.getName())) {
            return this;
        }
        JSQualifiedNameImpl result = null;
        for (int i = components.size() - 1; i >= 0; --i) {
            result = JSQualifiedNameImpl.create((String)components.get(i), result);
        }
        return result;
    }

    public String[] toComponents() {
        return JSQualifiedNameImpl.toComponents(this);
    }

    @NotNull
    public static String[] toComponents(@NotNull JSQualifiedName qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "toComponents"));
        }
        ArrayList<String> components = new ArrayList<String>();
        for (JSQualifiedName current = qualifiedName; current != null; current = current.getParent()) {
            components.add(0, current.getName());
        }
        String[] stringArray = ArrayUtil.toStringArray(components);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "toComponents"));
        }
        return stringArray;
    }

    public static String getTopmostParent(@NotNull JSQualifiedName qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/javascript/psi/JSQualifiedNameImpl", "getTopmostParent"));
        }
        JSQualifiedName parent = qualifiedName;
        while ((parent = (qualifiedName = parent).getParent()) != null) {
        }
        return qualifiedName.getName();
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static String toString(@Nullable JSQualifiedName name) {
        return name != null ? name.getQualifiedName() : null;
    }
}

