/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.impl.ES6ReferenceListImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptClassBase;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptClassStub;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeScriptClassImpl
extends TypeScriptClassBase<TypeScriptClassStub>
implements TypeScriptClass {
    private static final TokenSet MEMBERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, TokenSet.create((IElementType[])new IElementType[]{TypeScriptElementTypes.INDEX_SIGNATURE})});

    public TypeScriptClassImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptClassImpl(TypeScriptClassStub stub) {
        super(stub, JSStubElementTypes.TYPESCRIPT_CLASS);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptClass((TypeScriptClass)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isDeprecated() {
        TypeScriptClassStub stub = (TypeScriptClassStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecated();
        }
        return JSDocumentationUtils.calculateDeprecated((PsiElement)this);
    }

    @Override
    @NotNull
    public Iterable<? extends JSElement> getMembers() {
        JSElement[] children = (JSElement[])this.getStubOrPsiChildren(MEMBERS, JSElement.ARRAY_FACTORY);
        ArrayList<Object> members = new ArrayList<Object>(children.length);
        for (JSElement child : children) {
            if (child instanceof JSFunction && ((JSFunction)child).isConstructor()) {
                for (JSParameter parameter : ((JSFunction)child).getParameters()) {
                    JSAttributeList list = parameter.getAttributeList();
                    if (list == null || list.findAccessTypeElement() == null) continue;
                    members.add(parameter);
                }
            }
            if (child instanceof JSVarStatement) {
                members.addAll(Arrays.asList(((JSVarStatement)child).getVariables()));
                continue;
            }
            members.add(child);
        }
        ArrayList<Object> arrayList = members;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassImpl", "getMembers"));
        }
        return arrayList;
    }

    public ES6ReferenceList getExtendsList() {
        return (ES6ReferenceList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ES6_EXTENDS_LIST);
    }

    @NotNull
    public Collection<JSFunction> getIndirectSuperConstructors() {
        List classes;
        ES6ReferenceList list = this.getExtendsList();
        if (list == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassImpl", "getIndirectSuperConstructors"));
            }
            return list2;
        }
        Object[] refs = list.getReferenceTexts();
        if (refs.length > 0 && !(classes = ContainerUtil.filter(ES6ReferenceListImpl.resolveTextReferenceClasses(TypeScriptImportHandler.getInstance(), (String)ArrayUtil.getFirstElement((Object[])refs), (PsiElement)list), (Condition)new Condition<JSClass>(){

            public boolean value(JSClass aClass) {
                return !aClass.isInterface();
            }
        })).isEmpty()) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassImpl", "getIndirectSuperConstructors"));
            }
            return list3;
        }
        JSExpression expression = (JSExpression)ArrayUtil.getFirstElement((Object[])list.getExpressions());
        if (expression != null) {
            Pair<ES6ReferenceList.Errors, Collection<JSType>> type = ES6ReferenceListImpl.resolveExpression((PsiElement)expression);
            if (type.first == ES6ReferenceList.Errors.NO_ERROR) {
                List result = ContainerUtil.newSmartList();
                for (JSType jsType : (Collection)type.second) {
                    PsiElement sourceElement = jsType.getSource().getSourceElement();
                    if (!(sourceElement instanceof JSFunction)) continue;
                    result.add((JSFunction)sourceElement);
                }
                List list4 = result;
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassImpl", "getIndirectSuperConstructors"));
                }
                return list4;
            }
        }
        List list5 = ContainerUtil.emptyList();
        if (list5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassImpl", "getIndirectSuperConstructors"));
        }
        return list5;
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression((JSExpression)this, other);
    }
}

