/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptEnumStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptEnumImpl
extends JSStubElementImpl<TypeScriptEnumStub>
implements TypeScriptEnum {
    public TypeScriptEnumImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptEnumImpl(TypeScriptEnumStub stub) {
        super(stub, (IStubElementType)JSStubElementTypes.TYPESCRIPT_ENUM);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptEnum((TypeScriptEnum)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        return this.getNode().findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    public String getName() {
        TypeScriptEnumStub stub = (TypeScriptEnumStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            return ((JSReferenceExpression)node.getPsi()).getReferencedName();
        }
        return null;
    }

    public int getTextOffset() {
        ASTNode node = this.findNameIdentifier();
        return node == null ? super.getTextOffset() : node.getStartOffset();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumImpl", "setName"));
        }
        ASTNode nameIdentifier = this.findNameIdentifier();
        if (nameIdentifier != null) {
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, JSChangeUtil.createExpressionFromText(this.getProject(), name));
        }
        return this;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        JSClass[] superClasses;
        boolean toProcessInHierarchy;
        boolean toProcessMembers;
        boolean typeContext;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumImpl", "processDeclarations"));
        }
        ResolveProcessor resolveProcessor = processor instanceof ResolveProcessor ? (ResolveProcessor)processor : null;
        boolean bl = typeContext = resolveProcessor != null && resolveProcessor.isTypeContext();
        if ((typeContext || lastParent == null) && !processor.execute((PsiElement)this, state)) {
            return false;
        }
        if (lastParent == null) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        boolean bl2 = toProcessMembers = resolveProcessor == null || !resolveProcessor.isToSkipClassDeclarationOnce() && resolveProcessor.isToProcessMembers();
        if (toProcessMembers) {
            if (!this.processMembers(processor, state)) {
                return false;
            }
        } else {
            resolveProcessor.setToSkipClassDeclarationsOnce(false);
        }
        boolean bl3 = toProcessInHierarchy = processor instanceof ResolveProcessor && ((ResolveProcessor)processor).isToProcessHierarchy();
        if (!toProcessInHierarchy || ((ResolveProcessor)processor).checkVisited((JSClass)this)) {
            return true;
        }
        for (JSClass clazz : superClasses = this.getSuperClasses()) {
            if (clazz.processDeclarations(processor, state, lastParent, place)) continue;
            return false;
        }
        return true;
    }

    private boolean processMembers(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumImpl", "processMembers"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumImpl", "processMembers"));
        }
        for (JSVariable var : this.getFields()) {
            if (processor.execute((PsiElement)var, state)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public JSReferenceList getExtendsList() {
        return null;
    }

    @Nullable
    public JSReferenceList getImplementsList() {
        return null;
    }

    public boolean isInterface() {
        return false;
    }

    @NotNull
    public JSClass[] getSuperClasses() {
        if (JSClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumImpl", "getSuperClasses"));
        }
        return JSClass.EMPTY_ARRAY;
    }

    public JSFunction[] getFunctions() {
        return JSFunction.EMPTY_ARRAY;
    }

    public JSVariable[] getFields() {
        PsiElement varStatement = this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.VAR_STATEMENT);
        if (varStatement != null) {
            return ((JSVarStatement)varStatement).getVariables();
        }
        return JSVariable.EMPTY_ARRAY;
    }

    @NotNull
    public Iterable<? extends JSElement> getMembers() {
        List<JSVariable> list = Arrays.asList(this.getFields());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumImpl", "getMembers"));
        }
        return list;
    }

    public JSFunction findFunctionByName(String name) {
        return null;
    }

    public JSFunction findFunctionByNameAndKind(String name, JSFunction.FunctionKind kind) {
        return null;
    }

    public JSVariable findFieldByName(String name) {
        return null;
    }

    @NotNull
    public JSClass[] getSupers() {
        JSClass[] jSClassArray = this.getSuperClasses();
        if (jSClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumImpl", "getSupers"));
        }
        return jSClassArray;
    }

    @NotNull
    public JSClass[] getImplementedInterfaces() {
        if (JSClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumImpl", "getImplementedInterfaces"));
        }
        return JSClass.EMPTY_ARRAY;
    }

    public boolean isDeprecated() {
        return false;
    }

    @Nullable
    public JSFunction getConstructor() {
        return null;
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName((JSQualifiedNamedElement)this);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        TypeScriptEnumStub stub = (TypeScriptEnumStub)this.getStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        return JSPsiImplUtils.getNamespace((JSNamedElement)this);
    }

    public boolean isNamespaceExplicitlyDeclared() {
        JSQualifiedStub stub = (JSQualifiedStub)this.getStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return TypeScriptPsiUtil.isTopLevelContainerMember((PsiElement)this);
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.STATIC;
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumImpl", "getJSContext"));
        }
        return jSContext;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return PlatformIcons.ENUM_ICON;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList list = this.getAttributeList();
        JSAttributeList.AccessType accessType = list != null ? list.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptEnumImpl", "getAccessType"));
        }
        return accessType;
    }

    public boolean isConst() {
        JSAttributeList list = this.getAttributeList();
        return list != null && list.hasModifier(JSAttributeList.ModifierType.CONST);
    }
}

