/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptImplicitModuleStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImplicitModuleImpl
extends JSStubElementImpl<TypeScriptImplicitModuleStub>
implements TypeScriptImplicitModule {
    public TypeScriptImplicitModuleImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptImplicitModuleImpl(TypeScriptImplicitModuleStub stub) {
        super(stub, (IStubElementType)TypeScriptElementTypes.IMPLICIT_MODULE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImplicitModuleImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptImplicitModule((TypeScriptImplicitModule)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean isDeprecated() {
        TypeScriptModule<?> realModule = this.getRealModule();
        return realModule != null && realModule.isDeprecated();
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isInstantiated() {
        return false;
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        return null;
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName((JSQualifiedNamedElement)this);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        TypeScriptImplicitModuleStub stub = (TypeScriptImplicitModuleStub)this.getStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        return JSPsiImplUtils.getNamespace((JSNamedElement)this);
    }

    public String getName() {
        TypeScriptImplicitModuleStub stub = (TypeScriptImplicitModuleStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement element = this.getNameIdentifier();
        return element != null ? element.getText() : null;
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getNode() : null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        TypeScriptModule<?> realModule = this.getRealModule();
        if (realModule == null) {
            return null;
        }
        PsiElement realModuleNameIdentifier = realModule.getNameIdentifier();
        if (realModuleNameIdentifier == null) {
            return null;
        }
        realModuleNameIdentifier = realModuleNameIdentifier.getParent();
        int nestingLevel = this.calculateNestingLevel();
        if (nestingLevel <= 0) {
            return null;
        }
        while (realModuleNameIdentifier instanceof JSReferenceExpression && nestingLevel > 0) {
            realModuleNameIdentifier = ((JSReferenceExpression)realModuleNameIdentifier).getQualifier();
            --nestingLevel;
        }
        if (nestingLevel > 0 || !(realModuleNameIdentifier instanceof JSReferenceExpression)) {
            return null;
        }
        return ((JSReferenceExpression)realModuleNameIdentifier).getReferenceNameElement();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImplicitModuleImpl", "setName"));
        }
        ASTNode nameIdentifier = this.findNameIdentifier();
        if (nameIdentifier != null) {
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, JSChangeUtil.createExpressionFromText(this.getProject(), name));
        }
        return this;
    }

    public TypeScriptModule<?> getRealModule() {
        for (TypeScriptImplicitModuleImpl implicitModule = this; implicitModule != null; implicitModule = (TypeScriptImplicitModuleImpl)implicitModule.getStubOrPsiChild((IStubElementType)TypeScriptElementTypes.IMPLICIT_MODULE)) {
            TypeScriptModule module = (TypeScriptModule)implicitModule.getStubOrPsiChild((IStubElementType)JSStubElementTypes.TYPESCRIPT_MODULE);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    private int calculateNestingLevel() {
        int result = 0;
        for (TypeScriptImplicitModuleImpl implicitModule = this; implicitModule != null; implicitModule = (TypeScriptImplicitModuleImpl)implicitModule.getStubOrPsiChild((IStubElementType)TypeScriptElementTypes.IMPLICIT_MODULE)) {
            TypeScriptModule module = (TypeScriptModule)implicitModule.getStubOrPsiChild((IStubElementType)JSStubElementTypes.TYPESCRIPT_MODULE);
            ++result;
            if (module == null) continue;
            return result;
        }
        return result;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImplicitModuleImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImplicitModuleImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImplicitModuleImpl", "processDeclarations"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent != this && !processor.execute((PsiElement)this, state)) {
            return false;
        }
        if (lastParent == null) {
            return true;
        }
        boolean result = JSResolveUtil.processDeclarationsInScope(this, processor, ResolveState.initial(), lastParent, place);
        if (processor instanceof ResolveProcessor && !((ResolveProcessor)processor).isLocalResolve()) {
            String name = this.getQualifiedName();
            if (StringUtil.isEmpty((String)name)) {
                return result;
            }
            Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findElementsByQNameAndPlace(name, (PsiElement)this);
            for (JSQualifiedNamedElement element : elements) {
                if (element == this || !(element instanceof TypeScriptModule)) continue;
                result &= JSResolveUtil.processDeclarationsInScope((JSElement)element, processor, ResolveState.initial(), lastParent, place);
            }
        }
        return result;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return null;
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImplicitModuleImpl", "getAccessType"));
        }
        return accessType;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.STATIC;
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImplicitModuleImpl", "getJSContext"));
        }
        return jSContext;
    }

    @NotNull
    public Map<String, JSReferenceExpression> getExtensionSymbols() {
        Map<String, JSReferenceExpression> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImplicitModuleImpl", "getExtensionSymbols"));
        }
        return map;
    }
}

