/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubbedStatementImpl;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.TypeScriptImportStatementStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportStatementImpl
extends JSStubbedStatementImpl<TypeScriptImportStatementStub>
implements TypeScriptImportStatement {
    public static final Key<String> RESOLVE_REF_ANCHOR = Key.create((String)"Import.Resolve.Ref.Key");
    private static final ThreadLocal<Set<String>> processingImportElementsHolder = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return ContainerUtil.newHashSet();
        }
    };

    public TypeScriptImportStatementImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptImportStatementImpl(TypeScriptImportStatementStub stub) {
        super(stub, (IStubElementType)TypeScriptElementTypes.IMPORT_STATEMENT);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptImportStatement((TypeScriptImportStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "processDeclarations"));
        }
        return processor.execute((PsiElement)this, state);
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        return this.getNode().findChildByType(JSKeywordSets.TS_IDENTIFIERS_TOKENS_SET);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findChildByType(JSKeywordSets.TS_IDENTIFIERS_TOKENS_SET);
    }

    public String getName() {
        TypeScriptImportStatementStub stub = (TypeScriptImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            return node.getText();
        }
        return null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "setName"));
        }
        ASTNode nameIdentifier = this.findNameIdentifier();
        if (nameIdentifier != null) {
            ASTNode identifier = JSChangeUtil.createNameIdentifier(this.getProject(), name, JavaScriptSupportLoader.TYPESCRIPT);
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, identifier);
        }
        return this;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        Object object = nameIdentifier != null ? nameIdentifier : this;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "getNavigationElement"));
        }
        return object;
    }

    public int getTextOffset() {
        ASTNode name = this.findNameIdentifier();
        return name != null ? name.getStartOffset() : super.getTextOffset();
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName((JSQualifiedNamedElement)this);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        TypeScriptImportStatementStub stub = (TypeScriptImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        return JSPsiImplUtils.getNamespace((JSNamedElement)this);
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.STATIC;
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "getJSContext"));
        }
        return jSContext;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList list = this.getAttributeList();
        JSAttributeList.AccessType accessType = list != null ? list.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "getAccessType"));
        }
        return accessType;
    }

    public boolean isDeprecated() {
        return false;
    }

    @Nullable
    public TypeScriptEntityName getInternalModuleReference() {
        return (TypeScriptEntityName)this.findChildByType(TypeScriptElementTypes.ENTITY_NAME);
    }

    @Nullable
    public TypeScriptExternalModuleReference getExternalModuleReference() {
        return (TypeScriptExternalModuleReference)this.findChildByType(TypeScriptElementTypes.EXTERNAL_MODULE_REFERENCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<? extends PsiElement> findReferencedElements() {
        String key;
        String qualifiedName = this.getQualifiedName();
        if (qualifiedName == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "findReferencedElements"));
            }
            return list;
        }
        Set<String> processingElements = processingImportElementsHolder.get();
        if (processingElements.contains(key = this.getProcessingElementKey())) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "findReferencedElements"));
            }
            return list;
        }
        processingElements.add(key);
        JSTypeResolveResult resolveResult = TypeScriptImportHandler.getInstance().resolveName(qualifiedName, (PsiElement)this);
        Collection<? extends PsiElement> collection = resolveResult.getElements();
        Collection<? extends PsiElement> collection2 = collection;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptImportStatementImpl", "findReferencedElements"));
        }
        return collection2;
        finally {
            processingElements.remove(key);
        }
    }

    private String getProcessingElementKey() {
        String key = (String)this.getUserData(RESOLVE_REF_ANCHOR);
        if (key == null) {
            this.putUserData(RESOLVE_REF_ANCHOR, String.valueOf(((Object)((Object)this)).hashCode()));
        }
        key = (String)this.getUserData(RESOLVE_REF_ANCHOR);
        return key;
    }
}

