/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptParameterImpl
extends JSParameterImpl {
    public TypeScriptParameterImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptParameterImpl(JSParameterStub stub) {
        super(stub, TypeScriptElementTypes.TYPESCRIPT_PARAMETER);
    }

    @Override
    @Nullable
    protected JSType doGetType() {
        boolean isRest;
        ASTNode typeExpr = JSPsiImplUtils.getTypeExpressionFromDeclaration((JSNamedElement)this);
        JSType type = null;
        boolean bl = isRest = this.getNode().findChildByType(JSTokenTypes.DOT_DOT_DOT) != null;
        if (typeExpr != null) {
            PsiElement typeExprPsi = typeExpr.getPsi();
            Object object = type = typeExprPsi instanceof TypeScriptType ? TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)((TypeScriptType)typeExprPsi)) : JSAnyType.get(typeExprPsi, true);
            if (isRest) {
                JSGenericTypeImpl genericType;
                if (type instanceof JSArrayTypeImpl) {
                    type = ((JSArrayTypeImpl)type).getType();
                } else if (type instanceof JSGenericTypeImpl && JSArrayTypeImpl.isGenericArray(genericType = (JSGenericTypeImpl)type)) {
                    type = (JSType)ContainerUtil.getFirstItem(genericType.getArguments());
                }
            }
        } else {
            JSExpression initializer;
            PsiElement parent = this.getParent();
            if (!(parent instanceof JSDestructuringProperty || parent instanceof JSDestructuringElement || parent instanceof JSDestructuringObject || (initializer = this.getInitializer()) == null)) {
                type = new JSTypeofTypeImpl(initializer, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
            }
        }
        return type;
    }

    @Override
    public boolean isOptional() {
        JSParameterStub parameterStub = (JSParameterStub)this.getStub();
        if (parameterStub != null) {
            return parameterStub.isOptional();
        }
        if (this.getNode().findChildByType(JSTokenTypes.QUEST) != null) {
            return true;
        }
        if (this.getInitializer() == null) {
            return false;
        }
        return this.isOptionalForParameterWithInitializer();
    }

    private boolean isOptionalForParameterWithInitializer() {
        JSParameterList parameterList = (JSParameterList)PsiTreeUtil.getParentOfType((PsiElement)this, JSParameterList.class);
        if (parameterList == null) {
            return true;
        }
        boolean checkCurrent = false;
        for (JSParameter parameter : parameterList.getParameters()) {
            if (parameter == this) {
                checkCurrent = true;
                continue;
            }
            if (!checkCurrent) continue;
            if (parameter.isOptional() || parameter.isRest()) break;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRest() {
        JSParameterStub parameterStub = (JSParameterStub)this.getStub();
        if (parameterStub != null) {
            return parameterStub.isRest();
        }
        return this.getNode().findChildByType(JSTokenTypes.DOT_DOT_DOT) != null;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        JSClass parentClass;
        JSAttributeList.AccessType accessType;
        JSAttributeList attributeList = this.getAttributeList();
        JSAttributeList.AccessType accessType2 = accessType = attributeList != null ? attributeList.getExplicitAccessType() : null;
        if (JSAttributeList.TYPESCRIPT_ACCESS_TYPE_LIST.contains(accessType) && (parentClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)this, JSClass.class)) != null) {
            Object object = accessType == JSAttributeList.AccessType.PRIVATE ? new LocalSearchScope((PsiElement)parentClass) : parentClass.getUseScope();
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterImpl", "getUseScope"));
            }
            return object;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterImpl", "getUseScope"));
        }
        return searchScope;
    }

    @Override
    public PsiElement getTypeElement() {
        return TypeScriptPsiUtil.getStubOrPsiTypeElement(this);
    }

    @Override
    protected boolean isTypeExplicitlyDeclared() {
        return true;
    }
}

