/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSNodeVisitor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionCachedData;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.psi.PsiElement;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FunctionNodesVisitor
extends JSNodeVisitor {
    FunctionNodesVisitor() {
    }

    @Override
    public void visitFunctionExpression(ASTNode node) {
    }

    @Override
    public void visitFunctionDeclaration(ASTNode node) {
    }

    @Override
    public void visitFunctionProperty(ASTNode node) {
    }

    @Override
    public void visitAttributeList(ASTNode node) {
    }

    @Override
    public void visitDocComment(ASTNode node) {
    }

    @Override
    public void visitElement(ASTNode node) {
        for (ASTNode elt = node.getFirstChildNode(); elt != null; elt = elt.getTreeNext()) {
            this.visit(elt);
        }
    }

    static class JSFunctionNodesCacheVisitor
    extends FunctionNodesVisitor {
        private JSFunctionBaseImpl myBase;
        private final JSFunctionCachedData myCachedData;
        private final List<JSFunction> myNestedFuns;
        private final List<JSType> myEvaluatedReturnTypes;
        private final TObjectIntHashMap<String> myDeclaredParameters;

        public JSFunctionNodesCacheVisitor(JSFunctionBaseImpl base, JSFunctionCachedData cachedData, List<JSFunction> nestedFuns, List<JSType> evaluatedReturnTypes, TObjectIntHashMap<String> declaredParameters) {
            this.myBase = base;
            this.myCachedData = cachedData;
            this.myNestedFuns = nestedFuns;
            this.myEvaluatedReturnTypes = evaluatedReturnTypes;
            this.myDeclaredParameters = declaredParameters;
        }

        @Override
        public void visitThisExpression(ASTNode node) {
            this.myCachedData.referencesThis = true;
        }

        @Override
        public void visitFunctionExpression(ASTNode node) {
            this.myNestedFuns.add((JSFunction)node.getPsi());
        }

        @Override
        public void visitFunctionDeclaration(ASTNode node) {
            this.myNestedFuns.add((JSFunction)node.getPsi());
        }

        @Override
        public void visitFunctionProperty(ASTNode node) {
            this.myNestedFuns.add((JSFunction)node.getPsi());
        }

        @Override
        public void visitBinaryExpression(ASTNode node) {
            ASTNode child = node.findChildByType(JSTokenTypes.OROR);
            if (child != null) {
                this.addRef(node);
            } else {
                child = node.findChildByType(JSTokenTypes.ANDAND);
                if (child != null) {
                    this.addRef(node);
                } else {
                    ASTNode identifier;
                    ASTNode childByType = node.findChildByType(JSTokenTypes.EQUALITY_OPERATIONS);
                    if (childByType != null && (identifier = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET, childByType)) != null) {
                        if (identifier.findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                            this.addRef(node);
                        } else {
                            ASTNode firstIdentifier = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
                            if (firstIdentifier != null && firstIdentifier.findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                                this.addExpr(identifier);
                            }
                        }
                    }
                }
            }
            super.visitBinaryExpression(node);
        }

        @Override
        public void visitPrefixExpression(ASTNode node) {
            ASTNode child = node.findChildByType(JSTokenTypes.TYPEOF_KEYWORD);
            if (child == null) {
                child = node.findChildByType(JSTokenTypes.EXCL);
            }
            if (child != null) {
                this.addRef(node);
            }
            super.visitPrefixExpression(node);
        }

        @Override
        public void visitIfStatement(ASTNode node) {
            this.addRef(node);
            super.visitIfStatement(node);
        }

        @Override
        public void visitProperty(ASTNode node) {
            ASTNode expr;
            ASTNode name = JSPropertyImpl.findNameIdentifier(node);
            if (name != null && (expr = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET, name.getTreeNext())) != null && expr != name) {
                this.addExpr(expr);
            }
            super.visitProperty(node);
        }

        @Override
        public void visitArgumentList(ASTNode node) {
            ASTNode expr = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
            while (expr != null) {
                this.addExpr(expr);
                ASTNode treeNext = expr.getTreeNext();
                expr = treeNext != null ? node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET, treeNext) : null;
            }
            super.visitArgumentList(node);
        }

        @Override
        protected void visitYieldExpression(ASTNode node) {
            JSType type;
            JSYieldExpression yieldExpression;
            JSExpression expression;
            if (this.myBase.isGenerator() && (expression = (yieldExpression = (JSYieldExpression)node.getPsi()).getExpression()) != null && (type = this.visitReturnNode(node, expression)) != null) {
                this.addTypeToReturnTypeCollection(yieldExpression.isIterable() ? new JSIterableComponentTypeImpl(type, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true)) : type);
            }
            super.visitYieldExpression(node);
        }

        @Override
        public void visitReturnStatement(ASTNode node) {
            JSType type;
            if (!this.myBase.isGenerator() && (type = this.visitReturnNode(node, ((JSReturnStatement)node.getPsi()).getExpression())) != null) {
                this.addTypeToReturnTypeCollection(type);
            }
            super.visitReturnStatement(node);
        }

        @Nullable
        private JSType visitReturnNode(ASTNode node, JSExpression expression) {
            String text;
            ASTNode invoked;
            ASTNode newExpr = node.findChildByType(JSElementTypes.NEW_EXPRESSIONS);
            if (newExpr != null && (invoked = newExpr.findChildByType(JSElementTypes.REFERENCE_EXPRESSION)) != null && !this.myCachedData.declaredParameters.contains(text = invoked.getText()) && !this.myCachedData.declaredVariableNames.contains((Object)text) && text.equals(this.myBase.getName())) {
                this.myCachedData.constructorCanBeInvokedWithoutNew = this.myCachedData.referencesThis;
            }
            return !JSFunctionBaseImpl.shouldEvaluateReturnTypeFromBody(this.myBase) ? null : (expression != null ? new JSTypeofTypeImpl(expression, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true)) : new JSUndefinedType(JSTypeSourceFactory.createTypeSource(node.getPsi(), true)));
        }

        private void addTypeToReturnTypeCollection(@NotNull JSType returnType) {
            if (returnType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/lang/javascript/psi/impl/FunctionNodesVisitor$JSFunctionNodesCacheVisitor", "addTypeToReturnTypeCollection"));
            }
            List<JSType> newTypes = JSTypeUtils.addPossibleOption(this.myEvaluatedReturnTypes, returnType);
            this.myEvaluatedReturnTypes.addAll(newTypes);
        }

        @Override
        public void visitCallExpression(ASTNode node) {
            PsiElement callExpression = node.getPsi();
            JSExpression methodExpression = ((JSCallExpression)callExpression).getMethodExpression();
            if (methodExpression instanceof JSReferenceExpression) {
                JSReferenceExpression extensionSymbol;
                JSExpression[] arguments;
                String calledMethodName = ((JSReferenceExpression)methodExpression).getReferenceName();
                if (JSSymbolUtil.isExtendCall(((JSReferenceExpression)methodExpression).getQualifier(), calledMethodName, null) && (arguments = ((JSCallExpression)callExpression).getArguments()).length >= 2 && arguments[0] instanceof JSReferenceExpression && arguments[1] instanceof JSReferenceExpression && (extensionSymbol = (JSReferenceExpression)arguments[1]).getQualifier() == null) {
                    this.myCachedData.extensionSymbols.put(extensionSymbol.getReferenceName(), (JSReferenceExpression)arguments[0]);
                }
            }
            super.visitCallExpression(node);
        }

        private void addRef(ASTNode node) {
            ASTNode treeNext;
            ASTNode treeParent;
            ASTNode firstExpr = node.findChildByType(JSVariableImpl.IDENTIFIER_TOKENS_SET);
            this.addExpr(firstExpr);
            if (firstExpr != null && node.getElementType() == JSElementTypes.BINARY_EXPRESSION && (treeParent = node.getTreeParent()).getElementType() == JSElementTypes.BINARY_EXPRESSION && (treeNext = firstExpr.getTreeNext()) != null) {
                this.addExpr(node.findChildByType(JSElementTypes.EXPRESSIONS, treeNext));
            }
        }

        private void addExpr(ASTNode expr) {
            ASTNode node;
            if (expr != null && expr.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && expr.findChildByType(JSTokenTypes.DOT) == null && (node = expr.getFirstChildNode()).getTreeNext() == null) {
                String ref = node.getText();
                if (this.myCachedData.declaredParameters.contains(ref) && !this.myCachedData.declaredVariableNames.contains((Object)ref)) {
                    this.myDeclaredParameters.put((Object)ref, 1);
                } else if (this.myCachedData.referencedVariableNames.contains((Object)ref) && !this.myCachedData.declaredVariableNames.contains((Object)ref)) {
                    this.myCachedData.referencedVariableNames.put((Object)ref, 1);
                }
            }
        }
    }
}

