/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSExpressionImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSArrayLiteralExpressionImpl
extends JSExpressionImpl
implements JSArrayLiteralExpression {
    public JSArrayLiteralExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSExpression[] getExpressions() {
        ArrayList<JSExpression> result = new ArrayList<JSExpression>();
        boolean wasExpression = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (JSElementTypes.EXPRESSIONS.contains(type)) {
                result.add((JSExpression)child.getPsi());
                wasExpression = true;
                continue;
            }
            if (type != JSTokenTypes.COMMA) continue;
            if (wasExpression) {
                wasExpression = false;
                continue;
            }
            result.add(null);
        }
        return result.toArray(new JSExpression[result.size()]);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSArrayLiteralExpressionImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSArrayLiteralExpression((JSArrayLiteralExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

