/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSCatchBlockImpl
extends JSElementImpl
implements JSCatchBlock {
    public JSCatchBlockImpl(ASTNode node) {
        super(node);
    }

    public JSParameter getParameter() {
        ASTNode node = this.getNode().findChildByType((IElementType)JSElementTypes.FORMAL_PARAMETER);
        return node != null ? (JSParameter)node.getPsi() : null;
    }

    public JSStatement getStatement() {
        ASTNode node = this.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.STATEMENTS);
        return node != null ? (JSStatement)node.getPsi() : null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSCatchBlockImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSCatchBlock((JSCatchBlock)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        JSParameter param;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSCatchBlockImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSCatchBlockImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSCatchBlockImpl", "processDeclarations"));
        }
        if (lastParent != null && (param = this.getParameter()) != null) {
            return processor.execute((PsiElement)param, state);
        }
        return true;
    }

    public void delete() throws IncorrectOperationException {
        ASTNode astNode = this.getNode();
        astNode.getTreeParent().removeChild(astNode);
    }
}

