/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.FunctionNodesVisitor;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.Map;
import java.util.Set;

public class JSFunctionCachedData {
    final TObjectIntHashMap<String> declaredVariableNames = new TObjectIntHashMap(2);
    final Set<String> declaredParameters = new THashSet(2);
    final TObjectIntHashMap<String> referencedVariableNames = new TObjectIntHashMap(2);
    final Map<String, JSParameterTypeDecorator> parameterTypes = new THashMap(2);
    final Map<String, JSReferenceExpression> extensionSymbols = new THashMap();
    boolean constructor;
    boolean overrides;
    JSType returnType;
    String returnTypeString;
    boolean referencesArguments;
    boolean referencesThis;
    boolean constructorCanBeInvokedWithoutNew;

    JSFunctionCachedData(ASTNode node) {
        new FunctionNodesVisitor(){

            @Override
            public void visitParameter(ASTNode node) {
                ASTNode child = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
                if (child == null) {
                    child = node.getFirstChildNode();
                }
                JSFunctionCachedData.this.declaredParameters.add(child.getText());
            }

            @Override
            public void visitVariable(ASTNode node) {
                super.visitVariable(node);
                ASTNode child = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
                if (child != null) {
                    JSFunctionCachedData.this.declaredVariableNames.put((Object)child.getText(), 0);
                }
            }

            @Override
            public void visitFunctionDeclaration(ASTNode node) {
                super.visitFunctionDeclaration(node);
                ASTNode child = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
                if (child != null) {
                    JSFunctionCachedData.this.declaredVariableNames.put((Object)child.getText(), 0);
                }
            }

            @Override
            public void visitReferenceExpression(ASTNode node) {
                ASTNode childNode;
                if (node.findChildByType(JSElementTypes.EXPRESSIONS) == null && JSFunctionBaseImpl.isInJS(node) && (childNode = node.getFirstChildNode()) != null && childNode.getTreeNext() == null) {
                    String nodeText = childNode.getText();
                    if (!JSFunctionCachedData.this.declaredParameters.contains(nodeText) && !JSFunctionCachedData.this.declaredVariableNames.contains((Object)nodeText)) {
                        JSFunctionCachedData.this.referencedVariableNames.put((Object)nodeText, 0);
                    }
                    return;
                }
                super.visitReferenceExpression(node);
            }
        }.visitElement(node);
    }
}

