/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSPropertyNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPropertyNameReference
implements PsiPolyVariantReference {
    @NotNull
    private final JSPropertyImpl myProperty;

    public JSPropertyNameReference(@NotNull JSPropertyImpl property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "<init>"));
        }
        this.myProperty = property;
    }

    @NotNull
    public JSProperty getElement() {
        JSPropertyImpl jSPropertyImpl = this.myProperty;
        if (jSPropertyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "getElement"));
        }
        return jSPropertyImpl;
    }

    public TextRange getRangeInElement() {
        ASTNode nameIdentifier = this.myProperty.findNameIdentifier();
        if (nameIdentifier == null) {
            return this.myProperty.getTextRange();
        }
        int quotesDelta = nameIdentifier.getElementType() == JSTokenTypes.STRING_LITERAL && nameIdentifier.getTextLength() >= 2 ? 1 : 0;
        int startOffsetInParent = nameIdentifier.getPsi().getStartOffsetInParent();
        return new TextRange(startOffsetInParent + quotesDelta, startOffsetInParent + nameIdentifier.getTextLength() - quotesDelta);
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(true);
        return resolveResults.length == 0 || resolveResults.length > 1 || !resolveResults[0].isValidResult() ? null : resolveResults[0].getElement();
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (!this.myProperty.isValid()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(this.myProperty.getContainingFile(), this, new JSPropertyNameResolver(this));
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    public String getCanonicalText() {
        String string = StringUtil.stripQuotesAroundValue((String)this.myProperty.getFirstChild().getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.myProperty.setName(newElementName);
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "bindToElement"));
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiElement element2;
        JSExpression expression;
        if (element instanceof TypeScriptPropertySignature) {
            return element == this.resolve();
        }
        if (element instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression) {
            return ((JSReferenceExpression)expression).isReferenceTo(this.resolve());
        }
        if (element instanceof JSProperty && element != (element2 = this.resolve()) && element2 != null && element2 instanceof JSNamedElement) {
            if (!StringUtil.equals((CharSequence)((JSNamedElement)element).getName(), (CharSequence)((JSNamedElement)element2).getName())) {
                return false;
            }
            JSType elementContextType = JSContextResolver.resolveContext(element).getType();
            JSType element2ContextType = JSContextResolver.resolveContext(element2).getType();
            String elementContext = elementContextType != null ? JSTypeUtils.getQualifiedNameMatchingType(elementContextType, false) : null;
            String element2Context = element2ContextType != null ? JSTypeUtils.getQualifiedNameMatchingType(element2ContextType, false) : null;
            return elementContext == null || element2Context == null || JSTypeUtils.haveAncestorChildRelation(elementContext, element2Context);
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return true;
    }
}

