/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLocalVariable;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.JSE4XFilterQueryArgumentList;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceExpressionImpl
extends JSExpressionImpl
implements JSReferenceExpression,
BindablePsiReference {
    private static final TokenSet IDENTIFIER_TOKENS_SET = TokenSet.andNot((TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.IDENTIFIER_NAMES, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.ANY_IDENTIFIER})}), (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.DEBUGGER_KEYWORD}));

    public JSReferenceExpressionImpl(ASTNode node) {
        super(node);
    }

    @Nullable
    public JSExpression getQualifier() {
        ASTNode node = JSReferenceExpressionImpl.getQualifierNode(this.getNode());
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    @Nullable
    public static ASTNode getQualifierNode(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl", "getQualifierNode"));
        }
        return node.findChildByType(JSElementTypes.EXPRESSIONS);
    }

    @Nullable
    public String getReferencedName() {
        return JSReferenceExpressionImpl.getReferenceName(this.getNode());
    }

    @Nullable
    public String getReferenceName() {
        return this.getReferencedName();
    }

    @Nullable
    public PsiElement getReferenceNameElement() {
        ASTNode element = JSReferenceExpressionImpl.getNameElement(this.getNode());
        return element != null ? element.getPsi() : null;
    }

    @Nullable
    public static String getReferenceName(@NotNull ASTNode referenceNode) {
        if (referenceNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceNode", "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl", "getReferenceName"));
        }
        ASTNode nameElement = JSReferenceExpressionImpl.getNameElement(referenceNode);
        return nameElement != null ? StringUtil.replaceUnicodeEscapeSequences((String)nameElement.getText()) : null;
    }

    public PsiElement getElement() {
        return this;
    }

    public PsiReference getReference() {
        return this;
    }

    public TextRange getRangeInElement() {
        ASTNode astNode = this.getNode();
        ASTNode nameElement = JSReferenceExpressionImpl.getNameElement(astNode);
        int startOffset = nameElement != null ? nameElement.getStartOffset() : astNode.getTextRange().getStartOffset();
        ASTNode signature = astNode.findChildByType(JSElementTypes.GENERIC_SIGNATURE);
        int endOffsetInParent = signature != null ? signature.getTextRange().getStartOffset() - astNode.getTextRange().getStartOffset() : this.getTextLength();
        return new TextRange(startOffset - astNode.getStartOffset(), endOffsetInParent);
    }

    public static ASTNode getNameElement(ASTNode node) {
        return node.findChildByType(IDENTIFIER_TOKENS_SET);
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(true);
        return resolveResults.length == 0 || resolveResults.length > 1 || !resolveResults[0].isValidResult() ? null : resolveResults[0].getElement();
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ResolveResult[] results;
        for (ResolveResult r : results = this.multiResolve(false)) {
            PsiElement element = r.getElement();
            if ((!(element instanceof JSOffsetBasedImplicitElement) || ((JSOffsetBasedImplicitElement)element).getType() != JSImplicitElement.Type.Tag) && element instanceof JSElement) continue;
            return this.handleElementRenameInternal(newElementName);
        }
        throw new IncorrectOperationException("Unexpected rename request");
    }

    public PsiElement handleElementRenameInternal(String newElementName) throws IncorrectOperationException {
        ASTNode node;
        int i = newElementName.lastIndexOf(46);
        if (i != -1) {
            newElementName = newElementName.substring(0, i);
        }
        if (!this.isIdentifier(newElementName)) {
            throw new IncorrectOperationException("Invalid javascript element name:" + newElementName);
        }
        PsiElement parent = this.getParent();
        if ((parent instanceof JSClass || parent instanceof JSFunction) && (node = ((JSNamedElement)parent).findNameIdentifier()) != null && node.getPsi() == this) {
            return this;
        }
        ASTNode astNode = this.getNode();
        JSChangeUtil.doIdentifierReplacement(astNode, JSReferenceExpressionImpl.getNameElement(astNode), newElementName, this.getProject());
        return this.getParent();
    }

    private boolean isIdentifier(String name) {
        Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage())).createLexer(this.getProject());
        lexer.start((CharSequence)name);
        return JSKeywordSets.IDENTIFIER_TOKENS_SET.contains(lexer.getTokenType()) && lexer.getTokenEnd() == name.length();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        ASTNode node;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl", "bindToElement"));
        }
        PsiElement parent = this.getParent();
        if ((parent instanceof JSClass || parent instanceof JSNamespaceDeclaration || parent instanceof JSFunction) && (node = ((JSNamedElement)parent).findNameIdentifier()) != null && node.getPsi() == this && (parent == element || element instanceof PsiFile)) {
            return this;
        }
        String qName = JSPsiImplUtils.getQNameForMove((PsiElement)this, element);
        return JSReferenceExpressionImpl.bindToElement(this, qName, (PsiNamedElement)element, false);
    }

    public static JSReferenceExpression bindToElement(JSReferenceExpression ref, @Nullable String qName, @NotNull PsiNamedElement element, boolean justMakeQualified) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl", "bindToElement"));
        }
        String name = element.getName();
        if (name == null) {
            return ref;
        }
        String newName = element instanceof PsiFile ? FileUtil.getNameWithoutExtension((String)name) : name;
        for (JSResolveHelper helper : (JSResolveHelper[])Extensions.getExtensions(JSResolveHelper.EP_NAME)) {
            ref = helper.bindReferenceToElement(ref, qName, newName, justMakeQualified, element);
        }
        if (!newName.equals(ref.getReferencedName())) {
            ASTNode nameElement = JSChangeUtil.createNameIdentifier(ref.getProject(), newName);
            ASTNode refNode = ref.getNode();
            refNode.replaceChild(JSReferenceExpressionImpl.getNameElement(refNode), nameElement);
        }
        return ref;
    }

    public boolean isReferenceTo(PsiElement element) {
        JSExpression myQualifier = this.getQualifier();
        if (element instanceof JSLocalVariable && myQualifier != null) {
            return false;
        }
        if (element instanceof PsiNamedElement || element instanceof XmlAttributeValue) {
            String referencedName = this.getReferencedName();
            if (referencedName != null) {
                if (element instanceof JSDefinitionExpression && referencedName.equals(((JSDefinitionExpression)element).getName())) {
                    boolean myLanguageECMA;
                    boolean elementLanguageECMA = element.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                    boolean bl = myLanguageECMA = this.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                    if (elementLanguageECMA != myLanguageECMA) {
                        return false;
                    }
                    JSQualifiedName namespace = ((JSDefinitionExpression)element).getNamespace();
                    boolean namespaceExplicitlyDeclared = ((JSDefinitionExpression)element).isNamespaceExplicitlyDeclared();
                    return !namespaceExplicitlyDeclared || myQualifier != null || BaseJSSymbolProcessor.isGlobalNS(namespace);
                }
                if (element instanceof JSProperty && referencedName.equals(((JSProperty)element).getName()) && myQualifier != null) {
                    JSQualifiedName elementNamespace = ((JSProperty)element).getNamespace();
                    JSType type = JSResolveUtil.getExpressionJSType(myQualifier);
                    if (elementNamespace == null || !(type instanceof JSTypeImpl) || JSTypeUtils.haveAncestorChildRelation(elementNamespace.getQualifiedName(), type.getTypeText())) {
                        return true;
                    }
                }
            }
            return JSResolveUtil.isReferenceTo((PsiPolyVariantReference)this, referencedName, element);
        }
        return false;
    }

    public static void doProcessLocalDeclarations(@NotNull PsiElement context, @Nullable JSExpression qualifier, ResolveProcessor processor, boolean ecma, boolean completion, Boolean forceInTypeContext) {
        JSFunction nearestFunction;
        boolean toProcessHierarchy;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl", "doProcessLocalDeclarations"));
        }
        JSClass jsClass = JSResolveUtil.getClassOfContext(context, qualifier instanceof JSThisExpression);
        boolean inTypeContext = forceInTypeContext != null ? forceInTypeContext : context instanceof JSReferenceExpression && JSResolveUtil.isExprInTypeContext((JSReferenceExpression)context);
        boolean whereTypeCanBe = inTypeContext || DialectDetector.isTypeScript(context) && qualifier == null || completion && ecma && JSResolveUtil.isInPlaceWhereTypeCanBeDuringCompletion(context);
        PsiElement elToProcess = context;
        JSClass scopeToStopAt = null;
        PsiElement parent = context.getParent();
        boolean strictClassOffset = JSResolveUtil.getTopReferenceParent(parent) instanceof JSImportStatement;
        boolean toProcessMembers = !strictClassOffset;
        boolean bl = toProcessHierarchy = qualifier != null || !inTypeContext || parent instanceof JSNewExpression;
        if (qualifier != null) {
            elToProcess = jsClass;
            if (jsClass == null) {
                if (qualifier instanceof JSThisExpression) {
                    if (ecma) {
                        nearestFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)context, JSFunction.class);
                        elToProcess = nearestFunction != null && !(nearestFunction instanceof JSFunctionExpression) ? nearestFunction : context;
                    } else {
                        elToProcess = PsiTreeUtil.getParentOfType((PsiElement)context, JSProperty.class);
                        if (elToProcess != null) {
                            scopeToStopAt = elToProcess.getParent();
                        }
                    }
                } else if (qualifier instanceof JSSuperExpression) {
                    elToProcess = JSResolveUtil.getClassFromTagNameInMxml(context);
                }
            }
        } else if (ecma && whereTypeCanBe) {
            if (inTypeContext) {
                if (parent instanceof JSAttributeList && JSResolveUtil.findParent(parent.getParent()) instanceof JSBlockStatement) {
                    toProcessHierarchy = true;
                }
                if (!(parent instanceof JSNewExpression || parent instanceof JSAttributeList || parent instanceof JSBinaryExpression || parent instanceof JSUseNamespaceDirective)) {
                    toProcessMembers = false;
                    nearestFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)context, JSFunction.class);
                    Object object = elToProcess = nearestFunction != null ? nearestFunction.getFirstChild() : jsClass;
                }
                if (completion && (parent instanceof JSVariable || parent instanceof JSFunction || parent instanceof JSExpressionCodeFragment && ((JSExpressionCodeFragment)parent).isTypeContext())) {
                    PsiFile containingFile = context.getContainingFile();
                    JSImplicitElementImpl element = new JSImplicitElementImpl("*", null, (PsiElement)containingFile);
                    processor.execute((PsiElement)element, ResolveState.initial());
                    if (parent instanceof JSFunction || parent instanceof JSExpressionCodeFragment && ((JSExpressionCodeFragment)parent).isTypeContext()) {
                        element = new JSImplicitElementImpl("void", null, (PsiElement)containingFile);
                        processor.execute((PsiElement)element, ResolveState.initial());
                    }
                }
            } else if (parent instanceof JSExpressionStatement && JSResolveUtil.isPlaceWhereNsCanBe(parent)) {
                toProcessMembers = false;
                elToProcess = null;
            }
        }
        if ((qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) && jsClass != null) {
            JSFunctionExpression expression;
            scopeToStopAt = jsClass;
            if (ecma && (expression = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)context, JSFunctionExpression.class)) != null) {
                elToProcess = expression.getFirstChild();
            }
        }
        if (jsClass != null && (DialectDetector.isTypeScript(context) || DialectDetector.isES6(context))) {
            toProcessHierarchy = qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression;
            toProcessMembers = toProcessHierarchy;
            if (qualifier instanceof JSThisExpression && JSResolveUtil.calculateStaticFromContext(context)) {
                processor.setProcessStatics(true);
            }
        }
        if (DialectDetector.isES6(context) && jsClass != null && qualifier == null) {
            processor.setProcessStatics(false);
        }
        if (ecma && elToProcess == null && whereTypeCanBe && (elToProcess = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{JSPackageStatement.class, JSFile.class})) != null && (elToProcess = PsiTreeUtil.getChildOfType((PsiElement)elToProcess, PsiWhiteSpace.class)) == null) {
            elToProcess = context;
        }
        processor.setTypeContext(whereTypeCanBe || qualifier == null && parent instanceof JSReferenceExpression || strictClassOffset);
        processor.setToProcessMembers(toProcessMembers);
        if (elToProcess != null) {
            processor.setToProcessHierarchy(toProcessHierarchy);
            processor.setToSkipClassDeclarationsOnce(qualifier instanceof JSSuperExpression);
            if (ecma) {
                processor.setProcessStatics(JSReferenceExpressionImpl.isStaticContext(elToProcess));
            }
            JSResolveUtil.treeWalkUp(processor, elToProcess, elToProcess, context, (PsiElement)scopeToStopAt);
            processor.setToProcessHierarchy(false);
            processor.setToSkipClassDeclarationsOnce(false);
            processor.setProcessStatics(false);
        }
    }

    private static boolean isStaticContext(PsiElement element) {
        PsiElement p;
        JSElement parent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSVariable.class, JSFunction.class, JSClass.class, JSFile.class});
        if (parent instanceof JSClass) {
            return true;
        }
        if (parent instanceof JSFile) {
            PsiElement context = parent.getContext();
            if (context instanceof XmlText) {
                context = context.getParent();
            }
            if (context instanceof XmlTag && "Script".equals(((XmlTag)context).getLocalName())) {
                return true;
            }
        }
        return parent instanceof JSFunction && (p = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class, JSAttributeList.class})) == ((JSFunction)parent).getAttributeList();
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSReferenceExpression((JSReferenceExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(this.getContainingFile(), this, JSDialectSpecificHandlersFactory.forElement((PsiElement)this).createReferenceExpressionResolver(this, this.getContainingFile()));
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl", "multiResolve"));
        }
        return resolveResultArray;
    }

    @Nullable
    public static JSReferenceExpression getNamespaceReference(JSReferenceExpression thisElement) {
        PsiElement parent = thisElement.getParent();
        if (parent instanceof JSE4XNamespaceReference) {
            return ((JSE4XNamespaceReference)parent).getNamespaceReference();
        }
        return thisElement.getNamespaceElement();
    }

    @Nullable
    public JSExpression getResolveQualifier() {
        PsiElement parent;
        JSExpression qualifier = this.getQualifier();
        if (qualifier == null && (parent = this.getParent()) instanceof JSCallExpression) {
            PsiElement parent1 = JSResolveUtil.getTopReferenceParent(parent.getParent());
            if (parent1 instanceof JSBinaryExpression) {
                while (parent1 instanceof JSBinaryExpression) {
                    parent1 = parent1.getParent();
                }
                if (!(parent1 instanceof JSE4XFilterQueryArgumentList)) {
                    return null;
                }
                PsiElement element = parent1.getParent();
                if (element instanceof JSCallExpression) {
                    parent1 = ((JSCallExpression)element).getMethodExpression();
                }
                if (parent1 instanceof JSExpression && !(parent1 instanceof JSDefinitionExpression)) {
                    return (JSExpression)parent1;
                }
            }
            return null;
        }
        return qualifier;
    }

    public static boolean isLocalResolveQualifier(JSExpression qualifier) {
        return qualifier == null || qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression;
    }

    public boolean shouldCheckReferences() {
        return true;
    }

    public boolean isAttributeReference() {
        return this.getNode().findChildByType(JSTokenTypes.AT) != null;
    }

    public JSReferenceExpression getNamespaceElement() {
        ASTNode node = this.getNode().findChildByType(JSElementTypes.E4X_NAMESPACE_REFERENCE);
        return node == null ? null : ((JSE4XNamespaceReference)node.getPsi()).getNamespaceReference();
    }

    public static ResolveResult[] resolveUnqualified(@NotNull String referenceName, PsiElement context, Boolean forceInTypeContext) {
        if (referenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl", "resolveUnqualified"));
        }
        SinkResolveProcessor<ResolveResultSink> resolveProcessor = new SinkResolveProcessor<ResolveResultSink>(referenceName, context, new ResolveResultSink(context, referenceName)){

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl$1", "execute"));
                }
                if (!(element instanceof JSQualifiedNamedElement)) {
                    return true;
                }
                super.execute(element, state);
                return true;
            }
        };
        resolveProcessor.setNeedsAllVariants();
        resolveProcessor.setForceImportsForPlace(!(context instanceof JSReferenceExpressionImpl));
        boolean ecma = context.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
        JSReferenceExpressionImpl.doProcessLocalDeclarations(context, null, resolveProcessor, ecma, false, forceInTypeContext);
        HashMap<String, ResolveResult> uniqueResults = new HashMap<String, ResolveResult>();
        for (ResolveResult result : resolveProcessor.getResultsAsResolveResults()) {
            String qname = ((JSQualifiedNamedElement)result.getElement()).getQualifiedName();
            ResolveResult existing = (ResolveResult)uniqueResults.get(qname);
            if (existing != null && (((JSResolveResult)existing).getImportUsed() == null || ((JSResolveResult)result).getImportUsed() != null)) continue;
            uniqueResults.put(qname, result);
        }
        return !uniqueResults.isEmpty() ? uniqueResults.values().toArray(new ResolveResult[uniqueResults.size()]) : ResolveResult.EMPTY_ARRAY;
    }

    public void delete() throws IncorrectOperationException {
        ASTNode myNode = this.getNode();
        ASTNode parent = myNode.getTreeParent();
        if (JSElementTypes.EXTENDS_IMPLEMENTS_LISTS.contains(parent.getElementType())) {
            JSExpression[] references = ((JSReferenceList)parent.getPsi()).getExpressions();
            if (references.length == 1) {
                parent.getPsi().delete();
            } else {
                JSChangeUtil.removeRangeWithRemovalOfCommas(myNode, parent);
            }
        } else {
            super.delete();
        }
    }
}

