/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSStubElementImpl<T extends JSStubElement>
extends StubBasedPsiElementBase<T>
implements JSElement {
    @NonNls
    private static final String IMPL = "Impl";
    private Language myLanguage;

    public JSStubElementImpl(ASTNode node) {
        super(node);
    }

    public JSStubElementImpl(T t, IStubElementType type) {
        super(t, type);
    }

    @NotNull
    public Language getLanguage() {
        if (this.myLanguage == null) {
            Language language = DialectDetector.languageOfElement((PsiElement)this);
            this.myLanguage = language instanceof JSLanguageDialect ? language : JavascriptLanguage.INSTANCE;
        }
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSStubElementImpl", "getLanguage"));
        }
        return language;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSStubElementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSElement((JSElement)this);
        } else {
            super.accept(visitor);
        }
    }

    public SearchScope getDefaultUseScope() {
        PsiFile file = this.getContainingFile();
        return InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file).getUseScope();
    }

    public String toString() {
        String classname = ((Object)((Object)this)).getClass().getName();
        if (classname.endsWith(IMPL)) {
            classname = classname.substring(0, classname.length() - IMPL.length());
        }
        classname = classname.substring(classname.lastIndexOf(".") + 1);
        return classname;
    }

    public ItemPresentation getPresentation() {
        if (this instanceof JSPsiElementBase) {
            return new JSItemPresentation((JSPsiElementBase)this);
        }
        return null;
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSStubElementImpl", "addBefore"));
        }
        if (JSChangeUtil.isStatementOrComment(element)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddBefore((PsiElement)this, element, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddBefore(element, anchor);
            }
        }
        return super.addBefore(element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSStubElementImpl", "addAfter"));
        }
        if (JSChangeUtil.isStatementOrComment(element)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddAfter((PsiElement)this, element, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddAfter(element, anchor);
            }
        }
        return super.addAfter(element, anchor);
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/lang/javascript/psi/impl/JSStubElementImpl", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/lang/javascript/psi/impl/JSStubElementImpl", "addRangeBefore"));
        }
        if (JSChangeUtil.isStatementOrComment(first)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddRangeBefore((PsiElement)this, first, last, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddRangeBefore(first, last, anchor);
            }
        }
        return super.addRangeBefore(first, last, anchor);
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (JSChangeUtil.isStatementOrComment(first)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddRangeAfter((PsiElement)this, first, last, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddRangeAfter(first, last, anchor);
            }
        }
        return super.addRangeAfter(first, last, anchor);
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSStubElementImpl", "add"));
        }
        return this.addAfter(element, null);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return this.addRangeAfter(first, last, null);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/psi/impl/JSStubElementImpl", "replace"));
        }
        ASTNode myNode = this.getNode();
        ASTNode result = newElement.getNode().copyElement();
        myNode.getTreeParent().replaceChild(myNode, result);
        return result.getPsi();
    }

    public PsiElement getParent() {
        JSStubElement stub = (JSStubElement)this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        return super.getParent();
    }

    @NotNull
    protected static Icon getIcon(@NotNull JSPsiElementBase element, @NotNull Icon defaultBaseIcon, int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSStubElementImpl", "getIcon"));
        }
        if (defaultBaseIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultBaseIcon", "com/intellij/lang/javascript/psi/impl/JSStubElementImpl", "getIcon"));
        }
        Icon icon = defaultBaseIcon;
        JSDocComment docComment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element);
        if (docComment != null && docComment.isClassExplicitly()) {
            icon = JSIconProvider.DEFAULT_INSTANCE.getClassIcon();
        }
        boolean blendStatic = element.getJSContext() == JSContext.STATIC;
        boolean blendFinal = false;
        if (element instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
            boolean bl = blendFinal = attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.FINAL);
        }
        if (element instanceof JSVariable && ((JSVariable)element).isConst()) {
            blendFinal = true;
        }
        icon = JSStubElementImpl.blendFlags(icon, blendStatic, blendFinal);
        JSAttributeList.AccessType accessType = element.getAccessType();
        if (accessType != JSAttributeList.AccessType.PACKAGE_LOCAL) {
            icon = JSStubElementImpl.iconWithVisibilityIfNeeded((int)flags, (Icon)icon, (Icon)accessType.getIcon());
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSStubElementImpl", "getIcon"));
        }
        return icon2;
    }

    protected static Icon blendModifierFlags(Icon baseIcon, JSAttributeList attrList, boolean blendStatic) {
        PsiElement superParent;
        PsiElement grandParent;
        if (attrList == null) {
            return baseIcon;
        }
        boolean isStatic = attrList.hasModifier(JSAttributeList.ModifierType.STATIC) || (grandParent = attrList.getParent().getParent()) instanceof JSBlockStatement && ((superParent = grandParent.getParent()) instanceof JSClass || superParent instanceof JSFile && superParent.getContext() != null);
        return JSStubElementImpl.blendFlags(baseIcon, blendStatic && isStatic || attrList.hasModifier(JSAttributeList.ModifierType.DYNAMIC), attrList.hasModifier(JSAttributeList.ModifierType.FINAL));
    }

    public static Icon blendFlags(Icon baseIcon, boolean blendStatic, boolean blendFinal) {
        if (blendStatic) {
            baseIcon = ElementBase.overlayIcons((Icon[])new Icon[]{baseIcon, AllIcons.Nodes.StaticMark});
        }
        if (blendFinal) {
            baseIcon = ElementBase.overlayIcons((Icon[])new Icon[]{baseIcon, AllIcons.Nodes.FinalMark});
        }
        return baseIcon;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = JSResolveUtil.getResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSStubElementImpl", "getResolveScope"));
        }
        return globalSearchScope;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.clearCaches();
    }

    public void clearCaches() {
    }
}

