/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.lang.javascript.types.JSClassElementType;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSStubbedStatementImpl<T extends JSStubElement>
extends JSStubElementImpl<T>
implements JSStatement,
JSSuppressionHolder {
    public JSStubbedStatementImpl(ASTNode node) {
        super(node);
    }

    public JSStubbedStatementImpl(T t, IStubElementType type) {
        super(t, type);
    }

    public JSStatement addStatementBefore(JSStatement toAdd) throws IncorrectOperationException {
        return JSStubbedStatementImpl.addStatementImpl(this, toAdd, true);
    }

    public JSStatement addStatementAfter(JSStatement toAdd) throws IncorrectOperationException {
        return JSStubbedStatementImpl.addStatementImpl(this, toAdd, false);
    }

    static JSStatement addStatementImpl(@NotNull JSStatement statement, JSStatement toAdd, boolean before) throws IncorrectOperationException {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/psi/impl/JSStubbedStatementImpl", "addStatementImpl"));
        }
        ASTNode treeParent = statement.getNode().getTreeParent();
        if (treeParent.getElementType() != JSElementTypes.BLOCK_STATEMENT && !(treeParent.getElementType() instanceof JSFileElementType) && !(treeParent.getElementType() instanceof JSClassElementType) && treeParent.getElementType() != JSElementTypes.EMBEDDED_CONTENT) {
            if (before) {
                return (JSStatement)treeParent.getPsi().addBefore((PsiElement)toAdd, (PsiElement)statement);
            }
            return (JSStatement)treeParent.getPsi().addAfter((PsiElement)toAdd, (PsiElement)statement);
        }
        ASTNode copy = toAdd.getNode().copyElement();
        ASTNode anchorBefore = before ? statement.getNode() : statement.getNode().getTreeNext();
        treeParent.addChild(copy, anchorBefore);
        return (JSStatement)copy.getPsi();
    }

    public JSStatement replace(JSStatement newStatement) {
        return JSChangeUtil.replaceStatement(this, newStatement);
    }

    public void delete() throws IncorrectOperationException {
        JSPsiImplUtils.deleteFromTree((PsiElement)this);
    }
}

