/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeVisitor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocTagValueImpl
extends JSElementImpl
implements JSDocTagValue {
    private volatile PsiReference[] myRefs;
    private volatile long myModificationCount = -1L;
    private static final Pattern REPLACE_ASTERISKS_PATTERN = Pattern.compile("\\n\\s*\\*?");

    public JSDocTagValueImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiReference[] getReferences() {
        long count = this.getManager().getModificationTracker().getModificationCount();
        if (count != this.myModificationCount) {
            String name = ((PsiNamedElement)this.getParent()).getName();
            ArrayList result = new ArrayList();
            if (name != null) {
                String text = this.getText();
                boolean soft = false;
                boolean event = false;
                boolean module = false;
                if ("class".equals(name)) {
                    soft = text.indexOf(46) == -1;
                } else if ("see".equals(name)) {
                    soft = true;
                    if (!text.startsWith("http:")) {
                        if (text.indexOf(35) != -1) {
                            soft = false;
                        } else {
                            int dotPos = text.lastIndexOf(46);
                            if (dotPos != -1 && dotPos + 1 < text.length() && Character.isUpperCase(text.charAt(dotPos + 1))) {
                                soft = false;
                            }
                        }
                    }
                } else if ("returns".equals(name) || "return".equals(name)) {
                    soft = text.indexOf(123) == -1;
                } else if ("link".equals(name)) {
                    soft = text.startsWith("http:");
                } else if ("throws".equals(name)) {
                    soft = true;
                } else if ("module".equals(name)) {
                    module = true;
                } else if ("event".equals(name)) {
                    soft = true;
                    event = true;
                } else if ("fires".equals(name)) {
                    event = true;
                }
                int offset = 0;
                boolean wrappedInBraces = false;
                if (text.startsWith("{")) {
                    text = text.substring(1);
                    ++offset;
                    soft = false;
                    wrappedInBraces = true;
                }
                if (text.endsWith("}")) {
                    text = text.substring(0, text.length() - 1);
                } else {
                    wrappedInBraces = false;
                }
                Matcher matcher = REPLACE_ASTERISKS_PATTERN.matcher(text);
                StringBuilder builder = new StringBuilder(text);
                while (matcher.find()) {
                    int start = matcher.start();
                    int end = matcher.end();
                    builder.replace(start, end, StringUtil.repeatSymbol((char)' ', (int)(end - start)));
                }
                text = builder.toString();
                SmartList myReferences = new SmartList();
                JSTypeParser typeParser = new JSTypeParser(text, new JSTypeVisitor((List)myReferences){
                    final /* synthetic */ List val$myReferences;
                    {
                        this.val$myReferences = list;
                    }

                    @Override
                    public void visitSingleType(int startOffset, String name) {
                        if (!"void".equals(name)) {
                            this.val$myReferences.add(Pair.create((Object)startOffset, (Object)name));
                        }
                    }

                    @Override
                    public void visitRecordProperty(int startOffset, String name, @Nullable String recordPropertyType) {
                    }
                });
                boolean parsedSuccessfully = module ? typeParser.parseNamepath() != null : typeParser.parseParameterType() != null;
                for (Pair reference : myReferences) {
                    JSDocReferenceSet set = new JSDocReferenceSet((PsiElement)this, (String)reference.second, offset + (Integer)reference.first, soft, event, module);
                    Collections.addAll(result, set.getReferences());
                }
                if (!parsedSuccessfully) {
                    result.clear();
                    if (wrappedInBraces || JSDocumentationUtils.isExtendedTypeName(text) || DialectDetector.isActionScript((PsiElement)this)) {
                        JSDocReferenceSet set = new JSDocReferenceSet((PsiElement)this, text, offset, soft);
                        Collections.addAll(result, set.getReferences());
                    }
                }
            }
            this.myRefs = result.isEmpty() ? PsiReference.EMPTY_ARRAY : result.toArray(new PsiReference[result.size()]);
            this.myModificationCount = count;
        }
        if (this.myRefs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagValueImpl", "getReferences"));
        }
        return this.myRefs;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagValueImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDocTagValue((JSDocTagValue)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

