/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSClassResolver {
    private static JSClassResolver INSTANCE = null;

    protected JSClassResolver() {
    }

    public static JSClassResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JSClassResolver();
        }
        return INSTANCE;
    }

    public static PsiElement findClassFromNamespace(@NotNull String qname, @NotNull PsiElement context) {
        if (qname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qname", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassFromNamespace"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassFromNamespace"));
        }
        return JSClassResolver.findClassFromNamespace(qname, context, JSResolveUtil.getResolveScope(context));
    }

    public static PsiElement findClassFromNamespace(@NotNull String qname, @NotNull PsiElement context, @NotNull GlobalSearchScope scope) {
        JSNamedElement localElement;
        if (qname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qname", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassFromNamespace"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassFromNamespace"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassFromNamespace"));
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(context.getContainingFile());
        if (dialect != null && (dialect.isJavaScript() || dialect.isTypeScript)) {
            return null;
        }
        VirtualFile vFile = context.getContainingFile().getVirtualFile();
        if (!"Object".equals(qname) && (vFile == null || scope.contains(vFile)) && (localElement = JSResolveUtil.findFileLocalElement(qname, context)) != null) {
            return localElement;
        }
        return JSDialectSpecificHandlersFactory.forElement(context).getClassResolver().findClassByQName(qname, scope);
    }

    public static long getResolveResultTimestamp(PsiElement candidate) {
        for (JSResolveHelper helper : (JSResolveHelper[])Extensions.getExtensions(JSResolveHelper.EP_NAME)) {
            long result = helper.getResolveResultTimestamp(candidate);
            if (result == -1L) continue;
            return result;
        }
        return -1L;
    }

    public PsiElement findClassByQName(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassByQName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassByQName"));
        }
        return this.findClassByQName(link, JavaScriptIndex.getInstance(context.getProject()), JSResolveUtil.getResolveScope(context), DialectOptionHolder.JS_1_5);
    }

    @Nullable
    public PsiElement findClassByQName(@NotNull String link, @NotNull GlobalSearchScope scope) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassByQName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassByQName"));
        }
        return TypeScriptClassResolver.getInstance().findAnyClassByQName(link, scope);
    }

    @Nullable
    protected final PsiElement findClassByQName(@NotNull String link, JavaScriptIndex index, GlobalSearchScope searchScope, @NotNull DialectOptionHolder dialect) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassByQName"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassByQName"));
        }
        if (searchScope instanceof JSResolveUtil.AllowFileLocalSymbols) {
            return this.doFindClassByQName(link, index, searchScope, true, dialect);
        }
        PsiElement element = index.recallClass(link, searchScope);
        if (element != null) {
            return element;
        }
        element = this.doFindClassByQName(link, index, searchScope, false, dialect);
        if (element != null) {
            index.rememberTopLevelClassElement(link, searchScope, element);
        }
        return element;
    }

    protected PsiElement doFindClassByQName(@NotNull String link, JavaScriptIndex index, GlobalSearchScope searchScope, boolean allowFileLocalSymbols, @NotNull DialectOptionHolder dialect) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "doFindClassByQName"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "doFindClassByQName"));
        }
        Project project = index.getProject();
        Collection candidates = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)link.hashCode(), (Project)project, (GlobalSearchScope)searchScope, JSQualifiedNamedElement.class);
        for (Object _clazz : candidates) {
            PsiFile file;
            JSQualifiedNamedElement clazz;
            if (!(_clazz instanceof JSQualifiedNamedElement) || !link.equals((clazz = (JSQualifiedNamedElement)_clazz).getQualifiedName()) || (file = clazz.getContainingFile()).getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) continue;
            return clazz;
        }
        return null;
    }

    @NotNull
    public List<JSClass> findClassesByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassesByQName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassesByQName"));
        }
        PsiElement clazz = this.findClassByQName(qName, scope);
        List<JSClass> list = clazz instanceof JSClass ? Collections.singletonList((JSClass)clazz) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findClassesByQName"));
        }
        return list;
    }

    public boolean processElementByQName(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Processor<? super JSQualifiedNamedElement> processor) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "processElementByQName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "processElementByQName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "processElementByQName"));
        }
        return StubIndex.getInstance().processElements(JSQualifiedElementIndex.KEY, (Object)qName.hashCode(), scope.getProject(), scope, JSQualifiedNamedElement.class, processor);
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findElementsByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findElementsByQName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findElementsByQName"));
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processElementByQName(qName, scope, (Processor<? super JSQualifiedNamedElement>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findElementsByQName"));
        }
        return collection;
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findNamespaceMembers"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findNamespaceMembers"));
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processNamespaceMembers(namespace, scope, (Processor<JSPsiElementBase>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findNamespaceMembers"));
        }
        return collection;
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope, final @NotNull Processor<JSPsiElementBase> processor) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "processNamespaceMembers"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "processNamespaceMembers"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "processNamespaceMembers"));
        }
        final JSQualifiedNameImpl namespaceQName = "".equals(namespace) ? null : JSQualifiedNameImpl.fromQualifiedName(namespace);
        Project project = scope.getProject();
        if (project == null) {
            return true;
        }
        return StubIndex.getInstance().processElements(JSNamespaceMembersIndex.KEY, (Object)namespace, project, scope, JSElement.class, (Processor)new Processor<JSElement>(){

            public boolean process(JSElement element) {
                Collection implicitElements;
                JSElementIndexingData data;
                boolean emptyImplicitElements = true;
                if (element instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)element).getIndexingData()) != null && (implicitElements = data.getImplicitElements()) != null) {
                    emptyImplicitElements = false;
                    for (JSImplicitElement implicitElement : implicitElements) {
                        if (!ComparatorUtil.equalsNullable((Object)namespaceQName, (Object)implicitElement.getNamespace()) || processor.process((Object)implicitElement)) continue;
                        return false;
                    }
                }
                return !(element instanceof JSPsiElementBase) || !emptyImplicitElements && !ComparatorUtil.equalsNullable((Object)namespaceQName, (Object)((JSPsiElementBase)element).getNamespace()) || processor.process((Object)((JSPsiElementBase)element));
            }
        });
    }

    @NotNull
    public Collection<JSPsiElementBase> findElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findElementsByQNameIncludingImplicit"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findElementsByQNameIncludingImplicit"));
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processElementsByQNameIncludingImplicit(qName, scope, (Processor<JSPsiElementBase>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findElementsByQNameIncludingImplicit"));
        }
        return collection;
    }

    public boolean processElementsByQNameIncludingImplicit(final @NotNull String qName, @NotNull GlobalSearchScope scope, final @NotNull Processor<JSPsiElementBase> processor) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "processElementsByQNameIncludingImplicit"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "processElementsByQNameIncludingImplicit"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "processElementsByQNameIncludingImplicit"));
        }
        Project project = scope.getProject();
        assert (project != null);
        return StubIndex.getInstance().processElements(JSSymbolQualifiedNamesIndex.KEY, (Object)qName, project, scope, JSElement.class, (Processor)new Processor<JSElement>(){

            public boolean process(JSElement element) {
                if (element instanceof JSPsiElementBase && qName.equals(((JSPsiElementBase)element).getQualifiedName()) && !processor.process((Object)((JSPsiElementBase)element))) {
                    return false;
                }
                if (element instanceof JSImplicitElementProvider) {
                    Collection implicitElements;
                    JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
                    Collection collection = implicitElements = data != null ? data.getImplicitElements() : null;
                    if (implicitElements != null) {
                        for (JSImplicitElement implicitElement : implicitElements) {
                            if (!qName.equals(implicitElement.getQualifiedName()) || processor.process((Object)implicitElement)) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
        });
    }

    @NotNull
    public Collection<JSPsiElementBase> findElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findElementsByNameIncludingImplicit"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findElementsByNameIncludingImplicit"));
        }
        Collection<JSPsiElementBase> collection = JSClassResolver.findElementsByNameIncludingImplicit(name, scope, false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findElementsByNameIncludingImplicit"));
        }
        return collection;
    }

    @NotNull
    public static Collection<JSPsiElementBase> findElementsByNameIncludingImplicit(final @NotNull String name, @NotNull GlobalSearchScope scope, final boolean justClasses) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findElementsByNameIncludingImplicit"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findElementsByNameIncludingImplicit"));
        }
        Project project = scope.getProject();
        assert (project != null);
        final ArrayList<JSPsiElementBase> result = new ArrayList<JSPsiElementBase>();
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)name, project, scope, JSElement.class, (Processor)new Processor<JSElement>(){

            public boolean process(JSElement element) {
                if (justClasses && !(element instanceof JSClass)) {
                    return true;
                }
                JSClassResolver.addMatchingImplicitElements(element, name, result);
                if (element instanceof JSPsiElementBase && name.equals(element.getName())) {
                    result.add((JSPsiElementBase)element);
                }
                return true;
            }
        });
        ArrayList<JSPsiElementBase> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "findElementsByNameIncludingImplicit"));
        }
        return arrayList;
    }

    public static void addMatchingImplicitElements(JSElement element, @NotNull String name, Collection<JSPsiElementBase> result) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/JSClassResolver", "addMatchingImplicitElements"));
        }
        if (element instanceof JSImplicitElementProvider) {
            Collection implicitElements;
            JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
            Collection collection = implicitElements = data != null ? data.getImplicitElements() : null;
            if (implicitElements != null) {
                for (JSImplicitElement implicitElement : implicitElements) {
                    if (!name.equals(implicitElement.getName())) continue;
                    result.add((JSPsiElementBase)implicitElement);
                }
            }
        }
    }
}

