/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.flex.PsiScopedImportSet;
import com.intellij.lang.javascript.flex.ScopedImportSet;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportHandlingUtil {
    public static final PsiScopedImportSet ourPsiScopedImportSet = new PsiScopedImportSet();

    @Nullable
    public static String resolveTypeName(@Nullable String _str, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSImportHandlingUtil", "resolveTypeName"));
        }
        if (_str == null) {
            return null;
        }
        JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement(context).getImportHandler();
        return importHandler.getQualifiedNameResolvedType(_str, context);
    }

    @Nullable
    public static JSImportedElementResolveResult resolveTypeNameUsingImports(@NotNull JSReferenceExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/psi/resolve/JSImportHandlingUtil", "resolveTypeNameUsingImports"));
        }
        JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)expr).getImportHandler();
        return importHandler.resolveTypeNameUsingImports(expr);
    }

    public static boolean tryResolveImports(PsiScopeProcessor processor, PsiNamedElement parent, @NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSImportHandlingUtil", "tryResolveImports"));
        }
        if (!JSImportHandlingUtil.isAdequatePlaceForImport(parent, place, processor)) {
            return true;
        }
        JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)parent).getImportHandler();
        return importHandler.importClass(processor, parent);
    }

    public static boolean isAdequatePlaceForImport(PsiNamedElement parent, @NotNull PsiElement place, PsiScopeProcessor processor) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSImportHandlingUtil", "isAdequatePlaceForImport"));
        }
        PsiFile containingFile = parent.getContainingFile();
        if (containingFile instanceof JSFile && !containingFile.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            return false;
        }
        if (processor instanceof ResolveProcessor && ((ResolveProcessor)processor).isForceImportsForPlace()) {
            return true;
        }
        if (place instanceof JSReferenceExpression) {
            PsiElement currentParent;
            PsiElement placeParent = place.getParent();
            if (placeParent instanceof JSReferenceExpression && (JSResolveUtil.isSelfReference(currentParent = JSResolveUtil.getTopReferenceParent(placeParent), place) || currentParent instanceof JSReferenceList)) {
                return false;
            }
        } else if (!(place instanceof JSDocTagValue || place instanceof JSAttributeNameValuePair || place instanceof XmlAttributeValue || place instanceof XmlTag || place instanceof JSFile)) {
            return JSImportHandlingUtil.isAdequatePlaceForImportViaHelper(place);
        }
        return true;
    }

    private static boolean isAdequatePlaceForImportViaHelper(PsiElement place) {
        for (JSResolveHelper helper : (JSResolveHelper[])Extensions.getExtensions(JSResolveHelper.EP_NAME)) {
            if (!helper.isAdequatePlaceForImport(place)) continue;
            return true;
        }
        return false;
    }

    public static ImportStatus evaluateImportStatus(String newName, PsiElement context) {
        EvaluateImportStatusProcessor statusProcessor = new EvaluateImportStatusProcessor(newName);
        JSResolveUtil.walkOverStructure(context, statusProcessor);
        return (ImportStatus)((Object)statusProcessor.myStatus.get());
    }

    private static class EvaluateImportStatusProcessor
    implements Processor<PsiNamedElement>,
    ScopedImportSet.ImportProcessor<Object> {
        private final String myNewName;
        private final Ref<ImportStatus> myStatus = new Ref((Object)ImportStatus.ABSENT);

        public EvaluateImportStatusProcessor(String newName) {
            this.myNewName = newName;
        }

        public boolean process(PsiNamedElement context) {
            ourPsiScopedImportSet.process(this.myNewName, null, context, this);
            if (context instanceof JSPackageStatement) {
                return false;
            }
            return this.myStatus.get() == ImportStatus.ABSENT;
        }

        @Override
        public Object process(@NotNull String referenceName, @NotNull ScopedImportSet.ImportProcessor.ImportInfo info, @NotNull PsiNamedElement scope) {
            PsiElement clazz;
            if (referenceName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/lang/javascript/psi/resolve/JSImportHandlingUtil$EvaluateImportStatusProcessor", "process"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/psi/resolve/JSImportHandlingUtil$EvaluateImportStatusProcessor", "process"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSImportHandlingUtil$EvaluateImportStatusProcessor", "process"));
            }
            if (info.starImport && (clazz = JSDialectSpecificHandlersFactory.forElement((PsiElement)scope).getClassResolver().findClassByQName(info.getQNameToSearch(referenceName), (PsiElement)scope)) == null) {
                return null;
            }
            ImportStatus status = (ImportStatus)((Object)this.myStatus.get());
            if (status == ImportStatus.ABSENT) {
                this.myStatus.set((Object)ImportStatus.UNIQUE);
            } else if (status == ImportStatus.UNIQUE) {
                this.myStatus.set((Object)ImportStatus.MULTIPLE);
            }
            return null;
        }
    }

    public static enum ImportStatus {
        ABSENT,
        UNIQUE,
        MULTIPLE;

    }
}

