/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;

public enum JSNamedElementKind {
    PARAMETER{

        @Override
        public String humanReadableKey() {
            return "javascript.parameter.kind";
        }
    }
    ,
    LOCAL_VAR{

        @Override
        public String humanReadableKey() {
            return "javascript.local.variable.kind";
        }
    }
    ,
    VAR{

        @Override
        public String humanReadableKey() {
            return "javascript.variable.kind";
        }
    }
    ,
    FIELD{

        @Override
        public String humanReadableKey() {
            return "javascript.field.kind";
        }
    }
    ,
    CONSTANT{

        @Override
        public String humanReadableKey() {
            return "javascript.constant.kind";
        }
    }
    ,
    METHOD{

        @Override
        public String humanReadableKey() {
            return "javascript.method.kind";
        }
    }
    ,
    CLASS{

        @Override
        public String humanReadableKey() {
            return "javascript.class.kind";
        }
    }
    ,
    INTERFACE{

        @Override
        public String humanReadableKey() {
            return "javascript.interface.kind";
        }
    }
    ,
    DEFINITION{

        @Override
        public String humanReadableKey() {
            return "javascript.definition.kind";
        }
    }
    ,
    PROPERTY{

        @Override
        public String humanReadableKey() {
            return "javascript.property.kind";
        }
    }
    ,
    NAMESPACE{

        @Override
        public String humanReadableKey() {
            return "javascript.namespace.kind";
        }
    }
    ,
    FUNCTION{

        @Override
        public String humanReadableKey() {
            return "javascript.function.kind";
        }
    }
    ,
    MODULE{

        @Override
        public String humanReadableKey() {
            return "javascript.module.kind";
        }
    };


    @NonNls
    public abstract String humanReadableKey();

    public static JSNamedElementKind kind(JSNamedElement element, boolean isLocal) {
        JSNamedElementKind kind = JSNamedElementKind.kind(element);
        if (VAR.equals((Object)kind) || LOCAL_VAR.equals((Object)kind)) {
            return isLocal ? LOCAL_VAR : VAR;
        }
        return kind;
    }

    public static JSNamedElementKind kind(JSNamedElement element) {
        JSNamedElementKind res = null;
        PsiElement parent = JSResolveUtil.findParent((PsiElement)element);
        boolean clazzMember = parent instanceof JSClass;
        if (element instanceof JSVariable) {
            res = element instanceof JSParameter ? PARAMETER : (((JSVariable)element).isConst() ? CONSTANT : (clazzMember ? FIELD : (parent instanceof JSPackageStatement || JSResolveUtil.isFileLocalSymbol((PsiElement)element) ? VAR : LOCAL_VAR)));
        } else if (element instanceof JSFunction) {
            res = clazzMember ? METHOD : FUNCTION;
        } else if (element instanceof JSClass) {
            res = ((JSClass)element).isInterface() ? INTERFACE : CLASS;
        } else if (element instanceof JSNamespaceDeclaration) {
            res = NAMESPACE;
        } else if (element instanceof JSProperty || element instanceof TypeScriptPropertySignature) {
            res = PROPERTY;
        } else if (element instanceof JSDefinitionExpression) {
            res = DEFINITION;
        } else if (element instanceof TypeScriptModule) {
            res = MODULE;
        }
        return res;
    }
}

