/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES7Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceExpressionResolver
implements JSResolveUtil.Resolver<JSReferenceExpressionImpl> {
    private static final Key<CachedValue<Map<String, ResolveResult[]>>> cachedTopResolveKey = Key.create((String)"top.level.cached.results");
    protected final JSReferenceExpressionImpl myRef;
    protected final PsiElement myParent;
    protected final PsiFile myContainingFile;
    protected final String myReferencedName;
    protected final JSExpression myQualifier;
    protected final boolean myLocalResolve;

    public JSReferenceExpressionResolver(JSReferenceExpressionImpl expression, PsiFile file) {
        this.myRef = expression;
        this.myContainingFile = file;
        this.myReferencedName = this.adjustReferencedName(this.myRef);
        this.myParent = this.myRef.getParent();
        this.myQualifier = this.myRef.getResolveQualifier();
        this.myLocalResolve = JSReferenceExpressionImpl.isLocalResolveQualifier(this.myQualifier);
    }

    @Override
    public ResolveResult[] doResolve() {
        ResolveResult[] results;
        SinkResolveProcessor<ResolveResultSink> localProcessor;
        if (this.myReferencedName == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        boolean localResultFound = false;
        PsiElement currentParent = JSResolveUtil.getTopReferenceParent(this.myParent);
        if (JSResolveUtil.isSelfReference(currentParent, (PsiElement)this.myRef)) {
            return new ResolveResult[]{new JSResolveResult(currentParent)};
        }
        if (this.myLocalResolve) {
            localProcessor = new SinkResolveProcessor<ResolveResultSink>(this.myReferencedName, (PsiElement)this.myRef, new ResolveResultSink((PsiElement)this.myRef, this.myReferencedName));
            localProcessor.setToProcessHierarchy(true);
            JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)this.myRef, this.myQualifier, localProcessor, false, false, null);
            PsiElement jsElement = localProcessor.getResult();
            if (!(jsElement == null || jsElement instanceof JSImplicitElement && ((JSImplicitElement)jsElement).hasMinorImportance())) {
                return localProcessor.getResultsAsResolveResults();
            }
            localResultFound = jsElement != null;
        } else {
            QualifiedItemProcessor<ResolveResultSink> processor = this.createQualifiedItemProcessor();
            processor.setTypeContext(true);
            JSTypeEvaluator.evaluateTypes(this.myQualifier, this.myContainingFile, processor);
            ResolveResultSink resultSink = (ResolveResultSink)processor.getResultSink();
            JSResolveResult candidateResult = resultSink.getCandidateResult();
            if (processor.resolved == QualifiedItemProcessor.TypeResolveState.Resolved || processor.resolved == QualifiedItemProcessor.TypeResolveState.Undefined || resultSink.getCompleteResult() != null || candidateResult != null && candidateResult.getResolveProblemKey() != null) {
                return processor.getResultsAsResolveResults();
            }
            localProcessor = processor;
        }
        Map<String, ResolveResult[]> cachedResultsMap = null;
        if (!(this.myQualifier != null || localResultFound || this.myParent instanceof JSDefinitionExpression && !JSResolveUtil.isEcmaScript5((PsiElement)this.myRef) || (results = (cachedResultsMap = JSReferenceExpressionResolver.getCachedTopLevelResultsMap(this.myContainingFile)).get(this.myReferencedName)) == null)) {
            return results;
        }
        results = this.resolveFromIndices(localProcessor);
        if (results.length == 0 && localProcessor.isEncounteredXmlLiteral()) {
            return this.dummyResult(this.myRef);
        }
        if (cachedResultsMap != null) {
            cachedResultsMap.put(this.myReferencedName, results);
        }
        return results;
    }

    @NotNull
    protected QualifiedItemProcessor<ResolveResultSink> createQualifiedItemProcessor() {
        QualifiedItemProcessor<ResolveResultSink> qualifiedItemProcessor = new QualifiedItemProcessor<ResolveResultSink>(new ResolveResultSink((PsiElement)this.myRef, this.myReferencedName), this.myContainingFile);
        if (qualifiedItemProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "createQualifiedItemProcessor"));
        }
        return qualifiedItemProcessor;
    }

    protected ResolveResult[] resolveFromIndices(@NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        if (localProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessor", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "resolveFromIndices"));
        }
        final WalkUpResolveProcessor processor = new WalkUpResolveProcessor(this.myReferencedName, null, this.myContainingFile, (PsiElement)this.myRef, BaseJSSymbolProcessor.MatchMode.Strict);
        PsiElement parent = this.myParent;
        while (parent instanceof JSObjectLiteralExpression || parent instanceof JSArrayLiteralExpression) {
            parent = parent.getParent();
        }
        boolean inDefinition = parent instanceof JSDefinitionExpression;
        this.prepareProcessor(processor, localProcessor);
        JSResolveUtil.tryProcessXmlFileImplicitElements((PsiElement)this.myRef, processor);
        JSResolveUtil.tryProcessAllElementsInInjectedContext(this.myContainingFile, new Processor<JSPsiElementBase>(){

            public boolean process(JSPsiElementBase element) {
                if (JSReferenceExpressionResolver.this.myReferencedName.equals(element.getName())) {
                    processor.doQualifiedCheck(element);
                }
                return true;
            }
        });
        JSReferenceExpressionResolver.processAllSymbols(processor);
        ResolveResult[] results = this.getResultsFromProcessor(processor);
        if (results.length == 0) {
            if (inDefinition) {
                return this.getResultsForDefinition();
            }
            if (processor.getReferencedModule() != null) {
                processor.clearReferencedModule();
                JSReferenceExpressionResolver.processAllSymbols(processor);
                results = processor.getResults();
            }
        }
        return results.length > 20 ? Arrays.copyOfRange(results, 0, 20) : results;
    }

    public static void processAllSymbols(final WalkUpResolveProcessor processor) {
        PsiFile file = processor.getBaseFile();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)file, processor.getReferencedModule());
        final Project project = file.getProject();
        final String name = processor.getRequiredName();
        final ArrayList elementsToProcess = new ArrayList();
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)name, project, scope, JSElement.class, (Processor)new Processor<JSElement>(){

            public boolean process(JSElement element) {
                Collection elements;
                JSElementIndexingData data;
                if (element instanceof JSFunctionExpression || element instanceof ES7Decorator) {
                    return true;
                }
                if (element instanceof JSNamedElement && name.equals(element.getName())) {
                    elementsToProcess.add(element);
                }
                if (element instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)element).getIndexingData()) != null && (elements = data.getImplicitElements()) != null) {
                    for (JSImplicitElement implicitElement : elements) {
                        if (!name.equals(implicitElement.getName())) continue;
                        elementsToProcess.add(implicitElement);
                    }
                }
                return true;
            }
        });
        for (JSElement element : elementsToProcess) {
            if (!processor.acceptsFile(element.getContainingFile())) continue;
            if (element instanceof JSQualifiedNamedElement || element instanceof JSImplicitElement) {
                processor.doQualifiedCheck((JSPsiElementBase)element);
                continue;
            }
            processor.doUnqualifiedCheck((PsiElement)element);
        }
        FileBasedIndex.ValueProcessor<Collection<JSImplicitElementsIndex.JSElementProxy>> implicitElementsProcessor = new FileBasedIndex.ValueProcessor<Collection<JSImplicitElementsIndex.JSElementProxy>>(){

            public boolean process(VirtualFile file, Collection<JSImplicitElementsIndex.JSElementProxy> value) {
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile != null) {
                    for (JSImplicitElementsIndex.JSElementProxy proxy : value) {
                        processor.doQualifiedCheck((JSPsiElementBase)new JSOffsetBasedImplicitElement(proxy.getBuilder(), proxy.getOffset(), psiFile));
                    }
                }
                return true;
            }
        };
        FileBasedIndex.getInstance().processValues(JSImplicitElementsIndex.INDEX_ID, (Object)name, null, (FileBasedIndex.ValueProcessor)implicitElementsProcessor, scope);
    }

    protected ResolveResult[] getResultsFromProcessor(WalkUpResolveProcessor processor) {
        return processor.getResults();
    }

    @Nullable
    protected String adjustReferencedName(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "adjustReferencedName"));
        }
        return ref.getReferenceName();
    }

    protected void prepareProcessor(WalkUpResolveProcessor processor, @NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        if (localProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessor", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "prepareProcessor"));
        }
        boolean allowOnlyCompleteMatches = false;
        boolean searchForDefinitionDefinition = false;
        boolean inDefinition = false;
        if (this.myParent instanceof JSDefinitionExpression) {
            JSExpression qualifier;
            inDefinition = true;
            if (processor.myContext instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)processor.myContext).getQualifier()) != null && !(qualifier instanceof JSThisExpression)) {
                JSType _qualifierType = JSResolveUtil.getExpressionJSType(qualifier);
                searchForDefinitionDefinition = !JSTypeUtils.isNewPropertiesDefinitionAllowed(_qualifierType) || _qualifierType instanceof JSNamedType && ((JSNamedType)_qualifierType).isStaticOrInstance() == JSContext.INSTANCE;
            }
            allowOnlyCompleteMatches = true;
        } else {
            processor.allowPartialResults();
        }
        if (inDefinition || allowOnlyCompleteMatches) {
            processor.setAddOnlyCompleteMatches(allowOnlyCompleteMatches);
        }
        processor.setSkipDefinitions(inDefinition && !searchForDefinitionDefinition);
        processor.addLocalResults(localProcessor);
    }

    protected ResolveResult[] getResultsForDefinition() {
        if (this.myQualifier == null && JSResolveUtil.isEcmaScript5((PsiElement)this.myRef)) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return new ResolveResult[]{new JSResolveResult(this.myParent)};
    }

    protected ResolveResult[] dummyResult(JSReferenceExpression expression) {
        return new ResolveResult[]{new JSResolveResult((PsiElement)expression)};
    }

    private static Map<String, ResolveResult[]> getCachedTopLevelResultsMap(PsiFile containingFile) {
        CachedValue cachedResultsMapCachedValue = (CachedValue)containingFile.getUserData(cachedTopResolveKey);
        if (cachedResultsMapCachedValue == null) {
            cachedResultsMapCachedValue = CachedValuesManager.getManager((Project)containingFile.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, ResolveResult[]>>(){

                public CachedValueProvider.Result<Map<String, ResolveResult[]>> compute() {
                    return new CachedValueProvider.Result(Collections.synchronizedMap(new THashMap()), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
            }, false);
            containingFile.putUserData(cachedTopResolveKey, (Object)cachedResultsMapCachedValue);
        }
        Map cachedResultsMap = (Map)cachedResultsMapCachedValue.getValue();
        return cachedResultsMap;
    }
}

