/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeHelper {
    private static final JSTypeHelper ourTypeHelper = new JSTypeHelper();

    protected JSTypeHelper() {
    }

    public static JSTypeHelper getInstance() {
        return ourTypeHelper;
    }

    public boolean areNamedTypesAssignable(@NotNull JSNamedType lOpType, @NotNull JSNamedType rOpType, ProcessingContext processingContext) {
        if (lOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lOpType", "com/intellij/lang/javascript/psi/resolve/JSTypeHelper", "areNamedTypesAssignable"));
        }
        if (rOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rOpType", "com/intellij/lang/javascript/psi/resolve/JSTypeHelper", "areNamedTypesAssignable"));
        }
        final String lOpQualifiedName = JSTypeUtils.getQualifiedNameMatchingType(lOpType, true);
        String rOpQualifiedName = JSTypeUtils.getQualifiedNameMatchingType(rOpType, true);
        if (lOpQualifiedName == null || rOpQualifiedName == null) {
            return lOpQualifiedName == rOpQualifiedName;
        }
        PsiFile context = rOpType.getSource().getScope();
        if (context == null) {
            return lOpQualifiedName.equals(rOpQualifiedName);
        }
        boolean result = JSTypeEvaluateManager.iterateTypeHierarchy((PsiElement)context, rOpQualifiedName, new JSTypeEvaluateManager.NamespaceProcessor(){
            final Set<String> visited = new THashSet();

            @Override
            public boolean process(String serializedType, VirtualFile file) {
                String qName = JSTypeUtils.getTypeMatchingNamespace(serializedType);
                if (this.visited.add(qName)) {
                    return !lOpQualifiedName.equals(qName);
                }
                return true;
            }
        });
        return !result;
    }

    public boolean isAssignableToNamedType(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @Nullable ProcessingContext processingContext) {
        JSGenericParameterImpl genericParameter;
        if (lOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lOpType", "com/intellij/lang/javascript/psi/resolve/JSTypeHelper", "isAssignableToNamedType"));
        }
        if (rOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rOpType", "com/intellij/lang/javascript/psi/resolve/JSTypeHelper", "isAssignableToNamedType"));
        }
        if ((rOpType instanceof JSPrimitiveFunctionType || rOpType instanceof JSFunctionTypeImpl) && lOpType.inheritsFunction()) {
            return true;
        }
        if (rOpType instanceof JSNamedType) {
            return this.areNamedTypesAssignable(lOpType, (JSNamedType)rOpType, processingContext);
        }
        if (rOpType instanceof JSGenericTypeImpl) {
            return lOpType.isDirectlyAssignableType(((JSGenericTypeImpl)rOpType).getType(), processingContext);
        }
        if (rOpType instanceof JSNullType) {
            return true;
        }
        if (rOpType instanceof JSArrayTypeImpl) {
            return this.isAssignableToNamedType(lOpType, ((JSArrayTypeImpl)rOpType).asGenericType(), processingContext);
        }
        if (rOpType instanceof JSGenericParameterImpl && (genericParameter = (JSGenericParameterImpl)rOpType).getConstraintType() != null) {
            return lOpType.isDirectlyAssignableType(genericParameter, processingContext);
        }
        return false;
    }
}

