/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSSymbolNamespaceImpl;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSVariantRecordTypeConverter;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGlobalTypeImpl;
import com.intellij.lang.javascript.psi.types.JSMixinTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantsProcessor
extends BaseJSSymbolProcessor
implements JSCompletionProcessor {
    private final MultiMap<String, LookupElement> myResults = MultiMap.create();
    private final Set<JSQualifiedName> myNeighbourReferences = new THashSet();
    private final Set<String> myPopulatedResultsNames = new THashSet();
    private boolean myElementFromBestClass;
    private final boolean hasSomeSmartnessAvailable;
    private final boolean myProcessOnlyProperties;
    private boolean weAreInConstructorParameters;
    private final boolean myProcessOnlyTypes;
    private boolean myStrictTypeContext;
    private static final Set<String> ourDynamicClassesWithAnyMatch = new THashSet(Arrays.asList("flash.utils.Proxy", "XML", "XMLList"));
    private final PrefixMatcher myPrefixMatcher = null;
    private String myReferencedParameterName;
    private boolean myStrictlyTyped;
    private final PsiElement myOriginalElement;
    private static final Key<Boolean> ALL_ELEMENTS_ARE_FUNCTIONS = Key.create((String)"js.all.elements.are.functions");
    private static final Key<Boolean> HAS_BOLD_ELEMENT = Key.create((String)"js.has.bold.element");
    private static final Key<Integer> PRIORITY = Key.create((String)"js.several.definitions.element.priority");

    public VariantsProcessor(String[] nameIds, PsiFile targetFile, PsiElement context, BaseJSSymbolProcessor.MatchMode _matchMode) {
        this(nameIds, targetFile, context, _matchMode, false);
    }

    public VariantsProcessor(String[] nameIds, PsiFile targetFile, PsiElement context, BaseJSSymbolProcessor.MatchMode _matchMode, boolean onlyTypeBased) {
        super(targetFile.getOriginalFile(), context, nameIds, _matchMode);
        nameIds = this.myContextNames;
        boolean processOnlyTypes = false;
        this.myCurrentFile = targetFile.getOriginalFile() == targetFile ? null : targetFile.getOriginalFile().getVirtualFile();
        boolean allTypesResolved = false;
        boolean doAddContextIds = true;
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class);
        this.myReferencedParameterName = null;
        if (context instanceof JSReferenceExpression) {
            JSExpression qualifier;
            JSParameterItem parameter;
            JSReferenceExpression refExpr = (JSReferenceExpression)context;
            PsiElement parent = refExpr.getParent();
            if (parent instanceof JSArgumentList && (parameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)refExpr, (JSArgumentList)parent)) != null) {
                this.myReferencedParameterName = parameter.getName();
            }
            if ((qualifier = refExpr.getQualifier()) != null) {
                if (qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) {
                    if (jsClass != null) {
                        this.myAddOnlyCompleteMatchesSet = true;
                        this.myAddOnlyCompleteMatches = true;
                        this.updateCanUseOnlyCompleteMatches(jsClass);
                        doAddContextIds = false;
                    } else if (JSResolveUtil.getTypeFromTagNameInMxml(this.myTargetFile.getContext()) != null) {
                        this.myAddOnlyCompleteMatchesSet = true;
                        this.myAddOnlyCompleteMatches = true;
                    }
                }
                CompletionTypeProcessor processor = new CompletionTypeProcessor();
                JSTypeEvaluator.evaluateTypes(VariantsProcessor.getOriginalQualifier(qualifier), this.myTargetFile, processor);
                allTypesResolved = processor.getAllTypesResolved();
                if (refExpr.getQualifier() instanceof JSCallExpression) {
                    doAddContextIds = false;
                }
                if (this.myStrictlyTyped || onlyTypeBased) {
                    this.myAddOnlyCompleteMatchesSet = true;
                    this.myAddOnlyCompleteMatches = true;
                }
            } else {
                boolean strictTypeContext = JSResolveUtil.isExprInTypeContext(refExpr);
                if (strictTypeContext || this.ecmal4 && JSResolveUtil.isInPlaceWhereTypeCanBeDuringCompletion((PsiElement)refExpr)) {
                    this.myAddOnlyCompleteMatchesSet = true;
                    this.myAddOnlyCompleteMatches = true;
                    processOnlyTypes = true;
                    this.myStrictTypeContext = strictTypeContext;
                    allTypesResolved = true;
                    this.addPackageScope(jsClass, (PsiElement)refExpr);
                }
            }
        } else if (context instanceof JSProperty) {
            JSRecordType recordType;
            JSType value;
            JSObjectLiteralExpression objLiteral = (JSObjectLiteralExpression)context.getParent();
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)objLiteral);
            if (expectedType instanceof JSTypeImpl && expectedType.getSource().getLanguage() == JSTypeSource.SourceLanguage.JS && expectedType.getSource().isExplicitlyDeclared() && (value = JSTypeEvaluateManager.expandTypedefs((PsiElement)expectedType.getSource().getScope(), expectedType.getResolvedTypeText())) != null) {
                expectedType = value;
            }
            if ((recordType = JSVariantRecordTypeConverter.getTypeAsRecord(expectedType, context)) != null) {
                this.myTypeInfo.addRecordType((JSRecordTypeImpl)recordType);
                this.myAddOnlyCompleteMatchesSet = true;
                this.myAddOnlyCompleteMatches = true;
            }
        }
        if (nameIds != null && nameIds.length > 0 && (!allTypesResolved || this.myTypeInfo.typeAllowAnyProperties()) && doAddContextIds) {
            String join = StringUtil.join((String[])nameIds, (String)".");
            this.buildIndexListFromQNameAndCorrectQName(join);
            if (!this.myTypeInfo.onlyInstanceAccess()) {
                this.addSupers(join, new JSEvaluateContext(targetFile), JSContext.UNKNOWN);
            }
        }
        this.myProcessOnlyTypes = processOnlyTypes;
        boolean bl = this.myProcessOnlyProperties = context instanceof JSProperty && !this.weAreInConstructorParameters;
        if (this.myTypeInfo.typeWasProcessed() && !this.weAreInConstructorParameters && !this.myProcessOnlyProperties) {
            this.myTypeInfo.addBaseObjectType();
        }
        this.hasSomeSmartnessAvailable = this.myTypeInfo.hasExplicitNamespace();
        this.myOriginalElement = CompletionUtil.getOriginalElement((PsiElement)context);
        this.initCheckFileLevelAccess();
    }

    @Override
    protected String addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "addNamespace"));
        }
        if (this.weAreInConstructorParameters) {
            JSParameterItem matchedParameter;
            PsiElement grandParent;
            JSQualifiedName qualifiedName = namespace.getQualifiedName();
            qualifiedName = JSQualifiedNameImpl.create("options", qualifiedName);
            namespace = new JSNamespaceImpl(qualifiedName, namespace.getJSContext(), namespace.isExplicitlyDeclared());
            PsiElement parent = this.myContext.getParent();
            if (parent instanceof JSExpression && (grandParent = parent.getParent()) instanceof JSArgumentList && (matchedParameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)parent, (JSArgumentList)grandParent)) != null && matchedParameter.getName() != null) {
                qualifiedName = JSQualifiedNameImpl.create(matchedParameter.getName(), qualifiedName);
                JSNamespaceImpl paramNs = new JSNamespaceImpl(qualifiedName, namespace.getJSContext(), namespace.isExplicitlyDeclared());
                super.addNamespace(paramNs, isTopClassInHierarchy);
            }
        }
        return super.addNamespace(namespace, isTopClassInHierarchy);
    }

    private void updateCanUseOnlyCompleteMatchesFromString(String qName, Object source, PsiElement clazz) {
        boolean wasSet = this.myAddOnlyCompleteMatchesSet;
        if (this.myAddOnlyCompleteMatches || !wasSet) {
            this.myAddOnlyCompleteMatchesSet = true;
            if (qName.equals("*") || qName.equals("Object") && (this.myIteratedTypeName == null || qName.equals(this.myIteratedTypeName) || this.myContextNames != null && this.myContextNames.length > 0 && this.myIteratedTypeName.equals(this.myContextNames[this.myContextNames.length - 1]) && this.myContext instanceof JSReferenceExpression && ((JSReferenceExpression)this.myContext).getQualifier() instanceof JSReferenceExpression) || qName.equals("Function") && VariantsProcessor.isObjectSourceThatDoesNotGiveExactKnowledgeAboutFunctionType(source)) {
                this.myAddOnlyCompleteMatches = false;
            } else {
                if (clazz == null) {
                    clazz = JSDialectSpecificHandlersFactory.forElement(this.myContext).getClassResolver().findClassByQName(qName, this.myContext);
                }
                if (clazz instanceof JSClass) {
                    JSAttributeList attributeList;
                    if (!wasSet) {
                        this.myAddOnlyCompleteMatches = true;
                    }
                    if ((attributeList = ((JSClass)clazz).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC) && ourDynamicClassesWithAnyMatch.contains(qName)) {
                        this.myAddOnlyCompleteMatches = false;
                    }
                }
            }
        }
    }

    private static boolean isObjectSourceThatDoesNotGiveExactKnowledgeAboutFunctionType(Object source) {
        return source instanceof JSFunctionExpression;
    }

    private void updateCanUseOnlyCompleteMatches(JSClass jsClass) {
        JSAttributeList attributeList;
        JSAttributeList jSAttributeList = attributeList = jsClass != null ? jsClass.getAttributeList() : null;
        if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC)) {
            this.myAddOnlyCompleteMatches = false;
        }
    }

    public void populateCompletionList(Collection<? extends LookupElement> resultsAsObjects, boolean addResults) {
        boolean production;
        if (resultsAsObjects == null) {
            return;
        }
        THashSet processedCandidateNames = new THashSet(resultsAsObjects.size());
        CompletionResultSet completionResultSet = JSCompletionContributor.getInstance().getCompletionResultSet();
        boolean bl = production = !ApplicationManager.getApplication().isHeadlessEnvironment();
        if (!production) {
            completionResultSet = null;
        }
        for (LookupElement lookupElement : resultsAsObjects) {
            String qName;
            LookupItem item;
            Object object;
            if (completionResultSet != null) {
                completionResultSet.addElement(lookupElement);
            }
            if (!(lookupElement instanceof LookupItem) || !((object = (item = (LookupItem)lookupElement).getObject()) instanceof PsiNamedElement)) continue;
            PsiNamedElement namedElement = (PsiNamedElement)object;
            String name = ResolveProcessor.getName((PsiElement)namedElement);
            String string = qName = namedElement instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)namedElement).getQualifiedName() : name;
            if (!this.typescript && processedCandidateNames.contains(qName)) continue;
            processedCandidateNames.add(qName);
            this.myPopulatedResultsNames.add(name);
            if (!addResults) continue;
            BaseJSSymbolProcessor.MatchType matchType = item.getPriority() == 5.0 ? BaseJSSymbolProcessor.MatchType.COMPLETE : BaseJSSymbolProcessor.MatchType.COMPLETE_NS;
            this.addCompleteMatch(item, name, matchType);
        }
    }

    public void collectReferencesUsedInCurrentScope(final PsiElement reference, final boolean qualified) {
        JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)reference, JSExecutionScope.class);
        assert (scope != null) : reference.getContainingFile().getName();
        new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSQualifiedName name;
                if (node != reference && node.getQualifier() != null == qualified && (name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)node)) != null) {
                    VariantsProcessor.this.myNeighbourReferences.add(name);
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
            }
        }.visitElement((PsiElement)scope);
    }

    @Override
    protected boolean isStrictTypingPossible(PsiElement source, JSType type) {
        if (type.getSource().isExplicitlyDeclared()) {
            source = JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT;
        }
        return super.isStrictTypingPossible(source, type);
    }

    private void addSupers(@NotNull String type, JSEvaluateContext context, JSContext staticOrInstance) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "addSupers"));
        }
        this.addSupers(new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedName(type), staticOrInstance, true), context);
    }

    private void addSupers(@NotNull JSNamespace namespace, final JSEvaluateContext context) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "addSupers"));
        }
        JSQualifiedName qualifiedName = namespace.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        String type = qualifiedName.getQualifiedName();
        JSContext jsContext = namespace.getJSContext();
        String iteratedType = this.myIteratedTypeName;
        if (jsContext == JSContext.STATIC) {
            type = JSNamedType.appendStaticSuffix(type);
        }
        this.myIteratedTypeName = type;
        SmartList parentClasses = new SmartList();
        this.doIterateHierarchy(type, new BaseJSSymbolProcessor.HierarchyProcessor((List)parentClasses, jsContext){
            final /* synthetic */ List val$parentClasses;
            final /* synthetic */ JSContext val$jsContext;
            {
                this.val$parentClasses = list;
                this.val$jsContext = jSContext;
            }

            @Override
            public boolean processNamespace(String type, VirtualFile file) {
                JSType baseType = JSTypeUtils.createType(type, JSTypeSource.EMPTY);
                if (baseType instanceof JSObjectType || baseType == null) {
                    return true;
                }
                String qName = JSTypeUtils.getQualifiedNameMatchingType(baseType, false);
                if (qName != null && !context.ensureProcessed(qName)) {
                    VariantsProcessor.this.updateCanUseOnlyCompleteMatchesFromString(qName, qName, null);
                    JSContext jsContext = baseType instanceof JSNamedType ? ((JSNamedType)baseType).isStaticOrInstance() : JSContext.UNKNOWN;
                    JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedName(qName), jsContext, true);
                    this.val$parentClasses.add(namespace);
                }
                return true;
            }

            @Override
            public boolean processClass(JSClass clazz) {
                String qname = clazz.getQualifiedName();
                if ("Object".equals(qname)) {
                    return true;
                }
                if (!context.ensureProcessed(qname)) {
                    VariantsProcessor.this.updateCanUseOnlyCompleteMatchesFromString(qname, clazz, (PsiElement)clazz);
                    if (qname != null) {
                        JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedName(qname), this.val$jsContext, true);
                        this.val$parentClasses.add(namespace);
                    }
                }
                return true;
            }

            @Override
            public boolean processObjectLiteral(JSObjectLiteralExpression objectLiteral) {
                VariantsProcessor.this.myTypeInfo.addBaseObjectLiteral(objectLiteral);
                return true;
            }
        });
        this.myIteratedTypeName = iteratedType;
        for (JSNamespace parentClass : parentClasses) {
            this.addNamespace(parentClass, false);
        }
        JSTypeSubstitutor genericArguments = (JSTypeSubstitutor)namespace.getUserData(JSNamespace.GENERIC_ARGUMENTS_KEY);
        if (genericArguments != null && !genericArguments.isEmpty()) {
            for (JSNamespace parentClass : parentClasses) {
                JSQualifiedName parentClassQName = parentClass.getQualifiedName();
                assert (parentClassQName != null);
                JSTypeSubstitutor parentClassTypeSubstitutor = JSGenericTypesEvaluator.applyTypeSubstitutorUpToParentClass(qualifiedName.getQualifiedName(), parentClassQName.getQualifiedName(), this.myContext, genericArguments);
                parentClass.putUserData(JSNamespace.GENERIC_ARGUMENTS_KEY, (Object)parentClassTypeSubstitutor);
            }
        }
    }

    private void addNeighbourReferences() {
        for (JSQualifiedName neighbourReference : this.myNeighbourReferences) {
            if (!this.myTypeInfo.hasMatchedNamespace(neighbourReference.getParent(), JSContext.STATIC)) continue;
            String name = neighbourReference.getName();
            Collection elements = this.myResults.get((Object)name);
            if (elements.isEmpty()) {
                LookupElement element = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)name), (double)7.0);
                this.myResults.putValue((Object)name, (Object)element);
                continue;
            }
            for (LookupElement element : elements) {
                if (!(element instanceof LookupItem)) continue;
                double newPriority = Math.max(((LookupItem)element).getPriority(), 7.0);
                ((LookupItem)element).setPriority(newPriority);
            }
        }
    }

    private void buildSeveralDefinitionsElements() {
        for (Map.Entry entry : this.myResults.entrySet()) {
            Boolean function;
            Integer priority;
            Collection value = (Collection)entry.getValue();
            LookupElement element = value.isEmpty() ? null : (LookupElement)value.iterator().next();
            if (!(element instanceof LookupElementBuilder) || (priority = (Integer)element.getUserData(PRIORITY)) == null) continue;
            LookupElementBuilder lookupItem = (LookupElementBuilder)element;
            Boolean bold = (Boolean)element.getUserData(HAS_BOLD_ELEMENT);
            if (bold != null && bold.booleanValue()) {
                lookupItem = lookupItem.withBoldness(true);
            }
            if ((function = (Boolean)element.getUserData(ALL_ELEMENTS_ARE_FUNCTIONS)) != null && function.booleanValue()) {
                lookupItem = lookupItem.withInsertHandler(JSInsertHandler.FUNCTION_INSERT_HANDLER).withTailText("()");
            }
            entry.setValue(Collections.singleton(PrioritizedLookupElement.withPriority((LookupElement)lookupItem, (double)priority.intValue())));
        }
    }

    private void addResult(@NotNull String name, LookupElement element) {
        LookupElement firstStoredElement;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "addResult"));
        }
        Collection elements = this.myResults.get((Object)name);
        LookupElement lookupElement = firstStoredElement = elements.isEmpty() ? null : (LookupElement)elements.iterator().next();
        if (firstStoredElement == null) {
            this.myResults.putValue((Object)name, (Object)element);
        } else if (element instanceof LookupItem || element instanceof PrioritizedLookupElement) {
            double storedItemPriority;
            double itemPriority;
            boolean keepCompleteMatchedOverloads = this.typescript;
            double d = itemPriority = element instanceof LookupItem ? ((LookupItem)element).getPriority() : ((PrioritizedLookupElement)element).getPriority();
            if (keepCompleteMatchedOverloads && VariantsProcessor.wasCompleteMatch(itemPriority)) {
                this.myResults.putValue((Object)name, (Object)element);
                return;
            }
            PsiElement lookupItemElement = element.getPsiElement();
            PsiElement storedLookupItemElement = firstStoredElement.getPsiElement();
            if (firstStoredElement instanceof LookupItem) {
                storedItemPriority = ((LookupItem)firstStoredElement).getPriority();
            } else if (firstStoredElement instanceof PrioritizedLookupElement) {
                storedItemPriority = ((PrioritizedLookupElement)firstStoredElement).getPriority();
            } else {
                Integer data = (Integer)firstStoredElement.getUserData(PRIORITY);
                double d2 = storedItemPriority = data != null ? (double)data.intValue() : 0.0;
            }
            if (itemPriority == storedItemPriority) {
                boolean storedIsProperty;
                boolean currentIsProperty = lookupItemElement instanceof JSProperty && ((JSProperty)lookupItemElement).tryGetFunctionInitializer() != null;
                boolean bl = storedIsProperty = storedLookupItemElement instanceof JSProperty && ((JSProperty)storedLookupItemElement).tryGetFunctionInitializer() != null;
                if (currentIsProperty && !storedIsProperty) {
                    storedItemPriority -= 1.0;
                } else if (!currentIsProperty && storedIsProperty) {
                    itemPriority -= 1.0;
                }
            }
            if (itemPriority == storedItemPriority) {
                boolean itemIsBold;
                boolean bl = itemIsBold = element instanceof LookupItem && ((LookupItem)element).isBold();
                if (firstStoredElement instanceof LookupItem) {
                    LookupElementBuilder mergedElement = LookupElementBuilder.create((String)name).withTypeText(JSBundle.message((String)"javascript.completion.several.definitions", (Object[])new Object[0]), true);
                    mergedElement.putUserData(PRIORITY, (Object)((int)itemPriority));
                    mergedElement.putUserData(HAS_BOLD_ELEMENT, (Object)(itemIsBold || ((LookupItem)firstStoredElement).isBold() ? 1 : 0));
                    boolean bothAreFunctions = JSPsiImplUtils.getPossibleFunction(lookupItemElement) != null && JSPsiImplUtils.getPossibleFunction(storedLookupItemElement) != null;
                    mergedElement.putUserData(ALL_ELEMENTS_ARE_FUNCTIONS, (Object)bothAreFunctions);
                    this.myResults.remove((Object)name);
                    this.myResults.putValue((Object)name, (Object)mergedElement);
                } else if (storedLookupItemElement == null) {
                    if (firstStoredElement.getUserData(ALL_ELEMENTS_ARE_FUNCTIONS) == Boolean.TRUE && JSPsiImplUtils.getPossibleFunction(lookupItemElement) == null) {
                        firstStoredElement.putUserData(ALL_ELEMENTS_ARE_FUNCTIONS, (Object)Boolean.FALSE);
                    }
                    if (firstStoredElement.getUserData(HAS_BOLD_ELEMENT) != Boolean.TRUE && itemIsBold) {
                        firstStoredElement.putUserData(HAS_BOLD_ELEMENT, (Object)Boolean.TRUE);
                    }
                }
            } else if (itemPriority > storedItemPriority) {
                this.myResults.remove((Object)name);
                this.myResults.putValue((Object)name, (Object)element);
            }
        } else {
            this.myResults.putValue((Object)name, (Object)element);
        }
    }

    static boolean wasCompleteMatch(double priority) {
        return priority > 5.0;
    }

    public List<LookupElement> getResults(String qualifiedNameToSkip) {
        this.addNeighbourReferences();
        this.buildSeveralDefinitionsElements();
        ArrayList<LookupElement> results = new ArrayList<LookupElement>(this.myResults.size());
        for (LookupElement element : this.myResults.values()) {
            VariantsProcessor.addVariant(qualifiedNameToSkip, results, element);
        }
        return results;
    }

    private static void addVariant(String qualifiedNameToSkip, List<LookupElement> results, LookupElement o) {
        if (qualifiedNameToSkip == null || !qualifiedNameToSkip.equals(o.getLookupString())) {
            results.add(o);
        }
    }

    public Collection<? extends LookupElement> getResultsAsElements() {
        List<LookupElement> recordTypesElements = this.createElementsFromRecordTypes();
        for (LookupElement recordTypesElement : recordTypesElements) {
            this.addResult(recordTypesElement.getLookupString(), recordTypesElement);
        }
        this.addNeighbourReferences();
        this.buildSeveralDefinitionsElements();
        ArrayList result = new ArrayList(this.myResults.values());
        return result;
    }

    @NotNull
    private List<LookupElement> createElementsFromRecordTypes() {
        if (this.myTypeInfo.myRecordTypes == null) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "createElementsFromRecordTypes"));
            }
            return list;
        }
        SmartList result = new SmartList();
        for (JSRecordTypeImpl recordType : this.myTypeInfo.myRecordTypes) {
            Collection elements;
            JSElementIndexingData indexingData;
            PsiElement element = recordType.getSource().getSourceElement();
            THashMap implicitElements = new THashMap();
            if (element instanceof JSImplicitElementProvider && (indexingData = ((JSImplicitElementProvider)element).getIndexingData()) != null && (elements = indexingData.getImplicitElements()) != null) {
                for (JSImplicitElement implicitElement : elements) {
                    JSQualifiedName parentNamespace;
                    JSQualifiedName namespace = implicitElement.getNamespace();
                    if (namespace == null || (parentNamespace = namespace.getParent()) == null || !"options".equals(parentNamespace.getName())) continue;
                    implicitElements.put(implicitElement.getName(), implicitElement);
                }
            }
            for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
                if (!(member instanceof JSRecordTypeImpl.PropertySignature)) continue;
                String name = ((JSRecordTypeImpl.PropertySignature)member).getName();
                JSType type = ((JSRecordTypeImpl.PropertySignature)member).getType();
                String typeString = type != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : null;
                PsiElement sourceElement = (PsiElement)implicitElements.get(name);
                if (sourceElement == null) {
                    sourceElement = element;
                }
                LookupElementBuilder builder = LookupElementBuilder.create((Object)(sourceElement != null ? sourceElement : name), (String)name).withBoldness(true).withTypeText(typeString);
                result.add(PrioritizedLookupElement.withPriority((LookupElement)builder, (double)5.0));
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "createElementsFromRecordTypes"));
        }
        return smartList;
    }

    @NotNull
    public Collection<? extends LookupElement> getCurrentResultsAsIs() {
        Collection collection = this.myResults.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "getCurrentResultsAsIs"));
        }
        return collection;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "execute"));
        }
        if (element instanceof JSNamedElement) {
            JSNamedElement namedElement = (JSNamedElement)element;
            this.addCompleteMatch(namedElement, namedElement.getName(), BaseJSSymbolProcessor.MatchType.COMPLETE);
        }
        return true;
    }

    @Override
    public String getRequiredName() {
        return null;
    }

    @Override
    public void doAdd(@NotNull JSPsiElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "doAdd"));
        }
        this.doAdd(element, null);
    }

    public void doAdd(@NotNull JSPsiElementBase element, @Nullable JSTypeSubstitutor typeSubstitutor) {
        Ref typeHierarchyLevel;
        BaseJSSymbolProcessor.MatchType matchType;
        JSDocComment comment;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "doAdd"));
        }
        String name = element.getName();
        JSQualifiedName namespace = element.getNamespace();
        JSAttributeList.AccessType accessType = element.getAccessType();
        if (name == null || !BasicJavascriptNamesValidator.isUnqualifiedType(name)) {
            return;
        }
        if (element.isEquivalentTo(this.myOriginalElement)) {
            return;
        }
        if (this.myPopulatedResultsNames.contains(name)) {
            return;
        }
        if (this.isAcceptable(element) != null) {
            return;
        }
        boolean seemsToBePrivateSymbol = VariantsProcessor.seemsToBePrivateSymbol(name);
        boolean isClassMember = element.getParent() instanceof JSClass;
        if (isClassMember && element instanceof JSFunction && ((JSFunction)element).isConstructor()) {
            return;
        }
        if (element instanceof JSProperty && (comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element)) != null && comment.hasConstructsTag()) {
            return;
        }
        if (seemsToBePrivateSymbol && accessType == JSAttributeList.AccessType.PACKAGE_LOCAL) {
            accessType = JSAttributeList.AccessType.PRIVATE;
        }
        if (isClassMember && accessType == JSAttributeList.AccessType.PRIVATE) {
            return;
        }
        boolean fromTheSameFile = this.myCurrentFile.equals(this.myTargetVirtualFile);
        boolean elementIsVisible = JSVisibilityUtil.isAccessible(namespace, (PsiElement)element, accessType, this.getContextScopeNames(), this.myContext, fromTheSameFile);
        if (element instanceof JSClass && !elementIsVisible) {
            return;
        }
        if (this.myProcessOnlyProperties && (element instanceof JSImplicitElement ? ((JSImplicitElement)element).getType() != JSImplicitElement.Type.Property : !(element instanceof JSProperty) && !(element instanceof JSDefinitionExpression))) {
            return;
        }
        if (this.myProcessOnlyTypes && this.ecmal4) {
            boolean nonAcceptableItem;
            boolean bl = nonAcceptableItem = !(element instanceof JSClass) && !(element instanceof JSPackage) || "Arguments".equals(element.getName());
            if (nonAcceptableItem && !this.myStrictTypeContext) {
                boolean bl2 = nonAcceptableItem = isClassMember || !(element instanceof JSFunction) && !(element instanceof JSVariable);
            }
            if (nonAcceptableItem) {
                return;
            }
        }
        if ((matchType = this.isAcceptableQualifiedItem(element, (Ref<Integer>)(typeHierarchyLevel = new Ref((Object)0)))) == BaseJSSymbolProcessor.MatchType.COMPLETE && !this.ecmal4 && this.myProcessOnlyTypes) {
            boolean lowerCasedSymbol;
            boolean bl = lowerCasedSymbol = !name.isEmpty() && Character.isLowerCase(name.charAt(0));
            if (lowerCasedSymbol) {
                if (!(element instanceof JSImplicitElement && ((JSImplicitElement)element).getType().providesNamespace() || element instanceof JSFunction)) {
                    matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
                }
            } else if (accessType == JSAttributeList.AccessType.PRIVATE) {
                matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
            }
        }
        boolean addPartial = true;
        if (matchType == BaseJSSymbolProcessor.MatchType.PARTIAL && this.myPrefixMatcher != null) {
            boolean bl = addPartial = !this.myPrefixMatcher.getPrefix().isEmpty() && this.myPrefixMatcher.prefixMatches(name);
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_PREDEFINED && !elementIsVisible) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.PARTIAL || !elementIsVisible && matchType == BaseJSSymbolProcessor.MatchType.COMPLETE) {
            if (addPartial) {
                this.addPartialMatch((PsiElement)element, name);
            }
        } else if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE || matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_PREDEFINED) {
            this.addCompleteMatch(element, name, matchType, (Integer)typeHierarchyLevel.get(), typeSubstitutor);
        }
    }

    public static boolean seemsToBePrivateSymbol(@Nullable String name) {
        return name != null && !name.isEmpty() && (name.charAt(0) == '_' || name.charAt(name.length() - 1) == '_');
    }

    private LookupElement addLookupValue(PsiElement _element, String name, BaseJSSymbolProcessor.MatchType matchType, Boolean fromRelevantFileOrDirectory, Boolean hasSomeSmartnessAvailable) {
        int priorityValue = LookupPriority.getValue(matchType, fromRelevantFileOrDirectory, hasSomeSmartnessAvailable);
        return this.addLookupValue(_element, name, priorityValue, null);
    }

    private LookupElement addLookupValue(PsiElement _element, String name, boolean fromRelevantFileOrDirectory, boolean hasSomeSmartnessAvailable) {
        return this.addLookupValue(_element, name, null, fromRelevantFileOrDirectory, hasSomeSmartnessAvailable);
    }

    @Nullable
    private LookupElement addLookupValue(PsiElement element, String name, int priorityValue, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (!JSLookupUtilImpl.willCreateLookupElement(priorityValue)) {
            return null;
        }
        LookupItem<Object> lookupItem = JSLookupUtilImpl.createPrioritizedLookupItem(element, name, priorityValue, this.myElementFromBestClass, this.ecmal4, typeSubstitutor);
        return lookupItem;
    }

    @Override
    protected JSSymbolNamespace calculateContextNames(JSElement element) {
        JSExpression methodExpr;
        PsiElement grandGrandParent;
        PsiElement grandParent;
        if (element instanceof JSProperty && (grandParent = element.getParent().getParent()) instanceof JSArgumentList && (grandGrandParent = grandParent.getParent()) instanceof JSCallExpression && (methodExpr = ((JSCallExpression)grandGrandParent).getMethodExpression()) instanceof JSReferenceExpression) {
            ArrayList<String> names = new ArrayList<String>(3);
            JSElement qualifyingExpression = JSSymbolUtil.getFirstLiteralOrExprArg((JSArgumentList)grandParent);
            String method = qualifyingExpression != null ? StringUtil.stripQuotesAroundValue((String)qualifyingExpression.getText()) : methodExpr.getText();
            BaseJSSymbolProcessor.addIndexListFromQName(method, names);
            this.weAreInConstructorParameters = true;
            return new JSSymbolNamespaceImpl(JSQualifiedNameImpl.fromComponents(names), JSContext.UNKNOWN, true, true);
        }
        if (element instanceof JSReferenceExpression) {
            return JSResolveUtil.buildNamespaceForQualifier(JSResolveUtil.getRealRefExprQualifier((JSReferenceExpression)element));
        }
        return null;
    }

    private void addCompleteMatch(Object _element, String name, BaseJSSymbolProcessor.MatchType matchType) {
        this.addCompleteMatch(_element, name, matchType, 0, null);
    }

    private void addCompleteMatch(Object _element, String name, BaseJSSymbolProcessor.MatchType matchType, int nestingLevel, JSTypeSubstitutor typeSubstitutor) {
        LookupItem o;
        if (name == null) {
            return;
        }
        if (_element instanceof LookupItem) {
            o = (LookupItem)_element;
        } else {
            int priority = LookupPriority.getSameTypeValue(name.equals(this.myReferencedParameterName), matchType, nestingLevel);
            PsiElement element = this.updateElement(_element);
            o = this.addLookupValue(element, name, priority, typeSubstitutor);
        }
        if (o != null) {
            this.addResult(name, (LookupElement)o);
        }
    }

    @NotNull
    private PsiElement updateElement(Object _element) {
        Object element;
        if (_element instanceof PsiElement) {
            element = (PsiElement)_element;
        } else {
            String name = _element instanceof JSQualifiedName ? ((JSQualifiedName)_element).getName() : (String)_element;
            JSQualifiedName namespace = _element instanceof JSQualifiedName ? ((JSQualifiedName)_element).getParent() : null;
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, (PsiElement)this.myTargetFile).setNamespace(namespace).setProperties(JSImplicitElement.Property.MinorImportance);
            element = new JSImplicitElementImpl(builder);
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "updateElement"));
        }
        return psiElement;
    }

    private void addPartialMatch(PsiElement _element, String name) {
        boolean fromRelevantFileOrDirectory;
        if (this.myAddOnlyCompleteMatches) {
            return;
        }
        if (name == null) {
            return;
        }
        PsiElement element = this.updateElement(_element);
        LookupElement o = this.addLookupValue(element, name, fromRelevantFileOrDirectory = this.isFromRelevantFileOrDirectory(), this.hasSomeSmartnessAvailable);
        if (o != null) {
            this.addResult(name, o);
        }
    }

    private BaseJSSymbolProcessor.MatchType isAcceptableQualifiedItem(JSPsiElementBase element, Ref<Integer> typeHierarchyLevel) {
        PsiElement parent = element.getParent();
        JSQualifiedName namespace = this.ecmal4 && parent instanceof JSClass ? JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)((JSClass)parent)) : element.getNamespace();
        boolean namespaceExplicitlyDeclared = element.isNamespaceExplicitlyDeclared();
        this.myElementFromBestClass = false;
        boolean globalNs = this.isGlobalNS(namespace, true);
        if (globalNs && !Comparing.equal((Object)this.myTargetVirtualFile, (Object)this.myCurrentFile) && element.getAccessType() == JSAttributeList.AccessType.PRIVATE) {
            return BaseJSSymbolProcessor.MatchType.NOMATCH;
        }
        if (namespaceExplicitlyDeclared && globalNs && this.myMatchMode == BaseJSSymbolProcessor.MatchMode.Strict) {
            if (this.myGlobalStatusHint == BaseJSSymbolProcessor.GlobalStatusHint.GLOBAL) {
                if (this.myOnlyExportedItems) {
                    this.myElementFromBestClass = true;
                    return BaseJSSymbolProcessor.MatchType.COMPLETE;
                }
                return this.myProcessOnlyTypes ? BaseJSSymbolProcessor.MatchType.COMPLETE : BaseJSSymbolProcessor.MatchType.COMPLETE_PREDEFINED;
            }
            if (this.myGlobalStatusHint == BaseJSSymbolProcessor.GlobalStatusHint.NONGLOBAL) {
                return BaseJSSymbolProcessor.MatchType.NOMATCH;
            }
        }
        if (this.myMatchMode == BaseJSSymbolProcessor.MatchMode.Any && this.myTypeInfo.isEmpty() || this.myGlobalStatusHint == BaseJSSymbolProcessor.GlobalStatusHint.GLOBAL) {
            return globalNs && namespaceExplicitlyDeclared ? BaseJSSymbolProcessor.MatchType.COMPLETE : (globalNs || this.myGlobalStatusHint != BaseJSSymbolProcessor.GlobalStatusHint.GLOBAL ? BaseJSSymbolProcessor.MatchType.PARTIAL : BaseJSSymbolProcessor.MatchType.NOMATCH);
        }
        if (namespace == null) {
            return namespaceExplicitlyDeclared ? BaseJSSymbolProcessor.MatchType.NOMATCH : BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        JSContext elementStaticOrInstance = element.getJSContext();
        boolean contextMismatched = false;
        for (int level = 0; level < this.myTypeInfo.myContextLevels.size(); ++level) {
            BaseJSSymbolProcessor.TypeInfo.ContextLevel contextLevel = this.myTypeInfo.myContextLevels.get(level);
            boolean completeMatch = true;
            JSQualifiedName currentNs = namespace;
            for (JSQualifiedName currentContextNamespace = contextLevel.myNamespace.getQualifiedName(); currentContextNamespace != null; currentContextNamespace = currentContextNamespace.getParent()) {
                if (currentNs == null || !currentContextNamespace.getName().equals(currentNs.getName())) {
                    completeMatch = false;
                    break;
                }
                currentNs = currentNs.getParent();
            }
            if (!completeMatch || currentNs == namespace || !this.isGlobalNS(currentNs, true) || this.myAddOnlyCompleteMatches && currentNs != null || contextLevel.myNamespace.getQualifiedName() != null && contextLevel.myNamespace.getQualifiedName().getParent() == null && currentNs != null) continue;
            if (!contextLevel.myNamespace.getJSContext().isCompatibleWith(elementStaticOrInstance)) {
                contextMismatched = true;
                continue;
            }
            if (contextMismatched && contextLevel.myNamespace.getJSContext() == JSContext.UNKNOWN) continue;
            int relativeLevel = contextLevel.myRelativeLevel;
            typeHierarchyLevel.set((Object)relativeLevel);
            if (relativeLevel == 0) {
                this.myElementFromBestClass = true;
            }
            return relativeLevel == 0 ? BaseJSSymbolProcessor.MatchType.COMPLETE : BaseJSSymbolProcessor.MatchType.COMPLETE_PREDEFINED;
        }
        return contextMismatched ? BaseJSSymbolProcessor.MatchType.NOMATCH : BaseJSSymbolProcessor.MatchType.PARTIAL;
    }

    public static class LookupPriority {
        public static final int LOCAL_SCOPE_MAX_PRIORITY = 100;
        public static final int SMART_PROPRITY = 101;
        public static final int RELEVANT_NO_SMARTNESS_PRIORITY = 4;
        public static final int NO_RELEVANT_NO_SMARTNESS_PRIORITY = 2;
        public static final int RELEVANT_SMARTNESS_PRIORITY = 1;
        public static final int NO_RELEVANT_SMARTNESS_PRIORITY = 0;

        public static int getSameFileValue(boolean matchesReferencedParameterName, int nestingLevel) {
            if (matchesReferencedParameterName) {
                return 101;
            }
            if (nestingLevel < 0) {
                return 2;
            }
            return Math.max(5, 100 - nestingLevel);
        }

        public static int getValue(BaseJSSymbolProcessor.MatchType matchType, Boolean fromRelevantFileOrDirectory, Boolean hasSomeSmartnessAvailable) {
            if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE) {
                return 100;
            }
            if (Boolean.TRUE.equals(fromRelevantFileOrDirectory) && Boolean.FALSE.equals(hasSomeSmartnessAvailable)) {
                return 4;
            }
            if (Boolean.FALSE.equals(fromRelevantFileOrDirectory) && Boolean.FALSE.equals(hasSomeSmartnessAvailable)) {
                return 2;
            }
            if (Boolean.TRUE.equals(fromRelevantFileOrDirectory) && Boolean.TRUE.equals(hasSomeSmartnessAvailable)) {
                return 1;
            }
            if (Boolean.FALSE.equals(fromRelevantFileOrDirectory) && Boolean.TRUE.equals(hasSomeSmartnessAvailable)) {
                return 0;
            }
            return 2;
        }

        public static int getSameTypeValue(boolean matchesReferencedParameterName, BaseJSSymbolProcessor.MatchType matchType, int nestingLevel) {
            if (matchesReferencedParameterName && (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE || matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_PREDEFINED)) {
                return 101;
            }
            if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE) {
                return 100;
            }
            if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_PREDEFINED && nestingLevel > 0) {
                return 100 - nestingLevel;
            }
            return 2;
        }

        public static int getSmartVariantPriority(boolean matchesReferencedParameterName) {
            return matchesReferencedParameterName ? 6 : 5;
        }

        public static int getTopLevelSymbolsFromOtherFilesValue() {
            return 5;
        }
    }

    class CompletionTypeProcessor
    extends BaseJSSymbolProcessor.TypeProcessorBase {
        private PsiElement myUnknownElement;

        CompletionTypeProcessor() {
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext context, PsiElement source) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor", "process"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor", "process"));
            }
            if (context.ensureProcessed(type.getTypeText(JSType.TypeTextFormat.SERIALIZED))) {
                return;
            }
            if (!JSTypeUtils.processExpandedType(this, type, context, source)) {
                return;
            }
            JSTypeSource typeSource = type.getSource();
            if (type instanceof JSRecordTypeImpl) {
                PsiElement element;
                if (typeSource.isExplicitlyDeclared()) {
                    VariantsProcessor.this.setAddOnlyCompleteMatches(true);
                }
                if ((element = typeSource.getSourceElement()) instanceof JSObjectLiteralExpression) {
                    VariantsProcessor.this.myTypeInfo.addBaseObjectLiteral((JSObjectLiteralExpression)element);
                }
                VariantsProcessor.this.myTypeInfo.setTypeWasProcessed();
                return;
            }
            if (type instanceof JSMixinTypeImpl) {
                this.process(((JSMixinTypeImpl)type).getBaseType(), context, source);
                String mixedType = JSTypeUtils.getQualifiedNameMatchingType(((JSMixinTypeImpl)type).getMixedType(), true);
                if (mixedType != null) {
                    VariantsProcessor.this.buildIndexListFromQNameAndCorrectQName(mixedType, false, JSContext.UNKNOWN);
                    VariantsProcessor.this.addSupers(mixedType, context, JSContext.UNKNOWN);
                }
                return;
            }
            JSNamespace namespace = JSTypeUtils.getNamespaceMatchingType(type, true, true);
            if (namespace == null || namespace.getQualifiedName() == null) {
                return;
            }
            VariantsProcessor.this.updateCanUseOnlyCompleteMatchesFromString(namespace.getQualifiedName().getQualifiedName(), source, null);
            String typeString = VariantsProcessor.this.addNamespace(namespace, true);
            if ("Window".equalsIgnoreCase(typeString) && VariantsProcessor.this.myGlobalStatusHint == BaseJSSymbolProcessor.GlobalStatusHint.NONGLOBAL) {
                VariantsProcessor.this.myGlobalStatusHint = BaseJSSymbolProcessor.GlobalStatusHint.UNKNOWN;
            }
            if (type instanceof JSGlobalTypeImpl) {
                VariantsProcessor.this.myGlobalStatusHint = BaseJSSymbolProcessor.GlobalStatusHint.GLOBAL;
                VariantsProcessor.this.myOnlyExportedItems = true;
            }
            VariantsProcessor.this.addSupers(namespace, context);
            if (type instanceof JSTypeImpl && ((JSTypeImpl)type).inheritsFunction()) {
                VariantsProcessor.this.addNamespace("Function", false, JSContext.INSTANCE, typeSource.isExplicitlyDeclared());
            }
            if (VariantsProcessor.this.isStrictTypingPossible(source, type)) {
                VariantsProcessor.this.myStrictlyTyped = true;
            }
            if (source instanceof JSReferenceExpression && source.getParent() instanceof JSNewExpression || source instanceof JSAssignmentExpression && this.isAssignmentChainOfNewExpression((JSAssignmentExpression)source)) {
                this.setUnknownElement(source.getParent());
            }
        }

        private boolean isAssignmentChainOfNewExpression(JSAssignmentExpression source) {
            JSExpression rOperand = source.getROperand();
            if (rOperand instanceof JSNewExpression) {
                return true;
            }
            if (rOperand instanceof JSAssignmentExpression) {
                return this.isAssignmentChainOfNewExpression((JSAssignmentExpression)rOperand);
            }
            return false;
        }

        @Override
        public PsiElement getTarget() {
            return null;
        }

        @Override
        public void setUnknownElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor", "setUnknownElement"));
            }
            this.myUnknownElement = element;
        }

        @Override
        public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor", "processResolvedElement"));
            }
            if (evaluateContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor", "processResolvedElement"));
            }
            if (element instanceof PsiFile && !CommonJSUtil.hasReexportedModules((PsiFile)element)) {
                VariantsProcessor.this.myReferencedModule = (PsiFile)element;
                VariantsProcessor.this.setAddOnlyCompleteMatches(true);
            }
        }

        public boolean getAllTypesResolved() {
            return this.myUnknownElement == null;
        }
    }
}

