/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSClassIndex
extends StringStubIndexExtension<JSElement> {
    public static final StubIndexKey<String, JSElement> KEY = StubIndexKey.createIndexKey((String)"js.class.index2");
    public static final char INTERFACE_MARK = '^';

    @NotNull
    public StubIndexKey<String, JSElement> getKey() {
        StubIndexKey<String, JSElement> stubIndexKey = KEY;
        if (stubIndexKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "getKey"));
        }
        return stubIndexKey;
    }

    public int getVersion() {
        return super.getVersion() + JSFileElementType.getVersion();
    }

    public static boolean isInterface(final @NotNull String qName, @NotNull PsiElement context) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "isInterface"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "isInterface"));
        }
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromQualifiedName(qName);
        if (qualifiedName != null) {
            return !JSClassIndex.processElements(qualifiedName.getName(), context.getProject(), JSResolveUtil.getResolveScope(context), new Processor<JSPsiElementBase>(){

                public boolean process(JSPsiElementBase base) {
                    return !qName.equals(base.getQualifiedName());
                }
            }, false);
        }
        return false;
    }

    public static boolean processElements(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<JSPsiElementBase> processor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "processElements"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "processElements"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "processElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "processElements"));
        }
        return JSClassIndex.processElements(name, project, scope, processor, true);
    }

    private static boolean processElements(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<JSPsiElementBase> processor, boolean includeClasses) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "processElements"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "processElements"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "processElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "processElements"));
        }
        Collection elements = StubIndex.getElements(KEY, (Object)('^' + name), (Project)project, (GlobalSearchScope)scope, JSElement.class);
        List classes = includeClasses ? StubIndex.getElements(KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, JSElement.class) : Collections.emptyList();
        elements.addAll(classes);
        for (JSElement element : elements) {
            JSElementIndexingData data;
            Collection implicitElements;
            if (element instanceof JSQualifiedNamedElement && !processor.process((Object)((JSQualifiedNamedElement)element))) {
                return false;
            }
            if (!(element instanceof JSImplicitElementProvider) || (implicitElements = (data = ((JSImplicitElementProvider)element).getIndexingData()) != null ? data.getImplicitElements() : null) == null) continue;
            for (JSImplicitElement implicitElement : implicitElements) {
                if (!name.equals(implicitElement.getName()) || processor.process((Object)implicitElement)) continue;
                return false;
            }
        }
        return true;
    }

    public static Collection<JSPsiElementBase> getElements(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "getElements"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "getElements"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "getElements"));
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        JSClassIndex.processElements(name, project, scope, (Processor<JSPsiElementBase>)processor);
        return processor.getResults();
    }

    public static String getNameToIndex(@NotNull String unqualifiedName, boolean isInterface) {
        if (unqualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unqualifiedName", "com/intellij/lang/javascript/psi/stubs/JSClassIndex", "getNameToIndex"));
        }
        return isInterface ? '^' + unqualifiedName : unqualifiedName;
    }

    public static enum ClassOrInterface {
        CLASS,
        INTERFACE,
        NONE;

    }
}

