/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import org.jetbrains.annotations.NotNull;

public class JSTypedefIndex
extends StringStubIndexExtension<JSElement> {
    public static final StubIndexKey<String, JSElement> KEY = StubIndexKey.createIndexKey((String)"js.typedef.index2");

    @NotNull
    public StubIndexKey<String, JSElement> getKey() {
        StubIndexKey<String, JSElement> stubIndexKey = KEY;
        if (stubIndexKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/JSTypedefIndex", "getKey"));
        }
        return stubIndexKey;
    }

    public int getVersion() {
        return super.getVersion() + JSFileElementType.getVersion();
    }

    public static String getTypeByIndexValue(@NotNull String indexValue) {
        int nonDigit;
        if (indexValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexValue", "com/intellij/lang/javascript/psi/stubs/JSTypedefIndex", "getTypeByIndexValue"));
        }
        for (nonDigit = 0; indexValue.length() > nonDigit && Character.isDigit(indexValue.charAt(nonDigit)); ++nonDigit) {
        }
        return indexValue.length() > nonDigit && !JSTypedefIndex.isTypeCharacter(indexValue.charAt(nonDigit)) ? indexValue.substring(nonDigit + 1) : indexValue.substring(nonDigit);
    }

    private static boolean isTypeCharacter(char c) {
        return StringUtil.isJavaIdentifierStart((char)c) || "%{(*?!$\"'.-".indexOf(c) >= 0;
    }
}

