/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.ByteFlagsSerializer;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementProviderStub;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSSubclassIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.javascript.psi.stubs.JSTypedefIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.SmartList;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.StringRef;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSElementIndexingDataImpl
implements JSElementIndexingData {
    private static final BooleanStructureElement HAS_ELEMENTS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPEDEFS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_BASE_TYPES_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_CLASS_EXPLICITLY_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_INTERFACE_EXPLICITLY_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_USER_STRINGS_FLAG = new BooleanStructureElement();
    private static final FlagsStructure OUR_FLAGS_STRUCTURE = new FlagsStructure(HAS_ELEMENTS_FLAG, HAS_TYPEDEFS_FLAG, HAS_BASE_TYPES_FLAG, IS_CLASS_EXPLICITLY_FLAG, IS_INTERFACE_EXPLICITLY_FLAG, HAS_USER_STRINGS_FLAG);
    @Nullable
    private Collection<JSImplicitElement> myElements;
    @Nullable
    private Collection<Pair<String, String>> myTypedefs;
    @Nullable
    private Collection<Pair<String, String>> myBaseTypes;
    private boolean myIsClassExplicitly;
    private boolean myIsInterfaceExplicitly;
    private Map<String, String> myUserStrings;

    public JSElementIndexingDataImpl() {
        this(null);
    }

    public JSElementIndexingDataImpl(@Nullable Collection<JSImplicitElement> elements) {
        this.myElements = elements;
    }

    @Nullable
    public static JSElementIndexingData deserialize(StubInputStream dataStream, @NotNull JSImplicitElementProviderStub<?> stub) throws IOException {
        int i;
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "deserialize"));
        }
        byte flags = dataStream.readByte();
        Boolean hasElements = ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, HAS_ELEMENTS_FLAG, flags);
        Boolean hasTypedefs = ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, HAS_TYPEDEFS_FLAG, flags);
        Boolean hasBaseTypes = ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, HAS_BASE_TYPES_FLAG, flags);
        Boolean isClassExplicitly = ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, IS_CLASS_EXPLICITLY_FLAG, flags);
        Boolean isInterfaceExplicitly = ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, IS_INTERFACE_EXPLICITLY_FLAG, flags);
        Boolean hasUserStrings = ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, HAS_USER_STRINGS_FLAG, flags);
        if (!(hasElements.booleanValue() || hasTypedefs.booleanValue() || hasBaseTypes.booleanValue() || isClassExplicitly.booleanValue() || isInterfaceExplicitly.booleanValue() || hasUserStrings.booleanValue())) {
            return null;
        }
        JSElementIndexingDataImpl data = new JSElementIndexingDataImpl();
        if (hasElements.booleanValue()) {
            int elementsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
            assert (elementsCount > 0);
            data.myElements = new SmartList();
            PsiElement element = stub.getPsi();
            for (i = 0; i < elementsCount; ++i) {
                JSImplicitElementImpl.Builder builder = JSImplicitElementImpl.deserialize((DataInput)dataStream);
                data.myElements.add(builder.setProvider(element).toImplicitElement());
            }
        }
        if (hasTypedefs.booleanValue()) {
            int typedefsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
            assert (typedefsCount > 0);
            SmartList typedefs = new SmartList();
            for (i = 0; i < typedefsCount; ++i) {
                StringRef typeName = dataStream.readName();
                StringRef type = dataStream.readName();
                typedefs.add((Object)Pair.create((Object)(typeName != null ? typeName.getString() : null), (Object)(type != null ? type.getString() : null)));
            }
            data.myTypedefs = typedefs;
        }
        if (hasBaseTypes.booleanValue()) {
            int baseTypesCount = DataInputOutputUtil.readINT((DataInput)dataStream);
            assert (baseTypesCount > 0);
            SmartList baseTypes = new SmartList();
            for (i = 0; i < baseTypesCount; ++i) {
                StringRef classNameRef = dataStream.readName();
                StringRef baseType = dataStream.readName();
                if (classNameRef == null || baseType == null) continue;
                baseTypes.add(Pair.create((Object)classNameRef.getString(), (Object)baseType.getString()));
            }
            data.myBaseTypes = baseTypes;
        }
        data.myIsClassExplicitly = isClassExplicitly;
        data.myIsInterfaceExplicitly = isInterfaceExplicitly;
        if (hasUserStrings.booleanValue()) {
            int userStringsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
            assert (userStringsCount > 0);
            THashMap userStrings = new THashMap(userStringsCount);
            for (i = 0; i < userStringsCount; ++i) {
                StringRef keyRef = dataStream.readName();
                StringRef valueRef = dataStream.readName();
                if (keyRef == null || valueRef == null) continue;
                userStrings.put(keyRef.getString(), valueRef.getString());
            }
            data.myUserStrings = userStrings;
        }
        return data;
    }

    public static void serialize(@Nullable JSElementIndexingData indexingData, StubOutputStream dataStream) throws IOException {
        byte flags = 0;
        if (indexingData == null) {
            dataStream.writeByte((int)flags);
            return;
        }
        ByteFlagsSerializer s = ByteFlagsSerializer.INSTANCE;
        Collection elements = indexingData.getImplicitElements();
        boolean hasImplicitElements = elements != null && !elements.isEmpty();
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, HAS_ELEMENTS_FLAG, hasImplicitElements, flags);
        Collection typedefs = indexingData.getTypedefs();
        boolean hasTypedefs = typedefs != null && !typedefs.isEmpty();
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, HAS_TYPEDEFS_FLAG, hasTypedefs, flags);
        Collection baseTypes = indexingData.getBaseTypes();
        boolean hasBaseTypes = baseTypes != null && !baseTypes.isEmpty();
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, HAS_BASE_TYPES_FLAG, hasBaseTypes, flags);
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, IS_CLASS_EXPLICITLY_FLAG, indexingData.isClassExplicitly(), flags);
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, IS_INTERFACE_EXPLICITLY_FLAG, indexingData.isInterfaceExplicitly(), flags);
        Map userStrings = indexingData.getUserStrings();
        boolean hasUserStrings = userStrings != null && !userStrings.isEmpty();
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, HAS_USER_STRINGS_FLAG, hasUserStrings, flags);
        dataStream.writeByte((int)flags);
        if (hasImplicitElements) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)elements.size());
            for (JSImplicitElement jSImplicitElement : elements) {
                jSImplicitElement.serialize((DataOutput)dataStream);
            }
        }
        if (hasTypedefs) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)typedefs.size());
            for (Pair pair : typedefs) {
                dataStream.writeName((String)pair.first);
                dataStream.writeName((String)pair.second);
            }
        }
        if (hasBaseTypes) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)baseTypes.size());
            for (Pair pair : baseTypes) {
                dataStream.writeName((String)pair.first);
                dataStream.writeName((String)pair.second);
            }
        }
        if (hasUserStrings) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)userStrings.size());
            for (Map.Entry entry : userStrings.entrySet()) {
                dataStream.writeName((String)entry.getKey());
                dataStream.writeName((String)entry.getValue());
            }
        }
    }

    public static void index(@Nullable JSElementIndexingData data, @NotNull StubElement<?> stub, @NotNull IndexSink sink) {
        Collection baseTypes;
        Collection typedefs;
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "index"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "index"));
        }
        if (data == null) {
            return;
        }
        Collection elements = data.getImplicitElements();
        if (elements != null) {
            Set indexedNamespaces = null;
            for (JSImplicitElement element : elements) {
                if (JSElementIndexingDataImpl.indexImplicitElement(element, sink)) continue;
                String elementName = element.getName();
                sink.occurrence(JSSymbolIndex2.KEY, (Object)elementName);
                if (element.getType().providesNamespace()) {
                    PsiElement parent;
                    boolean isInterface = false;
                    if (element instanceof JSImplicitElementImpl && (parent = element.getParent()) instanceof JSDocComment && ((JSDocComment)parent).hasInterfaceTag()) {
                        isInterface = true;
                    }
                    sink.occurrence(JSClassIndex.KEY, (Object)JSClassIndex.getNameToIndex(elementName, isInterface));
                }
                if (element.isNamespaceExplicitlyDeclared()) {
                    String ns;
                    JSQualifiedName namespace = element.getNamespace();
                    String string = ns = namespace != null ? namespace.getQualifiedName() : "";
                    if (indexedNamespaces == null) {
                        indexedNamespaces = new THashSet();
                    }
                    if (indexedNamespaces.add(ns)) {
                        sink.occurrence(JSNamespaceMembersIndex.KEY, (Object)ns);
                    }
                }
                String qName = element.getQualifiedName();
                sink.occurrence(JSSymbolQualifiedNamesIndex.KEY, (Object)qName);
            }
        }
        if ((typedefs = data.getTypedefs()) != null) {
            for (Pair typedef : typedefs) {
                sink.occurrence(JSTypedefIndex.KEY, typedef.first);
            }
        }
        if ((baseTypes = data.getBaseTypes()) != null) {
            THashSet addedBaseTypes = new THashSet();
            THashSet addedSubclasses = new THashSet();
            for (Pair baseType : baseTypes) {
                if (addedBaseTypes.add(baseType.first)) {
                    sink.occurrence(JSBaseTypesIndex.KEY, baseType.first);
                }
                if (!addedSubclasses.add(baseType.second)) continue;
                sink.occurrence(JSSubclassIndex.KEY, baseType.second);
            }
        }
    }

    public static boolean indexImplicitElement(@NotNull JSImplicitElement element, @Nullable IndexSink sink) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "indexImplicitElement"));
        }
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            if (!handler.indexImplicitElement(element, sink)) continue;
            return true;
        }
        return false;
    }

    public void addImplicitElement(@NotNull JSImplicitElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "addImplicitElement"));
        }
        if (this.myElements == null) {
            this.myElements = new SmartList();
        }
        this.myElements.add(element);
    }

    public void addImplicitElements(@NotNull Collection<JSImplicitElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "addImplicitElements"));
        }
        if (this.myElements == null) {
            this.myElements = new SmartList();
        }
        this.myElements.addAll(elements);
    }

    @Nullable
    public Collection<JSImplicitElement> getImplicitElements() {
        return this.myElements;
    }

    public void setImplicitElements(@Nullable Collection<JSImplicitElement> elements) {
        this.myElements = elements;
    }

    public void addAccessorsFromObjectLiteral(@NotNull JSObjectLiteralExpression objectLiteral) {
        if (objectLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectLiteral", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "addAccessorsFromObjectLiteral"));
        }
        JSSymbolUtil.forEachIdentifierProperty(objectLiteral, new JSSymbolUtil.PropertyProcessor(){

            @Override
            public void process(String titleCasedPropName, JSProperty property) {
                JSImplicitElementImpl.Builder getterBuilder = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestGetterName(titleCasedPropName), (PsiElement)property).setProperties(JSImplicitElement.Property.GetFunction);
                JSElementIndexingDataImpl.this.addImplicitElement(new JSImplicitElementImpl(getterBuilder));
                JSImplicitElementImpl.Builder setterBuilder = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestSetterName(titleCasedPropName), (PsiElement)property).setProperties(JSImplicitElement.Property.SetFunction);
                JSElementIndexingDataImpl.this.addImplicitElement(new JSImplicitElementImpl(setterBuilder));
            }
        });
    }

    @Nullable
    public Collection<Pair<String, String>> getTypedefs() {
        return this.myTypedefs;
    }

    public void addTypedef(String name, String type) {
        if (this.myTypedefs == null) {
            this.myTypedefs = new SmartList();
        }
        this.myTypedefs.add((Pair<String, String>)Pair.create((Object)name, (Object)type));
    }

    @Nullable
    public Collection<Pair<String, String>> getBaseTypes() {
        return this.myBaseTypes;
    }

    public void addBaseType(@NotNull String qualifiedName, @NotNull String baseType) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "addBaseType"));
        }
        if (baseType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseType", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "addBaseType"));
        }
        if (this.myBaseTypes == null) {
            this.myBaseTypes = new SmartList();
        }
        this.myBaseTypes.add((Pair<String, String>)Pair.create((Object)qualifiedName, (Object)baseType));
    }

    public boolean isClassExplicitly() {
        return this.myIsClassExplicitly;
    }

    public void setIsClassExplicitly() {
        this.myIsClassExplicitly = true;
    }

    public boolean isInterfaceExplicitly() {
        return this.myIsInterfaceExplicitly;
    }

    public void setIsInterfaceExplicitly() {
        this.myIsInterfaceExplicitly = true;
    }

    @Nullable
    public Map<String, String> getUserStrings() {
        return this.myUserStrings;
    }

    public void putUserString(@NotNull String key, @NotNull String value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "putUserString"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "putUserString"));
        }
        ourUserStringKeysRegisty.checkRegistered(key);
        if (this.myUserStrings == null) {
            this.myUserStrings = new THashMap(1);
        }
        this.myUserStrings.put(key, value);
    }

    public boolean isEmpty() {
        boolean hasImplicitElements = this.getImplicitElements() != null && !this.getImplicitElements().isEmpty();
        boolean hasTypedefs = this.getTypedefs() != null && !this.getTypedefs().isEmpty();
        boolean hasBaseTypes = this.getBaseTypes() != null && !this.getBaseTypes().isEmpty();
        boolean hasUserStrings = this.getUserStrings() != null && !this.getUserStrings().isEmpty();
        return !hasImplicitElements && !hasTypedefs && !hasBaseTypes && !hasUserStrings && !this.isClassExplicitly() && !this.isInterfaceExplicitly();
    }
}

