/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.EnumSetStructureElement;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.lang.javascript.index.flags.IntFlagsSerializer;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumSet;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImplicitElementImpl
extends FakePsiElement
implements JSImplicitElement {
    private static final BooleanStructureElement NAMESPACE_EXPLICITLY_DECLARED_FLAG = new BooleanStructureElement();
    protected static final EnumSetStructureElement<JSImplicitElement.Property> PROPERTIES_FLAG = new EnumSetStructureElement<JSImplicitElement.Property>(JSImplicitElement.Property.class);
    private static final EnumStructureElement<JSImplicitElement.Type> TYPE_FLAG = new EnumStructureElement<JSImplicitElement.Type>(JSImplicitElement.Type.class);
    private static final EnumStructureElement<JSContext> JS_CONTEXT_FLAG = new EnumStructureElement<JSContext>(JSContext.class);
    private static final EnumStructureElement<JSAttributeList.AccessType> ACCESS_TYPE_FLAG = new EnumStructureElement<JSAttributeList.AccessType>(JSAttributeList.AccessType.class);
    private static final BooleanStructureElement DEPRECATED_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPE_STRING_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_USER_STRING_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(NAMESPACE_EXPLICITLY_DECLARED_FLAG, PROPERTIES_FLAG, TYPE_FLAG, JS_CONTEXT_FLAG, ACCESS_TYPE_FLAG, DEPRECATED_FLAG, HAS_TYPE_STRING_FLAG, HAS_USER_STRING_FLAG);
    private final int myFlags;
    @NotNull
    protected final String myName;
    @Nullable
    private final JSQualifiedName myNamespace;
    @Nullable
    protected final String myTypeString;
    @Nullable
    protected final PsiElement myProvider;
    @Nullable
    private final String myUserString;

    public JSImplicitElementImpl(@NotNull String name, @Nullable PsiElement provider) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "<init>"));
        }
        this(new Builder(name, provider));
    }

    public JSImplicitElementImpl(@NotNull String name, @Nullable JSQualifiedName namespace, @Nullable PsiElement provider) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "<init>"));
        }
        this(new Builder(name, provider).setNamespace(namespace));
    }

    public JSImplicitElementImpl(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "<init>"));
        }
        this.myName = builder.myName;
        this.myNamespace = builder.myNamespace;
        this.myFlags = builder.myFlags;
        assert (this.getType() == JSImplicitElement.Type.Function == this instanceof JSImplicitFunctionImpl);
        this.myTypeString = builder.myTypeString;
        this.myProvider = builder.myProvider;
        this.myUserString = builder.myUserString;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "processDeclarations"));
        }
        return processor.execute((PsiElement)this, state);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getName"));
        }
        return string;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return this.myNamespace;
    }

    @NotNull
    public String getQualifiedName() {
        String prefix = this.myNamespace != null ? this.myNamespace.getQualifiedName() + "." : "";
        String string = prefix + this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getQualifiedName"));
        }
        return string;
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return this.readFlag(NAMESPACE_EXPLICITLY_DECLARED_FLAG);
    }

    @Nullable
    public String getUserString() {
        return this.myUserString;
    }

    protected final <T> T readFlag(FlagsStructureElement<T> structureElement) {
        return IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, structureElement, this.myFlags);
    }

    @Contract(pure=true)
    protected static <T> int writeFlag(int currentFlags, FlagsStructureElement<T> structureElement, T value) {
        return IntFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, structureElement, value, currentFlags);
    }

    public void serialize(DataOutput dataStream) throws IOException {
        String qName = this.myNamespace == null ? this.myName : this.myNamespace.getQualifiedName() + "." + this.myName;
        IOUtil.writeUTF((DataOutput)dataStream, (String)qName);
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)this.myFlags);
        if (this.myTypeString != null) {
            assert (this.readFlag(HAS_TYPE_STRING_FLAG).booleanValue());
            IOUtil.writeUTF((DataOutput)dataStream, (String)this.myTypeString);
        }
        if (this.myUserString != null) {
            assert (this.readFlag(HAS_USER_STRING_FLAG).booleanValue());
            IOUtil.writeUTF((DataOutput)dataStream, (String)this.myUserString);
        }
    }

    @NotNull
    public static Builder deserialize(DataInput dataStream) throws IOException {
        Builder builder;
        String qName = IOUtil.readUTF((DataInput)dataStream);
        JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(qName);
        int flags = DataInputOutputUtil.readINT((DataInput)dataStream);
        boolean hasType = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_TYPE_STRING_FLAG, flags);
        String typeString = hasType ? IOUtil.readUTF((DataInput)dataStream) : null;
        boolean hasUserString = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_USER_STRING_FLAG, flags);
        String userString = hasUserString ? IOUtil.readUTF((DataInput)dataStream) : null;
        JSImplicitElement.Type type = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, TYPE_FLAG, flags);
        if (type == JSImplicitElement.Type.Function) {
            builder = new JSImplicitFunctionImpl.Builder(name.getName(), null);
            ((JSImplicitFunctionImpl.Builder)builder).setReturnType(typeString);
        } else {
            builder = new Builder(name.getName(), null);
            builder.setTypeString(typeString);
        }
        builder.setNamespace(name.getParent()).setFlags(flags).setPossiblyUnregisteredUserString(userString);
        if (builder instanceof JSImplicitFunctionImpl.Builder) {
            JSImplicitFunctionImpl.deserializeParameters(dataStream, (JSImplicitFunctionImpl.Builder)builder);
        }
        Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "deserialize"));
        }
        return builder2;
    }

    @NotNull
    public static JSImplicitElement fromQualifiedName(String qName, @Nullable PsiElement provider) {
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromQualifiedName(qName);
        JSImplicitElementImpl jSImplicitElementImpl = new JSImplicitElementImpl(qualifiedName.getName(), qualifiedName.getParent(), provider);
        if (jSImplicitElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "fromQualifiedName"));
        }
        return jSImplicitElementImpl;
    }

    @NotNull
    public JSImplicitElement.Type getType() {
        JSImplicitElement.Type type = this.readFlag(TYPE_FLAG);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getType"));
        }
        return type;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.readFlag(JS_CONTEXT_FLAG);
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getJSContext"));
        }
        return jSContext;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = this.readFlag(ACCESS_TYPE_FLAG);
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getAccessType"));
        }
        return accessType;
    }

    public boolean hasMinorImportance() {
        return ((EnumSet)this.readFlag(PROPERTIES_FLAG)).contains(JSImplicitElement.Property.MinorImportance);
    }

    public boolean isDeprecated() {
        return this.readFlag(DEPRECATED_FLAG);
    }

    @Nullable
    public String getTypeString() {
        return this.myTypeString;
    }

    public PsiElement getParent() {
        return this.myProvider;
    }

    @NotNull
    public Language getLanguage() {
        JSLanguageDialect dialect;
        if (this.myProvider != null && (dialect = DialectDetector.languageDialectOfElement(this.myProvider)) != null) {
            JSLanguageDialect jSLanguageDialect = dialect;
            if (jSLanguageDialect == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getLanguage"));
            }
            return jSLanguageDialect;
        }
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getLanguage"));
        }
        return javascriptLanguage;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        JSImplicitElementImpl jSImplicitElementImpl = this.myProvider != null ? this.myProvider : this;
        if (jSImplicitElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getNavigationElement"));
        }
        return jSImplicitElementImpl;
    }

    public boolean isConst() {
        return ((EnumSet)this.readFlag(PROPERTIES_FLAG)).contains(JSImplicitElement.Property.Constant);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "setName"));
        }
        if (this.myProvider instanceof JSLiteralExpression) {
            ElementManipulators.getManipulator((PsiElement)this.myProvider).handleContentChange(this.myProvider, name);
        }
        return this.toBuilder().setName(name).toImplicitElement();
    }

    @NotNull
    protected Builder toBuilder() {
        Builder builder = new Builder(this.myName, this.myProvider);
        this.fillBuilder(builder);
        Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "toBuilder"));
        }
        return builder2;
    }

    protected void fillBuilder(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "fillBuilder"));
        }
        builder.setName(this.myName).setProvider(this.myProvider).setNamespace(this.myNamespace).setFlags(this.myFlags);
        if (!(builder instanceof JSImplicitFunctionImpl.Builder)) {
            builder.setTypeString(this.myTypeString);
        }
    }

    @Nullable
    public Icon getIcon(boolean open) {
        JSImplicitElement.Type type = this.getType();
        switch (type) {
            case Variable: {
                return PlatformIcons.VARIABLE_ICON;
            }
            case Function: {
                return JSStubElementImpl.blendFlags(PlatformIcons.METHOD_ICON, true, false);
            }
            case Property: {
                return PlatformIcons.PROPERTY_ICON;
            }
            case Namespace: 
            case Class: 
            case Interface: {
                JSIconProvider iconProvider = JSIconProvider.getForLanguage((PsiElement)this.getContainingFile());
                return type == JSImplicitElement.Type.Interface ? iconProvider.getInterfaceIcon() : iconProvider.getClassIcon();
            }
            case Tag: {
                return JSIconProvider.HTML_TAG_ICON;
            }
        }
        throw new IllegalArgumentException("Unexpected type " + type);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.structureEquals((JSImplicitElementImpl)((Object)obj));
    }

    protected boolean structureEquals(JSImplicitElementImpl other) {
        return this.myName.equals(other.myName) && (this.myNamespace == null ? other.myNamespace == null : this.myNamespace.equals(other.myNamespace)) && this.isNamespaceExplicitlyDeclared() == other.isNamespaceExplicitlyDeclared() && ((EnumSet)this.readFlag(PROPERTIES_FLAG)).equals(other.readFlag(PROPERTIES_FLAG)) && this.getType() == other.getType() && this.getJSContext() == other.getJSContext() && this.getAccessType() == other.getAccessType() && (this.myTypeString == null ? other.myTypeString == null : this.myTypeString.equals(other.myTypeString)) && this.myProvider == other.myProvider && this.isDeprecated() == other.isDeprecated();
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public ItemPresentation getPresentation() {
        return new JSItemPresentation((JSPsiElementBase)this);
    }

    public static class Builder {
        @NotNull
        private String myName;
        @Nullable
        private JSQualifiedName myNamespace;
        private int myFlags;
        @Nullable
        protected String myTypeString;
        @Nullable
        private PsiElement myProvider;
        @Nullable
        private String myUserString;

        public Builder(@NotNull JSQualifiedName qualifiedName, @Nullable PsiElement provider) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "<init>"));
            }
            this(qualifiedName.getName(), provider);
            this.setNamespace(qualifiedName.getParent());
        }

        public Builder(@NotNull String name, @Nullable PsiElement provider) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "<init>"));
            }
            this.myName = name;
            this.myProvider = provider;
            this.setNamespaceExplicitlyDeclared(true);
            this.setType(JSImplicitElement.Type.Property);
            this.setAccessType(JSAttributeList.AccessType.PACKAGE_LOCAL);
            this.setContext(JSContext.UNKNOWN);
        }

        public Builder setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "setName"));
            }
            this.myName = name;
            return this;
        }

        public Builder setNamespace(JSQualifiedName namespace) {
            this.myNamespace = namespace;
            return this;
        }

        public Builder setNamespaceExplicitlyDeclared(boolean namespaceExplicitlyDeclared) {
            this.myFlags = JSImplicitElementImpl.writeFlag(this.myFlags, NAMESPACE_EXPLICITLY_DECLARED_FLAG, namespaceExplicitlyDeclared);
            return this;
        }

        public Builder setProperties(JSImplicitElement.Property ... properties) {
            this.myFlags = JSImplicitElementImpl.writeFlag(this.myFlags, PROPERTIES_FLAG, EnumSet.of(properties[0], properties));
            return this;
        }

        public Builder setProperties(@Nullable EnumSet<JSImplicitElement.Property> properties) {
            this.myFlags = JSImplicitElementImpl.writeFlag(this.myFlags, PROPERTIES_FLAG, properties);
            return this;
        }

        public Builder setType(JSImplicitElement.Type type) {
            this.myFlags = JSImplicitElementImpl.writeFlag(this.myFlags, TYPE_FLAG, type);
            return this;
        }

        public Builder setContext(JSContext context) {
            this.myFlags = JSImplicitElementImpl.writeFlag(this.myFlags, JS_CONTEXT_FLAG, context);
            return this;
        }

        public Builder setAccessType(JSAttributeList.AccessType accessType) {
            this.myFlags = JSImplicitElementImpl.writeFlag(this.myFlags, ACCESS_TYPE_FLAG, accessType);
            return this;
        }

        public Builder setTypeString(@Nullable String typeString) {
            this.myTypeString = typeString;
            this.myFlags = JSImplicitElementImpl.writeFlag(this.myFlags, HAS_TYPE_STRING_FLAG, typeString != null);
            return this;
        }

        public Builder setDeprecated(boolean deprecated) {
            this.myFlags = JSImplicitElementImpl.writeFlag(this.myFlags, DEPRECATED_FLAG, deprecated);
            return this;
        }

        public Builder setProvider(@Nullable PsiElement provider) {
            this.myProvider = provider;
            return this;
        }

        public Builder setUserString(@Nullable String userString) {
            JSImplicitElement.ourUserStringsRegistry.checkRegistered(userString);
            return this.setPossiblyUnregisteredUserString(userString);
        }

        private Builder setPossiblyUnregisteredUserString(@Nullable String userString) {
            this.myUserString = userString;
            this.myFlags = JSImplicitElementImpl.writeFlag(this.myFlags, HAS_USER_STRING_FLAG, userString != null);
            return this;
        }

        private Builder setFlags(int flags) {
            this.myFlags = flags;
            return this;
        }

        public JSImplicitElementImpl toImplicitElement() {
            return new JSImplicitElementImpl(this);
        }
    }
}

