/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.stubs.JSNameIndex;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedStub;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSNamedObjectStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.types.JSPackageStatementElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSQualifiedObjectStubBase<T extends JSQualifiedNamedElement>
extends JSNamedObjectStubBase<T>
implements JSQualifiedStub<T> {
    private static final BooleanStructureElement NAMESPACE_EXPLICITLY_DECLARED_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement DEPRECATED_FLAG = new BooleanStructureElement();
    private static final EnumStructureElement<JSAttributeList.AccessType> ACCESS_TYPE_FLAG = new EnumStructureElement<JSAttributeList.AccessType>(JSAttributeList.AccessType.class);
    private static final EnumStructureElement<JSContext> CONTEXT_FLAG = new EnumStructureElement<JSContext>(JSContext.class);
    private static final BooleanStructureElement IS_CLASS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_INTERFACE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_NAMESPACE_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSNamedObjectStubBase.FLAGS_STRUCTURE, NAMESPACE_EXPLICITLY_DECLARED_FLAG, DEPRECATED_FLAG, ACCESS_TYPE_FLAG, CONTEXT_FLAG, IS_CLASS_FLAG, IS_INTERFACE_FLAG, HAS_NAMESPACE_FLAG);
    @Nullable
    protected final JSQualifiedName myNamespace;

    protected JSQualifiedObjectStubBase(T clazz, StubElement parent, @NotNull JSStubElementType<?, T> elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "<init>"));
        }
        super(clazz, parent, elementType);
        this.myNamespace = clazz.getNamespace();
        this.writeFlag(NAMESPACE_EXPLICITLY_DECLARED_FLAG, clazz.isNamespaceExplicitlyDeclared());
        this.writeFlag(ACCESS_TYPE_FLAG, clazz.getAccessType());
        this.writeFlag(DEPRECATED_FLAG, clazz.isDeprecated());
        this.writeFlag(CONTEXT_FLAG, clazz.getJSContext());
        JSClassIndex.ClassOrInterface classOrInterface = this.isClassOrInterface(clazz);
        this.writeFlag(IS_CLASS_FLAG, classOrInterface == JSClassIndex.ClassOrInterface.CLASS);
        this.writeFlag(IS_INTERFACE_FLAG, classOrInterface == JSClassIndex.ClassOrInterface.INTERFACE);
        this.writeFlag(HAS_NAMESPACE_FLAG, this.myNamespace != null);
    }

    protected JSQualifiedObjectStubBase(String name, String qName, StubElement parent, @NotNull JSContext jsContext, @NotNull JSAttributeList.AccessType accessType, @NotNull IStubElementType elementType) {
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "<init>"));
        }
        if (accessType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessType", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "<init>"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "<init>"));
        }
        super(name, parent, elementType);
        JSQualifiedNameImpl qualifiedName = qName != null ? JSQualifiedNameImpl.fromQualifiedName(qName) : null;
        this.myNamespace = qualifiedName != null ? qualifiedName.getParent() : null;
        this.writeFlag(NAMESPACE_EXPLICITLY_DECLARED_FLAG, true);
        this.writeFlag(ACCESS_TYPE_FLAG, JSAttributeList.AccessType.PACKAGE_LOCAL);
        this.writeFlag(DEPRECATED_FLAG, false);
        this.writeFlag(CONTEXT_FLAG, jsContext);
        this.writeFlag(ACCESS_TYPE_FLAG, accessType);
        this.writeFlag(HAS_NAMESPACE_FLAG, this.myNamespace != null);
    }

    protected JSQualifiedObjectStubBase(StubInputStream dataStream, StubElement parentStub, @NotNull IStubElementType elementType) throws IOException {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "<init>"));
        }
        super(dataStream, parentStub, elementType);
        this.myNamespace = this.readFlag(HAS_NAMESPACE_FLAG) != false ? JSQualifiedNameImpl.deserialize(dataStream) : null;
    }

    @Override
    public void index(IndexSink sink) {
        Language language;
        super.index(sink);
        String name = this.getName();
        String fqn = this.getQualifiedName();
        if (name != null && this.doIndexName() && ((language = StubTreeUtil.getJSLanguage(this)) == JavaScriptSupportLoader.ECMA_SCRIPT_L4 || language != JavascriptLanguage.INSTANCE && !(language instanceof JSLanguageDialect))) {
            sink.occurrence(JSNameIndex.KEY, (Object)name);
        }
        if (fqn != null && this.doIndexQualifiedName()) {
            sink.occurrence(JSQualifiedElementIndex.KEY, (Object)fqn.hashCode());
        }
        if (name != null && this.readFlag(IS_SYMBOL_FLAG).booleanValue()) {
            JSQualifiedName namespace = this.getNamespace();
            if (namespace != null || this.isNamespaceExplicitlyDeclared()) {
                String ns = namespace != null ? namespace.getQualifiedName() : "";
                sink.occurrence(JSNamespaceMembersIndex.KEY, (Object)ns);
            }
            assert (fqn != null) : ((Object)((Object)this)).getClass();
            sink.occurrence(JSSymbolQualifiedNamesIndex.KEY, (Object)fqn);
        }
        if (name != null && (this.readFlag(IS_CLASS_FLAG).booleanValue() || this.readFlag(IS_INTERFACE_FLAG).booleanValue())) {
            sink.occurrence(JSClassIndex.KEY, (Object)JSClassIndex.getNameToIndex(name, this.readFlag(IS_INTERFACE_FLAG)));
        }
    }

    protected boolean doIndexName() {
        return false;
    }

    protected boolean doIndexQualifiedName() {
        return false;
    }

    @NotNull
    protected JSClassIndex.ClassOrInterface isClassOrInterface(T element) {
        JSClassIndex.ClassOrInterface classOrInterface = JSDocumentationUtils.isClassOrInterface(element);
        if (classOrInterface == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "isClassOrInterface"));
        }
        return classOrInterface;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_NAMESPACE_FLAG).booleanValue()) {
            JSQualifiedNameImpl.serialize(this.myNamespace, dataStream);
        }
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return this.myNamespace;
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return this.readFlag(NAMESPACE_EXPLICITLY_DECLARED_FLAG);
    }

    public String getQualifiedName() {
        if (this.myName == null) {
            return null;
        }
        String name = this.myName.getString();
        if (name == null) {
            return null;
        }
        String prefix = this.myNamespace != null ? this.myNamespace.getQualifiedName() + "." : "";
        return prefix + name;
    }

    protected static boolean isUnderPackageOrUnderFile(StubElement stub) {
        StubElement parentStub = stub.getParentStub();
        if (parentStub == null) {
            return false;
        }
        IStubElementType stubType = parentStub.getStubType();
        return stubType instanceof JSPackageStatementElementType || stubType == null;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = this.readFlag(ACCESS_TYPE_FLAG);
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "getAccessType"));
        }
        return accessType;
    }

    public boolean isDeprecated() {
        return this.readFlag(DEPRECATED_FLAG);
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.readFlag(CONTEXT_FLAG);
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "getJSContext"));
        }
        return jSContext;
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSQualifiedObjectStubBase", "getFlagsStructure"));
        }
        return flagsStructure;
    }
}

