/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.stubs.JSReferenceListStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubBase;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class JSReferenceListStubBase<T extends JSReferenceList>
extends JSStubBase<T> {
    private final StringRef[] myRefs;
    private String[] myCachedStringRefs;

    public JSReferenceListStubBase(StubInputStream dataStream, StubElement parentStub, @NotNull JSStubElementType<? extends JSReferenceListStub, T> type) throws IOException {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/stubs/impl/JSReferenceListStubBase", "<init>"));
        }
        super(dataStream, parentStub, (IStubElementType)type);
        this.myRefs = JSReferenceListStubBase.readRefs(dataStream);
    }

    private static StringRef[] readRefs(StubInputStream dataStream) throws IOException {
        int count = dataStream.readInt();
        StringRef[] refs = StringRef.createArray((int)count);
        if (count != 0) {
            for (int i = 0; i < count; ++i) {
                refs[i] = dataStream.readName();
            }
        }
        return refs;
    }

    public JSReferenceListStubBase(String[] strings, StubElement parentStub, @NotNull JSStubElementType<? extends JSReferenceListStub, T> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/stubs/impl/JSReferenceListStubBase", "<init>"));
        }
        super(parentStub, (IStubElementType)type);
        this.myRefs = JSReferenceListStubBase.convertToRefs(strings);
    }

    private static StringRef[] convertToRefs(String[] strings) {
        if (strings.length == 0) {
            return StringRef.EMPTY_ARRAY;
        }
        StringRef[] refs = new StringRef[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            refs[i] = StringRef.fromString((String)strings[i]);
        }
        return refs;
    }

    public JSReferenceListStubBase(T psi, StubElement parentStub, @NotNull JSStubElementType<? extends JSReferenceListStub, T> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/stubs/impl/JSReferenceListStubBase", "<init>"));
        }
        super(psi, parentStub, (IStubElementType)type);
        JSExpression[] expressions = psi.getExpressions();
        String[] toStore = new String[expressions.length];
        int currentEl = 0;
        for (JSExpression expression : expressions) {
            if (!(expression instanceof JSReferenceExpression) || !JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)expression)) continue;
            toStore[currentEl++] = expression.getText();
        }
        this.myRefs = StringRef.createArray((int)currentEl);
        for (int i = 0; i < currentEl; ++i) {
            this.myRefs[i] = StringRef.fromString((String)toStore[i]);
        }
    }

    public void index(IndexSink sink) {
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        dataStream.writeInt(this.myRefs.length);
        for (StringRef s : this.myRefs) {
            JSReferenceListStubBase.writeString(s, dataStream);
        }
    }

    @NotNull
    public String[] getReferenceTexts() {
        if (this.myRefs.length == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSReferenceListStubBase", "getReferenceTexts"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (this.myCachedStringRefs != null) {
            if (this.myCachedStringRefs == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSReferenceListStubBase", "getReferenceTexts"));
            }
            return this.myCachedStringRefs;
        }
        String[] result = new String[this.myRefs.length];
        for (int i = 0; i < result.length; ++i) {
            StringRef ref = this.myRefs[i];
            result[i] = StringRef.toString((StringRef)ref);
        }
        this.myCachedStringRefs = result;
        String[] stringArray = this.myCachedStringRefs;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSReferenceListStubBase", "getReferenceTexts"));
        }
        return stringArray;
    }
}

